/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.diagram.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreDiagramEditorPlugin;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreDiagramEditorUtil;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreNewDiagramFileWizard;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AcoreInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        action.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        EObject diagramRoot = null;
        try {
            Resource resource = resourceSet.getResource(this.domainModelURI, true);
            diagramRoot = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException ex) {
            AcoreDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + this.domainModelURI, ex);
        }
        if (diagramRoot == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.InitDiagramFile_ResourceErrorDialogTitle, (String)Messages.InitDiagramFile_ResourceErrorDialogMessage);
            return;
        }
        AcoreNewDiagramFileWizard wizard = new AcoreNewDiagramFileWizard(this.domainModelURI, diagramRoot, editingDomain);
        wizard.setWindowTitle(NLS.bind((String)Messages.InitDiagramFile_WizardTitle, (Object)"Acore"));
        AcoreDiagramEditorUtil.runWizard(this.getShell(), wizard, "InitDiagramFile");
    }
}

