/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AccessType implements Enumerator
{
    PUBLIC(0, "PUBLIC", "public"),
    PRIVATE(1, "PRIVATE", "private"),
    PROECTED(2, "PROECTED", "protected"),
    PACKAGE(3, "PACKAGE", "package");

    public static final String copyright = "Copyright (c) 2004 - 2011 Eike Stepper (Berlin, Germany) and others.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n \r\nContributors:\r\n    Martin Fluegge - initial API and implementation\r\n";
    public static final int PUBLIC_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROECTED_VALUE = 2;
    public static final int PACKAGE_VALUE = 3;
    private static final AccessType[] VALUES_ARRAY;
    public static final List<AccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessType[]{PUBLIC, PRIVATE, PROECTED, PACKAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROECTED;
            }
            case 3: {
                return PACKAGE;
            }
        }
        return null;
    }

    private AccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

