/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.helper;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;

public class EditorDescriptionHelper {
    public static String getEditorIdForDawnEditor(String resourceName) {
        IEditorDescriptor editorDescriptor = EditorDescriptionHelper.getEditorDescriptorForDawnEditor(resourceName);
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public static IEditorDescriptor getEditorDescriptorForDawnEditor(String resourceName) {
        IEditorDescriptor[] editors;
        IEditorDescriptor[] iEditorDescriptorArray = editors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(resourceName);
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n2];
            if (editorDescriptor.getId().contains(".Dawn")) {
                return editorDescriptor;
            }
            ++n2;
        }
        return null;
    }

    public static IEditorDescriptor getEditorDescriptorFromFirstEditor(String resourceName) {
        IEditorDescriptor[] editors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(resourceName);
        if (editors.length > 0) {
            return editors[0];
        }
        return null;
    }

    public static IEditorDescriptor getEditorDescriptorForDawnEditor(Resource resource) {
        return EditorDescriptionHelper.getEditorDescriptorForDawnEditor(resource.getURI().lastSegment());
    }

    public static Image getImageForEditor(String resourceName) {
        IEditorDescriptor editorDescriptor = EditorDescriptionHelper.getEditorDescriptorForDawnEditor(resourceName);
        if (editorDescriptor == null) {
            editorDescriptor = EditorDescriptionHelper.getEditorDescriptorFromFirstEditor(resourceName);
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getImageDescriptor().createImage();
        }
        return null;
    }
}

