/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.views;

import org.eclipse.emf.cdo.dawn.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.ui.helper.EditorDescriptionHelper;
import org.eclipse.emf.cdo.dawn.ui.views.DawnItemProvider;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnExplorer
extends CDOSessionsView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnExplorer.class);
    public static final String ID = "org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer";
    private CDOView view;

    public CDOView getView() {
        return this.view;
    }

    public DawnExplorer() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public void dispose() {
        this.view.close();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new DawnItemProvider(this.getSite().getPage(), this, new IElementFilter(){

            public boolean filter(Object element) {
                return element instanceof CDOSession;
            }
        });
    }

    protected void hookDoubleClick() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (obj instanceof CDOResource) {
                    String editorID;
                    CDOResource resource = (CDOResource)obj;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Opening CDOResource {0} ", new Object[]{resource});
                    }
                    if ((editorID = EditorDescriptionHelper.getEditorIdForDawnEditor(resource.getName())) != null && !editorID.equals("")) {
                        try {
                            DawnEditorInput editorInput = new DawnEditorInput(resource.getURI());
                            DawnExplorer.this.getSite().getPage().openEditor((IEditorInput)editorInput, editorID);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    } else {
                        CDOTransaction transaction = DawnExplorer.this.view.getSession().openTransaction();
                        CDOEditorInput editorInput = CDOEditorUtil.createCDOEditorInput((CDOView)transaction, (String)((CDOResource)obj).getPath(), (boolean)true);
                        try {
                            DawnExplorer.this.getSite().getPage().openEditor((IEditorInput)editorInput, "org.eclipse.emf.cdo.ui.CDOEditor");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

