/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.wizards;

import org.eclipse.emf.cdo.dawn.ui.composites.CDOResourceNodeChooserComposite;
import org.eclipse.emf.cdo.dawn.ui.messages.Messages;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DawnCreateNewResourceWizardPage
extends WizardPage {
    private Composite container;
    private boolean showResources;
    private final String fileExtension;
    private int resourceValidationType = 2;
    @Deprecated
    public static final int VALIDATION_WARN = 1;
    private final CDOView view;
    private boolean createAutomaticResourceName;
    protected CDOResourceNodeChooserComposite chooserComposite;

    public DawnCreateNewResourceWizardPage(String fileExtension) {
        this(fileExtension, true, null);
    }

    public DawnCreateNewResourceWizardPage(String fileExtension, boolean showResources, CDOView view) {
        super(Messages.DawnCreateNewResourceWizardPage_0);
        this.view = view;
        this.setTitle(Messages.DawnCreateNewResourceWizardPage_2);
        this.setDescription(Messages.DawnCreateNewResourceWizardPage_3);
        this.showResources = showResources;
        this.fileExtension = fileExtension;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.chooserComposite = new CDOResourceNodeChooserComposite(this.container, 0, this.fileExtension, this.view);
        this.chooserComposite.showResources(this.showResources);
        CDOResourceNodeChooserComposite.ResourceChooserValidator validator = this.chooserComposite.getValidator();
        validator.setResourceValidationType(this.resourceValidationType);
        validator.setValidationListener(new CDOResourceNodeChooserComposite.ValidationListener(){

            public void validationFinished() {
                DawnCreateNewResourceWizardPage.this.validatePage();
            }
        });
        if (this.createAutomaticResourceName) {
            this.chooserComposite.createAutomaticResourceName();
        }
        GridData gd = new GridData(1808);
        this.chooserComposite.setLayoutData(gd);
        this.setControl((Control)this.container);
        validator.validate();
    }

    private void validatePage() {
        System.out.println("validatePage");
        CDOResourceNodeChooserComposite.ResourceChooserValidator validator = this.chooserComposite.getValidator();
        boolean valid = validator.isValid();
        if (!valid) {
            int type = validator.getMessageType();
            this.setMessage(validator.getMessage(), type);
        } else {
            this.setMessage("");
        }
        this.setPageComplete(valid);
    }

    public URI getURI() {
        return this.chooserComposite.getURI();
    }

    public void setShowResources(boolean showResources) {
        this.showResources = showResources;
    }

    public boolean isShowResources() {
        return this.showResources;
    }

    public void setResourceNamePrefix(String resourceNamePrefix) {
        this.chooserComposite.setResourceNamePrefix(resourceNamePrefix);
        this.chooserComposite.setResourceName(resourceNamePrefix);
    }

    public String getResourceNamePrefix() {
        return this.chooserComposite.getResourceNamePrefix();
    }

    public void setResourcePath(String text) {
        if (!text.endsWith("/") || text.endsWith("\\")) {
            text = String.valueOf(text) + "/";
        }
        this.chooserComposite.setResourcePath(text);
    }

    public String getResourcePath() {
        return this.chooserComposite.getResourcePath();
    }

    public void setCreateAutomaticResourceName(boolean createAutomaticResourceName) {
        this.createAutomaticResourceName = createAutomaticResourceName;
    }

    public boolean isCreateAutomaticResourceName() {
        return this.createAutomaticResourceName;
    }

    public void setResourceValidationType(int resourceValidationType) {
        this.resourceValidationType = resourceValidationType;
    }

    public int getResourceValidationType() {
        return this.resourceValidationType;
    }

    public String getDefaultName() {
        return this.chooserComposite.getDefaultName();
    }
}

