/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.appearance;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.dawn.appearance.DawnEditPartStylizer;
import org.eclipse.emf.cdo.dawn.appearance.impl.DawnBasicConnectionEditPartStylizerImpl;
import org.eclipse.emf.cdo.dawn.appearance.impl.DawnBasicGraphicalEditPartStylizerImpl;
import org.eclipse.emf.cdo.dawn.appearance.impl.DawnBasicNodeEditPartStylizerImpl;
import org.eclipse.emf.cdo.dawn.appearance.impl.DawnBasicTextAwareEditPartStylizerImpl;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnEditPartStylizerRegistry {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnEditPartStylizerRegistry.class);
    private static final String DAWN_STYLIZER_EXTENSION_POINT_ID = "org.eclipse.emf.cdo.dawn.editpartstylizers";
    public static DawnEditPartStylizerRegistry instance = new DawnEditPartStylizerRegistry();
    private Map<String, DawnEditPartStylizer> registeredStylizers = new HashMap<String, DawnEditPartStylizer>();

    public DawnEditPartStylizer getStylizer(EditPart editPart) {
        DawnEditPartStylizer stylizer = this.registeredStylizers.get(editPart.getClass().getCanonicalName());
        if (stylizer == null) {
            stylizer = this.getStylizerFromExtensionPoint(editPart);
        }
        if (stylizer == null) {
            stylizer = this.getDefaultStylizer(editPart);
        }
        return stylizer;
    }

    private DawnEditPartStylizer getDefaultStylizer(EditPart editPart) {
        DawnEditPartStylizer stylizer = null;
        stylizer = editPart instanceof ConnectionEditPart ? new DawnBasicConnectionEditPartStylizerImpl() : (editPart instanceof NodeEditPart ? new DawnBasicNodeEditPartStylizerImpl() : (editPart instanceof DiagramEditPart ? new DawnBasicNodeEditPartStylizerImpl() : (editPart instanceof ITextAwareEditPart ? new DawnBasicTextAwareEditPartStylizerImpl() : new DawnBasicGraphicalEditPartStylizerImpl())));
        return stylizer;
    }

    private DawnEditPartStylizer getStylizerFromExtensionPoint(EditPart editPart) {
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DAWN_STYLIZER_EXTENSION_POINT_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (editPart.getClass().getCanonicalName().equals(e.getAttribute("editpart"))) {
                    DawnEditPartStylizer stylizer = (DawnEditPartStylizer)e.createExecutableExtension("stylizer");
                    this.registeredStylizers.put(editPart.getClass().getCanonicalName(), stylizer);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Registered DawnEditPartStylizer {0} ", new Object[]{stylizer});
                    }
                    return stylizer;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

