/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.notifications.IDawnListener;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class BasicDawnListener
implements IDawnListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, BasicDawnListener.class);
    protected IDawnEditor editor;

    public void setEditor(IDawnEditor editor) {
        this.editor = editor;
    }

    public BasicDawnListener() {
    }

    public BasicDawnListener(IDawnEditor editor) {
        this.editor = editor;
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOViewInvalidationEvent) {
            this.handleViewInvalidationEvent((CDOViewInvalidationEvent)event);
        } else if (event instanceof CDOTransactionConflictEvent) {
            this.handleTransactionConflictEvent((CDOTransactionConflictEvent)event);
        }
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("attachingObject {0}", new Object[]{object});
        }
        this.editor.setDirty();
    }

    public void detachingObject(CDOTransaction transaction, CDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("detachingObject {0}", new Object[]{object});
        }
        this.editor.setDirty();
    }

    public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
    }

    public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
    }

    public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
    }

    public void rolledBackTransaction(CDOTransaction transaction) {
    }

    public void handleViewInvalidationEvent(CDOViewInvalidationEvent event) {
    }

    public void handleTransactionConflictEvent(CDOTransactionConflictEvent event) {
    }
}

