/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.util.DawnResourceHelper;
import org.eclipse.emf.cdo.dawn.util.exceptions.EClassIncompatibleException;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredCreateConnectionViewAndElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DawnChangeHelper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnChangeHelper.class);
    protected static final Map<String, Boolean> options = new HashMap<String, Boolean>();
    protected static final Map<Object, Object> setElementOptions = new HashMap<Object, Object>();

    static {
        options.put("unprotected", Boolean.FALSE);
        options.put("silent", Boolean.TRUE);
        options.put("no_triggers", Boolean.TRUE);
    }

    public static EditPart createNode(Node node, IElementType elementType, DiagramEditPart diagramEP) {
        CreateViewRequest createViewRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)elementType, (PreferencesHint)diagramEP.getDiagramPreferencesHint());
        Bounds bounds = (Bounds)node.getLayoutConstraint();
        Point p = new Point(bounds.getX(), bounds.getY());
        Dimension dimension = new Dimension(bounds.getWidth(), bounds.getHeight());
        createViewRequest.setLocation(p);
        createViewRequest.setSize(dimension);
        diagramEP.performRequest((Request)createViewRequest);
        IAdaptable viewAdapter = (IAdaptable)((List)createViewRequest.getNewObject()).get(0);
        EditPartViewer viewer = diagramEP.getViewer();
        EditPart kep = (EditPart)viewer.getEditPartRegistry().get(viewAdapter.getAdapter(View.class));
        return kep;
    }

    public static EditPart createAttribute(Node node, IElementType elementType, IGraphicalEditPart parentEditpart) {
        if (TRACER.isEnabled()) {
            TRACER.format("ElementType: {0}  semanticHint {1}", new Object[]{elementType, ((IHintedType)elementType).getSemanticHint()});
        }
        CreateElementRequest request = new CreateElementRequest(elementType);
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(request);
        CreateViewAndElementRequest.ViewAndElementDescriptor viewAndElementDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(createElementRequestAdapter, Node.class, ((IHintedType)elementType).getSemanticHint(), parentEditpart.getDiagramPreferencesHint());
        CreateViewAndElementRequest createViewRequest = new CreateViewAndElementRequest(viewAndElementDescriptor);
        parentEditpart.performRequest((Request)createViewRequest);
        IAdaptable viewAdapter = (IAdaptable)((List)createViewRequest.getNewObject()).get(0);
        EditPartViewer viewer = parentEditpart.getViewer();
        EditPart kep = (EditPart)viewer.getEditPartRegistry().get(viewAdapter.getAdapter(View.class));
        return kep;
    }

    public static EditPart createEditPart(Point p, IElementType elementType, DiagramDocumentEditor diagramEditor) {
        DiagramEditPart diagramEP = diagramEditor.getDiagramEditPart();
        CreateViewRequest createViewRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)elementType, (PreferencesHint)diagramEP.getDiagramPreferencesHint());
        createViewRequest.setLocation(p);
        diagramEP.performRequest((Request)createViewRequest);
        IAdaptable viewAdapter = (IAdaptable)((List)createViewRequest.getNewObject()).get(0);
        EditPartViewer viewer = diagramEP.getViewer();
        return (EditPart)viewer.getEditPartRegistry().get(viewAdapter.getAdapter(View.class));
    }

    public static void setProperty(EditPart editPart, String name, String packageUtilPropertyID, Object object, DiagramDocumentEditor dawnDiagramEditor) {
        SetPropertyCommand setPropertyCommand = new SetPropertyCommand(dawnDiagramEditor.getEditingDomain(), (IAdaptable)editPart, packageUtilPropertyID, name, object);
        DiagramEditPart diagramEP = dawnDiagramEditor.getDiagramEditPart();
        diagramEP.getDiagramEditDomain().getDiagramCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)setPropertyCommand));
    }

    public static void resizeEditPart(EditPart editpart, Dimension d) {
        boolean editModeEnabled = ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)editpart).isEditModeEnabled();
        if (!editModeEnabled) {
            ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)editpart).enableEditMode();
        }
        ChangeBoundsRequest move_req = new ChangeBoundsRequest((Object)"resize");
        move_req.setResizeDirection(20);
        Bounds b = (Bounds)((Node)editpart.getModel()).getLayoutConstraint();
        Dimension dimensionDelta = new Dimension(d.width - b.getWidth(), d.height - b.getHeight());
        move_req.setSizeDelta(dimensionDelta);
        org.eclipse.gef.commands.Command cmd = editpart.getCommand((Request)move_req);
        if (cmd == null || !cmd.canExecute()) {
            throw new IllegalArgumentException("Command is not executable.");
        }
        ((DiagramEditPart)editpart.getParent()).getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
        if (editModeEnabled) {
            ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)editpart).enableEditMode();
        } else {
            ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)editpart).disableEditMode();
        }
    }

    public static void moveEditPart(EditPart editpart, Point p) {
        ChangeBoundsRequest move_req = new ChangeBoundsRequest((Object)"move");
        Bounds b = (Bounds)((Node)editpart.getModel()).getLayoutConstraint();
        Point newPoint = new Point(p.x - b.getX(), p.y - b.getY());
        move_req.setMoveDelta(newPoint);
        org.eclipse.gef.commands.Command cmd = editpart.getCommand((Request)move_req);
        if (cmd == null || !cmd.canExecute()) {
            throw new IllegalArgumentException("Command is not executable.");
        }
        ((DiagramEditPart)editpart.getParent()).getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
    }

    public static void moveEditPartTo(EditPart editpart, Point p) {
        ChangeBoundsRequest move_req = new ChangeBoundsRequest((Object)"move");
        move_req.setMoveDelta(p);
        org.eclipse.gef.commands.Command cmd = editpart.getCommand((Request)move_req);
        if (cmd == null || !cmd.canExecute()) {
            throw new IllegalArgumentException("Command is not executable.");
        }
        ((DiagramEditPart)editpart.getParent()).getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
    }

    public static void deleteEditPart(EditPart editPart, DiagramDocumentEditor editor) {
        final View view = (View)editPart.getModel();
        EObject eObject = view.getElement();
        if (eObject != null) {
            DestroyElementRequest destroy = new DestroyElementRequest(editor.getEditingDomain(), eObject, false);
            EditCommandRequestWrapper req = new EditCommandRequestWrapper((IEditCommandRequest)destroy);
            org.eclipse.gef.commands.Command command = editPart.getCommand((Request)req);
            editor.getDiagramEditDomain().getDiagramCommandStack().execute(command);
        }
        TransactionalEditingDomain domain = editor.getEditingDomain();
        if (view instanceof Edge) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    Edge e = (Edge)view;
                    View source = e.getSource();
                    View target = e.getTarget();
                    if (source != null && target != null) {
                        EObject targetElement = target.getElement();
                        EObject sourceElement = source.getElement();
                        EStructuralFeature containingFeature = sourceElement.eContainingFeature();
                        Collection sourceCrossreferenceCollection = (Collection)sourceElement.eGet(containingFeature);
                        sourceCrossreferenceCollection.remove(targetElement);
                    }
                }
            });
        }
        ViewUtil.destroy((View)view);
    }

    public static void deleteView(View view, DiagramDocumentEditor editor) {
        EObject eObject;
        if (TRACER.isEnabled()) {
            TRACER.format("Deleting view {0} ", new Object[]{view});
        }
        if ((eObject = view.getElement()) != null) {
            DestroyElementRequest destroy = new DestroyElementRequest(editor.getEditingDomain(), eObject, false);
            EditCommandRequestWrapper req = new EditCommandRequestWrapper((IEditCommandRequest)destroy);
            EditPart findEditPart = DawnDiagramUpdater.findEditPart((View)view, (EditPartViewer)editor.getDiagramEditPart().getViewer());
            org.eclipse.gef.commands.Command command = findEditPart.getCommand((Request)req);
            editor.getDiagramEditDomain().getDiagramCommandStack().execute(command);
        }
        if (view instanceof Edge) {
            DawnChangeHelper.destroyEdge((Edge)view, editor);
        }
        ViewUtil.destroy((View)view);
    }

    public static void destroyEdge(Edge edge, DiagramDocumentEditor editor) {
        EObject referenceObject = ViewUtil.resolveSemanticElement((View)edge.getTarget());
        EObject container = ViewUtil.resolveSemanticElement((View)edge.getSource());
        EditPart parentEditpart = DawnDiagramUpdater.findEditPart((View)edge, (EditPartViewer)editor.getDiagramEditPart().getViewer());
        DestroyReferenceRequest destroyReferenceRequest = new DestroyReferenceRequest(editor.getEditingDomain(), container, null, referenceObject, false);
        EditCommandRequestWrapper req = new EditCommandRequestWrapper((IEditCommandRequest)destroyReferenceRequest);
        org.eclipse.gef.commands.Command command = parentEditpart.getCommand((Request)req);
        editor.getDiagramEditDomain().getDiagramCommandStack().execute(command);
    }

    public static EditPart createEdge(Edge oldEdge, EditPart sourceEditPart, EditPart targetEditPart, IElementType elementType, DiagramEditPart root) {
        if (TRACER.isEnabled()) {
            TRACER.format("Creaeting Edge from old edge {0} ", new Object[]{oldEdge});
        }
        CreateConnectionViewAndElementRequest req = new CreateConnectionViewAndElementRequest(elementType, ((IHintedType)elementType).getSemanticHint(), root.getDiagramPreferencesHint());
        DeferredCreateConnectionViewAndElementCommand createConnectionCmd = new DeferredCreateConnectionViewAndElementCommand(req, (IAdaptable)new EObjectAdapter((EObject)sourceEditPart.getModel()), (IAdaptable)new EObjectAdapter((EObject)targetEditPart.getModel()), root.getViewer());
        root.getDiagramEditDomain().getDiagramCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)createConnectionCmd));
        EditPartViewer viewer = root.getViewer();
        EditPart ret = (EditPart)viewer.getEditPartRegistry().get(((CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor)req.getNewObject()).getAdapter(View.class));
        if (ret != null) {
            DawnChangeHelper.setAnchorsAndBendPoints(ret, oldEdge, root);
        }
        return ret;
    }

    public static void setAnchorsAndBendPoints(final EditPart edgeEditpart, final Edge oldEdge, final DiagramEditPart root) {
        TransactionalEditingDomain domain = root.getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            public void doExecute() {
                Edge edge = (Edge)edgeEditpart.getModel();
                edge.setBendpoints((Bendpoints)DawnResourceHelper.createCopy((EObject)oldEdge.getBendpoints()));
                if (oldEdge.getSourceAnchor() != null) {
                    edge.setSourceAnchor((Anchor)DawnResourceHelper.createCopy((EObject)oldEdge.getSourceAnchor()));
                }
                if (oldEdge.getTargetAnchor() != null) {
                    edge.setTargetAnchor((Anchor)DawnResourceHelper.createCopy((EObject)oldEdge.getTargetAnchor()));
                }
                edgeEditpart.refresh();
                root.refresh();
            }
        });
    }

    public static Color getBorderColor(EditPart editPart) {
        GraphicalEditPart e = (GraphicalEditPart)editPart;
        Border border = e.getFigure().getBorder();
        if (border instanceof MarginBorder) {
            return null;
        }
        if (border instanceof LineBorder) {
            LineBorder b = (LineBorder)e.getFigure().getBorder();
            return b.getColor();
        }
        return null;
    }

    public static void activateEditPart(final EditPart e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                e.activate();
                org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart g = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)e;
                g.getFigure().setEnabled(true);
            }
        });
    }

    public static void activateDiagramEditPart(DiagramEditPart diagramEditPart) {
        DawnChangeHelper.activateEditPart((EditPart)diagramEditPart);
        for (Object e : diagramEditPart.getChildren()) {
            DawnChangeHelper.activateEditPart((EditPart)e);
        }
    }

    public static void deactivateEditPart(final EditPart e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                e.deactivate();
                e.getViewer().deselect(e);
                org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart g = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)e;
                g.getFigure().setEnabled(false);
            }
        });
    }

    public static void deactivateDiagramEditPart(DiagramEditPart diagramEditPart) {
        DawnChangeHelper.deactivateEditPart((EditPart)diagramEditPart);
        for (Object e : diagramEditPart.getChildren()) {
            DawnChangeHelper.deactivateEditPart((EditPart)e);
        }
    }

    public static void deselect(final EditPart e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                e.getViewer().deselect(e);
            }
        });
    }

    public static void select(final EditPart e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                e.getViewer().select(e);
            }
        });
    }

    public static void setProperty(EditPart editPart, String name, EAttribute attribute, Object object, DiagramDocumentEditor dawnDiagramEditor) {
        SetPropertyCommand setPropertyCommand = new SetPropertyCommand(dawnDiagramEditor.getEditingDomain(), (IAdaptable)editPart, PackageUtil.getID((ENamedElement)attribute), name, object);
        DiagramEditPart diagramEP = dawnDiagramEditor.getDiagramEditPart();
        diagramEP.getDiagramEditDomain().getDiagramCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)setPropertyCommand));
    }

    public static void updateModel(EditPart editPart, final EObject model, DiagramDocumentEditor editor) {
        editPart.getViewer().getEditDomain();
        View view = (View)editPart.getModel();
        final EObject element = view.getElement();
        if (element.eClass().getName().equals("AnOperation")) {
            editor.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(editor.getEditingDomain()){

                public void doExecute() {
                    try {
                        DawnResourceHelper.updateEObject((EObject)element, (EObject)model);
                    }
                    catch (EClassIncompatibleException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            for (EAttribute attribute : element.eClass().getEAllAttributes()) {
                DawnChangeHelper.setProperty(editPart, attribute.getName(), attribute, model.eGet((EStructuralFeature)attribute), editor);
            }
        }
    }

    public static void deleteAttribute(View view, DiagramDocumentEditor editor) {
        DawnChangeHelper.deleteView(view, editor);
    }
}

