/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.synchronize;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.dawn.appearance.DawnAppearancer;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnConflictHelper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnConflictHelper.class);

    public static boolean handleConflictedView(CDOObject cdoObject, View view, DiagramDocumentEditor editor) {
        boolean cdoConflict = cdoObject.cdoConflict();
        if (cdoConflict && view != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Object ({0}) is in state conflict!", new Object[]{cdoObject});
            }
            EditPart editPart = DawnDiagramUpdater.createOrFindEditPartIfViewExists((View)view, (DiagramDocumentEditor)editor);
            int typeConflictLocallyDeleted = DawnConflictHelper.evaluateConflictType(cdoObject);
            DawnAppearancer.setEdiPartConflicted(editPart, typeConflictLocallyDeleted);
        }
        return cdoConflict;
    }

    private static int evaluateConflictType(CDOObject cdoObject) {
        if (cdoObject.cdoState() == CDOState.DIRTY) {
            return 2;
        }
        return 1;
    }

    public static void rollback(final DiagramDocumentEditor editor) {
        CDOView view = ((IDawnEditor)editor).getView();
        if (view != null && view instanceof CDOTransaction) {
            ((CDOTransaction)view).rollback();
        }
        editor.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(editor.getEditingDomain()){

            public void doExecute() {
                DawnAppearancer.setEditPartDefaultAllChildren((EditPart)editor.getDiagramEditPart());
                DawnDiagramUpdater.refreshEditPart((EditPart)editor.getDiagramEditPart());
            }
        });
    }

    public static boolean isConflicted(EObject object) {
        CDOObject element;
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
        if (cdoObject.cdoConflict()) {
            return true;
        }
        return object instanceof View && (element = CDOUtil.getCDOObject((EObject)((View)object).getElement())).cdoConflict();
    }
}

