/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.location;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.emf.cdo.internal.location.BranchCheckoutSource;
import org.eclipse.emf.cdo.internal.location.RepositoryLocationManager;
import org.eclipse.emf.cdo.location.ICheckoutSource;
import org.eclipse.emf.cdo.location.IRepositoryLocation;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocation
extends Container<ICheckoutSource>
implements IRepositoryLocation {
    private static final String PROP_CONNECTOR_TYPE = "connector.type";
    private static final String PROP_CONNECTOR_DESCRIPTION = "connector.description";
    private static final String PROP_REPOSITORY_NAME = "repository.name";
    private RepositoryLocationManager manager;
    private String connectorType;
    private String connectorDescription;
    private String repositoryName;
    private ICheckoutSource[] elements = new ICheckoutSource[]{new BranchCheckoutSource.Main(this)};

    public RepositoryLocation(RepositoryLocationManager manager, String connectorType, String connectorDescription, String repositoryName) {
        this.manager = manager;
        this.connectorType = connectorType;
        this.connectorDescription = connectorDescription;
        this.repositoryName = repositoryName;
        this.activate();
    }

    public RepositoryLocation(RepositoryLocationManager manager, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        this.manager = manager;
        this.connectorType = properties.getProperty(PROP_CONNECTOR_TYPE);
        this.connectorDescription = properties.getProperty(PROP_CONNECTOR_DESCRIPTION);
        this.repositoryName = properties.getProperty(PROP_REPOSITORY_NAME);
        this.activate();
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Properties properties = new Properties();
        properties.put(PROP_CONNECTOR_TYPE, this.connectorType);
        properties.put(PROP_CONNECTOR_DESCRIPTION, this.connectorDescription);
        properties.put(PROP_REPOSITORY_NAME, this.repositoryName);
        properties.store(out, "Repository Location");
    }

    @Override
    public RepositoryLocationManager getManager() {
        return this.manager;
    }

    @Override
    public String getConnectorType() {
        return this.connectorType;
    }

    @Override
    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public ICheckoutSource[] getElements() {
        return this.elements;
    }

    public org.eclipse.emf.cdo.session.CDOSessionConfiguration createSessionConfiguration() {
        IConnector connector = this.getConnector();
        CDOSessionConfiguration config = CDONet4jUtil.createSessionConfiguration();
        config.setConnector(connector);
        config.setRepositoryName(this.getRepositoryName());
        return config;
    }

    @Override
    public void delete() {
        if (this.manager != null) {
            this.manager.removeRepositoryLocation(this);
            this.manager = null;
            this.connectorType = null;
            this.connectorDescription = null;
            this.repositoryName = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IRepositoryLocation) {
            IRepositoryLocation that = (IRepositoryLocation)obj;
            return ObjectUtil.equals((Object)this.connectorType, (Object)that.getConnectorType()) && ObjectUtil.equals((Object)this.connectorDescription, (Object)that.getConnectorDescription()) && ObjectUtil.equals((Object)this.repositoryName, (Object)that.getRepositoryName());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.connectorType) ^ ObjectUtil.hashCode((Object)this.connectorDescription) ^ ObjectUtil.hashCode((Object)this.repositoryName);
    }

    public String toString() {
        return String.valueOf(this.connectorType) + "://" + this.connectorDescription + "/" + this.repositoryName;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    private IConnector getConnector() {
        IManagedContainer container = this.getContainer();
        return Net4jUtil.getConnector((IManagedContainer)container, (String)this.connectorType, (String)this.connectorDescription);
    }
}

