/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.session.CDOSessionFactory;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

public class Net4jSessionFactory
extends CDOSessionFactory {
    public static final String TYPE = "cdo";

    public Net4jSessionFactory() {
        super(TYPE);
    }

    protected InternalCDOSession createSession(String repositoryName, boolean automaticPackageRegistry) {
        CDOSessionConfiguration configuration = CDONet4jUtil.createSessionConfiguration();
        configuration.setRepositoryName(repositoryName);
        configuration.getAuthenticator().setCredentialsProvider(this.getCredentialsProvider());
        configuration.setActivateOnOpen(false);
        return (InternalCDOSession)configuration.openSession();
    }

    protected IPasswordCredentialsProvider getCredentialsProvider() {
        try {
            IManagedContainer container = this.getManagedContainer();
            String type = this.getCredentialsProviderType();
            return (IPasswordCredentialsProvider)container.getElement("org.eclipse.net4j.util.security.credentialsProviders", type, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected IManagedContainer getManagedContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected String getCredentialsProviderType() {
        return "interactive";
    }

    public static CDOSession get(IManagedContainer container, String description) {
        return (CDOSession)container.getElement("org.eclipse.emf.cdo.sessions", TYPE, description);
    }
}

