/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitTransactionRequest;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDelegationRequest
extends CommitTransactionRequest {
    private static final int UNKNOWN_TRANSACTION_ID = 0;
    private CDOBranch branch;
    private String userID;
    private Map<CDOID, EClass> detachedObjectTypes;

    public CommitDelegationRequest(CDOClientProtocol protocol, CDOBranch branch, String userID, String comment, CDOCommitData commitData, Map<CDOID, EClass> detachedObjectTypes, Collection<CDOLob<?>> lobs) {
        super(protocol, (short)12, 0, comment, false, CDOIDProvider.NOOP, commitData, lobs);
        this.branch = branch;
        this.userID = userID;
        this.detachedObjectTypes = detachedObjectTypes;
    }

    @Override
    protected void requestingTransactionInfo(CDODataOutput out) throws IOException {
        out.writeCDOBranch(this.branch);
        out.writeString(this.userID);
    }

    @Override
    protected EClass getObjectType(CDOID id) {
        return this.detachedObjectTypes.get(id);
    }
}

