/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockObjectsRequest
extends CDOClientRequest<CDOSessionProtocol.LockObjectsResult> {
    private int viewID;
    private IRWLockManager.LockType lockType;
    private long timeout;
    private List<InternalCDORevision> viewedRevisions;
    private CDOBranch viewedBranch;

    public LockObjectsRequest(CDOClientProtocol protocol, List<InternalCDORevision> viewedRevisions, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, long timeout) {
        super(protocol, (short)24);
        this.viewID = viewID;
        this.lockType = lockType;
        this.timeout = timeout;
        this.viewedRevisions = viewedRevisions;
        this.viewedBranch = viewedBranch;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        out.writeCDOLockType(this.lockType);
        out.writeLong(this.timeout);
        out.writeCDOBranch(this.viewedBranch);
        out.writeInt(this.viewedRevisions.size());
        for (CDORevision cDORevision : this.viewedRevisions) {
            out.writeCDORevisionKey((CDORevisionKey)cDORevision);
        }
    }

    @Override
    protected CDOSessionProtocol.LockObjectsResult confirming(CDODataInput in) throws IOException {
        boolean succesful = in.readBoolean();
        if (succesful) {
            boolean clientMustWait = in.readBoolean();
            long requiredTimestamp = 0L;
            if (clientMustWait) {
                requiredTimestamp = in.readLong();
            }
            return new CDOSessionProtocol.LockObjectsResult(true, false, clientMustWait, requiredTimestamp, null);
        }
        boolean timedOut = in.readBoolean();
        if (timedOut) {
            return new CDOSessionProtocol.LockObjectsResult(false, true, false, 0L, null);
        }
        int nStaleRevisions = in.readInt();
        CDORevisionKey[] staleRevisions = new CDORevisionKey[nStaleRevisions];
        int i = 0;
        while (i < nStaleRevisions) {
            staleRevisions[i] = in.readCDORevisionKey();
            ++i;
        }
        return new CDOSessionProtocol.LockObjectsResult(false, false, false, 0L, staleRevisions);
    }
}

