/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicateRepositoryRequest
extends CDOClientRequest<Boolean> {
    private CDOReplicationContext context;

    public ReplicateRepositoryRequest(CDOClientProtocol protocol, CDOReplicationContext context, OMMonitor monitor) {
        super(protocol, (short)42);
        this.context = context;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.context.getLastReplicatedBranchID());
        out.writeLong(this.context.getLastReplicatedCommitTime());
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        byte opcode;
        block5: while (true) {
            opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.context.handleBranch(in.readCDOBranch());
                    continue block5;
                }
                case 2: {
                    this.context.handleCommitInfo(in.readCDOCommitInfo());
                    continue block5;
                }
            }
            break;
        }
        throw new IOException("Invalid replicate opcode: " + opcode);
    }
}

