/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnlockObjectsRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, UnlockObjectsRequest.class);
    private CDOView view;
    private Collection<? extends CDOObject> objects;
    private IRWLockManager.LockType lockType;

    public UnlockObjectsRequest(CDOClientProtocol protocol, CDOView view, Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        super(protocol, (short)25);
        this.view = view;
        this.objects = objects;
        this.lockType = lockType;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.view.getViewID());
        out.writeCDOLockType(this.lockType);
        if (this.objects == null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unlocking all objects for view {0}", new Object[]{this.view.getViewID()});
            }
            out.writeInt(-1);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Unlocking of type {0} requested for view {1}", new Object[]{this.lockType == IRWLockManager.LockType.READ ? "read" : "write", this.view.getViewID()});
            }
            out.writeInt(this.objects.size());
            for (CDOObject cDOObject : this.objects) {
                CDOID id = cDOObject.cdoID();
                if (TRACER.isEnabled()) {
                    TRACER.format("Unlocking requested for object {0}", new Object[]{id});
                }
                out.writeCDOID(id);
            }
        }
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        return in.readBoolean();
    }
}

