/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBSchema;

public class CDODBSchema
extends DBSchema {
    public static final CDODBSchema INSTANCE = new CDODBSchema();
    public static final IDBTable PROPERTIES = INSTANCE.addTable("cdo_properties");
    public static final IDBField PROPERTIES_NAME = PROPERTIES.addField("name", DBType.VARCHAR, 255);
    public static final IDBField PROPERTIES_VALUE = PROPERTIES.addField("value", DBType.LONGVARCHAR);
    public static final IDBIndex INDEX_PROPERTIES_PK = PROPERTIES.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PROPERTIES_NAME});
    public static final String SQL_DELETE_PROPERTIES = "DELETE FROM " + PROPERTIES + " WHERE " + PROPERTIES_NAME + "=?";
    public static final String SQL_INSERT_PROPERTIES = "INSERT INTO " + PROPERTIES + " (" + PROPERTIES_NAME + ", " + PROPERTIES_VALUE + ") VALUES (?, ?)";
    public static final String SQL_SELECT_PROPERTIES = "SELECT " + PROPERTIES_VALUE + " FROM " + PROPERTIES + " WHERE " + PROPERTIES_NAME + "=?";
    public static final String SQL_SELECT_ALL_PROPERTIES = "SELECT " + PROPERTIES_NAME + ", " + PROPERTIES_VALUE + " FROM " + PROPERTIES;
    public static final IDBTable PACKAGE_UNITS = INSTANCE.addTable("cdo_package_units");
    public static final IDBField PACKAGE_UNITS_ID = PACKAGE_UNITS.addField("id", DBType.VARCHAR, 255);
    public static final IDBField PACKAGE_UNITS_ORIGINAL_TYPE = PACKAGE_UNITS.addField("original_type", DBType.INTEGER);
    public static final IDBField PACKAGE_UNITS_TIME_STAMP = PACKAGE_UNITS.addField("time_stamp", DBType.BIGINT);
    public static final IDBField PACKAGE_UNITS_PACKAGE_DATA = PACKAGE_UNITS.addField("package_data", DBType.BLOB);
    public static final IDBIndex INDEX_PACKAGE_UNITS_PK = PACKAGE_UNITS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PACKAGE_UNITS_ID});
    public static final IDBTable PACKAGE_INFOS = INSTANCE.addTable("cdo_package_infos");
    public static final IDBField PACKAGE_INFOS_URI = PACKAGE_INFOS.addField("uri", DBType.VARCHAR, 255);
    public static final IDBField PACKAGE_INFOS_PARENT = PACKAGE_INFOS.addField("parent", DBType.VARCHAR, 255);
    public static final IDBField PACKAGE_INFOS_UNIT = PACKAGE_INFOS.addField("unit", DBType.VARCHAR, 255);
    public static final IDBIndex INDEX_PACKAGE_INFOS_PK = PACKAGE_INFOS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{PACKAGE_INFOS_URI});
    public static final IDBIndex INDEX_PACKAGE_INFOS_PARENT = PACKAGE_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{PACKAGE_INFOS_PARENT});
    public static final IDBIndex INDEX_PACKAGE_INFOS_UNIT = PACKAGE_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{PACKAGE_INFOS_UNIT});
    public static final IDBTable BRANCHES = INSTANCE.addTable("cdo_branches");
    public static final IDBField BRANCHES_ID = BRANCHES.addField("id", DBType.INTEGER);
    public static final IDBField BRANCHES_NAME = BRANCHES.addField("name", DBType.VARCHAR);
    public static final IDBField BRANCHES_BASE_BRANCH_ID = BRANCHES.addField("base_id", DBType.INTEGER);
    public static final IDBField BRANCHES_BASE_TIMESTAMP = BRANCHES.addField("base_time", DBType.BIGINT);
    public static final IDBIndex INDEX_BRANCHES_ID = BRANCHES.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{BRANCHES_ID});
    public static final String SQL_CREATE_BRANCH = "INSERT INTO " + BRANCHES + " (" + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + ") VALUES (?, ?, ?, ?)";
    public static final String SQL_LOAD_BRANCH = "SELECT " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_ID + "=?";
    public static final String SQL_LOAD_SUB_BRANCHES = "SELECT " + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_BASE_BRANCH_ID + "=?";
    public static final String SQL_LOAD_BRANCHES = "SELECT " + BRANCHES_ID + ", " + BRANCHES_NAME + ", " + BRANCHES_BASE_BRANCH_ID + ", " + BRANCHES_BASE_TIMESTAMP + " FROM " + BRANCHES + " WHERE " + BRANCHES_ID + " BETWEEN ? AND ? ORDER BY " + BRANCHES_ID;
    public static final IDBTable COMMIT_INFOS = INSTANCE.addTable("cdo_commit_infos");
    public static final IDBField COMMIT_INFOS_TIMESTAMP = COMMIT_INFOS.addField("commit_time", DBType.BIGINT);
    public static final IDBField COMMIT_INFOS_PREVIOUS_TIMESTAMP = COMMIT_INFOS.addField("previous_time", DBType.BIGINT);
    public static final IDBField COMMIT_INFOS_BRANCH = COMMIT_INFOS.addField("branch_id", DBType.INTEGER);
    public static final IDBField COMMIT_INFOS_USER = COMMIT_INFOS.addField("user_id", DBType.VARCHAR);
    public static final IDBField COMMIT_INFOS_COMMENT = COMMIT_INFOS.addField("commit_comment", DBType.VARCHAR);
    public static final IDBIndex INDEX_COMMIT_INFOS_PK = COMMIT_INFOS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{COMMIT_INFOS_TIMESTAMP});
    public static final IDBIndex INDEX_COMMIT_INFOS_BRANCH = COMMIT_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{COMMIT_INFOS_BRANCH});
    public static final IDBIndex INDEX_COMMIT_INFOS_USER = COMMIT_INFOS.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{COMMIT_INFOS_USER});
    public static final String SQL_CREATE_COMMIT_INFO = "INSERT INTO " + COMMIT_INFOS + "(" + COMMIT_INFOS_TIMESTAMP + ", " + COMMIT_INFOS_PREVIOUS_TIMESTAMP + ", " + COMMIT_INFOS_BRANCH + ", " + COMMIT_INFOS_USER + ", " + COMMIT_INFOS_COMMENT + ") " + "VALUES (?, ?, ?, ?, ?)";
    public static final IDBTable LOBS = INSTANCE.addTable("cdo_lobs");
    public static final IDBField LOBS_ID = LOBS.addField("id", DBType.VARCHAR, 64);
    public static final IDBField LOBS_SIZE = LOBS.addField("size", DBType.BIGINT);
    public static final IDBField LOBS_BDATA = LOBS.addField("bdata", DBType.BLOB);
    public static final IDBField LOBS_CDATA = LOBS.addField("cdata", DBType.CLOB);
    public static final IDBIndex INDEX_LOBS_ID = LOBS.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{LOBS_ID});
    public static final String SQL_QUERY_LOBS = "SELECT 1 FROM " + LOBS + " WHERE " + LOBS_ID + "=?";
    public static final String SQL_HANDLE_LOBS = "SELECT " + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_BDATA + ", " + LOBS_CDATA + " FROM " + LOBS;
    public static final String SQL_LOAD_LOB = "SELECT " + LOBS_SIZE + ", " + LOBS_BDATA + ", " + LOBS_CDATA + " FROM " + LOBS + " WHERE " + LOBS_ID + "=?";
    public static final String SQL_WRITE_BLOB = "INSERT INTO " + LOBS + "(" + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_BDATA + ") VALUES(?, ?, ?)";
    public static final String SQL_WRITE_CLOB = "INSERT INTO " + LOBS + "(" + LOBS_ID + ", " + LOBS_SIZE + ", " + LOBS_CDATA + ") VALUES(?, ?, ?)";
    public static final String CDO_OBJECTS = "cdo_objects";
    public static final String ATTRIBUTES_ID = "cdo_id";
    public static final String ATTRIBUTES_BRANCH = "cdo_branch";
    public static final String ATTRIBUTES_VERSION = "cdo_version";
    public static final String ATTRIBUTES_CLASS = "cdo_class";
    public static final String ATTRIBUTES_CREATED = "cdo_created";
    public static final String ATTRIBUTES_REVISED = "cdo_revised";
    public static final String ATTRIBUTES_RESOURCE = "cdo_resource";
    public static final String ATTRIBUTES_CONTAINER = "cdo_container";
    public static final String ATTRIBUTES_FEATURE = "cdo_feature";
    public static final String LIST_FEATURE = "cdo_feature";
    public static final String LIST_REVISION_ID = "cdo_source";
    public static final String LIST_REVISION_VERSION = "cdo_version";
    public static final String LIST_REVISION_VERSION_ADDED = "cdo_version_added";
    public static final String LIST_REVISION_VERSION_REMOVED = "cdo_version_removed";
    public static final String LIST_REVISION_BRANCH = "cdo_branch";
    public static final String LIST_IDX = "cdo_idx";
    public static final String LIST_VALUE = "cdo_value";
    public static final String FEATUREMAP_REVISION_ID = "cdo_id";
    public static final String FEATUREMAP_VERSION = "cdo_version";
    public static final String FEATUREMAP_VERSION_ADDED = "cdo_version_added";
    public static final String FEATUREMAP_VERSION_REMOVED = "cdo_version_removed";
    public static final String FEATUREMAP_BRANCH = "cdo_branch";
    public static final String FEATUREMAP_IDX = "cdo_idx";
    public static final String FEATUREMAP_TAG = "cdo_tag";
    public static final String FEATUREMAP_VALUE = "cdo_value";

    static {
        INSTANCE.lock();
    }

    private CDODBSchema() {
        super("CDO");
    }
}

