/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class WrappedPreparedStatement {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, WrappedPreparedStatement.class);
    private PreparedStatement wrappedStatement;

    public WrappedPreparedStatement(PreparedStatement ps) {
        this.wrappedStatement = ps;
        if (TRACER.isEnabled()) {
            TRACER.format("Wrapping Statement: {0}", new Object[]{this.wrappedStatement});
        }
    }

    public PreparedStatement getWrappedStatement() {
        return this.wrappedStatement;
    }

    public PreparedStatement unwrapStatement() {
        if (TRACER.isEnabled()) {
            TRACER.format("UnWrapping Statement: {0}", new Object[]{this.wrappedStatement});
        }
        PreparedStatement result = this.wrappedStatement;
        this.wrappedStatement = null;
        return result;
    }

    public String toString() {
        return MessageFormat.format("Wrapped[{0}]", this.wrappedStatement);
    }

    protected void finalize() throws Throwable {
        if (this.wrappedStatement != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Closing statement: {0}", new Object[]{this.wrappedStatement});
            }
            DBUtil.close((Statement)this.wrappedStatement);
            this.wrappedStatement = null;
        }
    }
}

