/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditFeatureMapTableMappingWithRanges
extends BasicAbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AuditFeatureMapTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private IDBTable table;
    private HashMap<CDOID, String> tagMap;
    private List<String> columnNames;
    private Map<CDOID, ITypeMapping> typeMappings;
    private List<DBType> dbTypes;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsert;
    private String sqlRemoveEntry;
    private String sqlDeleteEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;
    private String sqlDeleteList;

    public AuditFeatureMapTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initDBTypes();
        this.initTable();
        this.initSQLStrings();
    }

    private void initDBTypes() {
        ITypeMapping.Registry registry = ITypeMapping.Registry.INSTANCE;
        this.dbTypes = new ArrayList<DBType>(registry.getDefaultFeatureMapDBTypes());
    }

    private void initTable() {
        IDBStore store = this.getMappingStrategy().getStore();
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.table = store.getDBSchema().addTable(tableName);
        IDBField idField = this.table.addField("cdo_id", DBType.INTEGER);
        IDBField versionAddedField = this.table.addField("cdo_version_added", DBType.INTEGER);
        IDBField versionRemovedField = this.table.addField("cdo_version_removed", DBType.INTEGER);
        IDBField idxField = this.table.addField("cdo_idx", DBType.INTEGER);
        IDBField tagField = this.table.addField("cdo_tag", store.getIDHandler().getDBType());
        this.tagMap = new HashMap();
        this.typeMappings = new HashMap<CDOID, ITypeMapping>();
        this.columnNames = new ArrayList<String>();
        for (DBType type : this.getDBTypes()) {
            String column = "cdo_value_" + type.name();
            this.table.addField(column, type);
            this.columnNames.add(column);
        }
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{versionAddedField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{versionRemovedField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idxField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{tagField});
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_tag");
        builder.append(", ");
        Iterator<String> iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("<=? AND (");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL OR ");
        builder.append("cdo_version_removed");
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version_added");
        builder.append(", ");
        builder.append("cdo_version_removed");
        builder.append(", ");
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_tag");
        int i = 0;
        while (i < this.columnNames.size()) {
            builder.append(", ");
            builder.append(this.columnNames.get(i));
            ++i;
        }
        builder.append(") VALUES (?, ?, ?, ?, ?");
        i = 0;
        while (i < this.columnNames.size()) {
            builder.append(", ?");
            ++i;
        }
        builder.append(")");
        this.sqlInsert = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_tag");
        builder.append(", ");
        iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlDeleteList = builder.toString();
    }

    protected List<DBType> getDBTypes() {
        return this.dbTypes;
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final List<String> getColumnNames() {
        return this.columnNames;
    }

    protected final Map<CDOID, ITypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    protected final Map<CDOID, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        if (listChunk == 0 || list.size() == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, revision.getID());
                stmt.setInt(2, revision.getVersion());
                stmt.setInt(3, revision.getVersion());
                if (listChunk != -1) {
                    stmt.setMaxRows(listChunk);
                }
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    CDOID tag = idHandler.getCDOID(resultSet, 1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{list.size(), value});
                    }
                    list.set(currentIndex++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    private void addFeature(CDOID tag) {
        EStructuralFeature modelFeature = this.getFeatureByTag(tag);
        ITypeMapping typeMapping = this.getMappingStrategy().createValueMapping(modelFeature);
        String column = "cdo_value_" + typeMapping.getDBType();
        this.tagMap.put(tag, column);
        typeMapping.setDBField(this.table, column);
        this.typeMappings.put(tag, typeMapping);
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = chunkReader.getAccessor().getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(" AND ");
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                idHandler.setCDOID(stmt, 1, chunkReader.getRevision().getID());
                stmt.setInt(2, chunkReader.getRevision().getVersion());
                stmt.setInt(3, chunkReader.getRevision().getVersion());
                resultSet = stmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    CDOID tag = idHandler.getCDOID(resultSet, 1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature(), chunkReader.getRevision()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing done", new Object[0]);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3} : {4}", new Object[]{this.getContainingClass().getName(), this.getFeature(), idx, revision, value});
        }
        this.addEntry(accessor, revision.getID(), revision.getVersion(), idx, value, revision.getTimeStamp());
    }

    protected String getColumnName(CDOID tag) {
        String column = this.tagMap.get(tag);
        if (column == null) {
            this.addFeature(tag);
            column = this.tagMap.get(tag);
        }
        return column;
    }

    protected ITypeMapping getTypeMapping(CDOID tag) {
        ITypeMapping typeMapping = this.typeMappings.get(tag);
        if (typeMapping == null) {
            this.addFeature(tag);
            typeMapping = this.typeMappings.get(tag);
        }
        return typeMapping;
    }

    private EStructuralFeature getFeatureByTag(CDOID tag) {
        return (EStructuralFeature)this.getMappingStrategy().getStore().getMetaDataManager().getMetaInstance(tag);
    }

    protected CDOID getTagByFeature(EStructuralFeature feature, long timestamp) {
        return this.getMappingStrategy().getStore().getMetaDataManager().getMetaID((EModelElement)feature, timestamp);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmtDeleteTemp = null;
        PreparedStatement stmtClear = null;
        try {
            try {
                stmtDeleteTemp = statementCache.getPreparedStatement(this.sqlDeleteList, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmtDeleteTemp, 1, id);
                stmtDeleteTemp.setInt(2, newVersion);
                int result = DBUtil.update((PreparedStatement)stmtDeleteTemp, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("DeleteList result: {0}", new Object[]{result});
                }
                stmtClear = statementCache.getPreparedStatement(this.sqlClearList, IPreparedStatementCache.ReuseProbability.HIGH);
                stmtClear.setInt(1, newVersion);
                idHandler.setCDOID(stmtClear, 2, id);
                result = DBUtil.update((PreparedStatement)stmtClear, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmtDeleteTemp);
            statementCache.releasePreparedStatement(stmtClear);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmtDeleteTemp);
        statementCache.releasePreparedStatement(stmtClear);
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        if (TRACER.isEnabled()) {
            TRACER.format("objectRevised {0}: {1}", new Object[]{id, revised});
        }
        CDOBranch main = this.getMappingStrategy().getStore().getRepository().getBranchManager().getMainBranch();
        CDORevision revision = this.getMappingStrategy().getStore().getRepository().getRevisionManager().getRevision(id, main.getHead(), 0, 0, true);
        this.clearList(accessor, id, revision.getVersion(), Integer.MAX_VALUE);
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        IRepository repo = accessor.getStore().getRepository();
        InternalCDORevision originalRevision = (InternalCDORevision)repo.getRevisionManager().getRevision(id, repo.getBranchManager().getMainBranch().getHead(), 0, 0, true);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, oldVersion, newVersion, created);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        for (CDOFeatureDelta listDelta : delta.getListChanges()) {
            listDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int version, int index, Object value, long timestamp) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature() {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, version, value});
        }
        try {
            try {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                CDOID tag = this.getTagByFeature(entryFeature, timestamp);
                String columnName = this.getColumnName(tag);
                stmt = statementCache.getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, version);
                stmt.setNull(column++, DBType.INTEGER.getCode());
                stmt.setInt(column++, index);
                idHandler.setCDOID(stmt, column++, tag);
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(columnName)) {
                        this.getTypeMapping(tag).setValue(stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion});
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlDeleteEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, index);
                stmt.setInt(column++, newVersion);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    statementCache.releasePreparedStatement(stmt);
                    stmt = statementCache.getPreparedStatement(this.sqlRemoveEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                    column = 1;
                    stmt.setInt(column++, newVersion);
                    idHandler.setCDOID(stmt, column++, id);
                    stmt.setInt(column++, index);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private FeatureMap.Entry getValue(IDBStoreAccessor accessor, CDOID id, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        FeatureMap.Entry result = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlGetValue, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, index);
                ResultSet resultSet = stmt.executeQuery();
                if (!resultSet.next()) {
                    throw new DBException("getValue expects exactly one result");
                }
                CDOID tag = idHandler.getCDOID(resultSet, 1);
                Object value = this.getTypeMapping(tag).readValue(resultSet);
                result = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value);
                if (TRACER.isEnabled()) {
                    TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
        return result;
    }

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        throw new ImplementationError("Should never be called!");
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private InternalCDORevision originalRevision;
        private CDOID id;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;
        private long timestamp;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int oldVersion, int newVersion, long timestamp) {
            this.accessor = accessor;
            this.originalRevision = originalRevision;
            this.id = this.originalRevision.getID();
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.getList(AuditFeatureMapTableMappingWithRanges.this.getFeature()).size() - 1;
            this.timestamp = timestamp;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(this.accessor, this.id, fromIdx);
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx);
            if (fromIdx < toIdx) {
                this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
            } else {
                this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
            }
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, toIdx, value, this.timestamp);
        }

        public void visit(CDOAddFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, startIndex, delta.getValue(), this.timestamp);
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{startIndex});
            }
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex);
            this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
            --this.lastIndex;
        }

        public void visit(CDOSetFeatureDelta delta) {
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, index);
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, index, delta.getValue(), this.timestamp);
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                throw new ImplementationError("Should not be called");
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            AuditFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            AuditFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = AuditFeatureMapTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(AuditFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index - 1);
                        idHandler.setCDOID(stmt, column++, id);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 0: {
                                FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index - 1, value, this.timestamp);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = AuditFeatureMapTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(AuditFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index + 1);
                        idHandler.setCDOID(stmt, column++, id);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 0: {
                                FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown add: {0}", new Object[]{index + 1});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index + 1, value, this.timestamp);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }
    }
}

