/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchingListTableMappingWithRanges
extends BasicAbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, BranchingListTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private IDBTable table;
    private ITypeMapping typeMapping;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsertEntry;
    private String sqlDeleteEntry;
    private String sqlRemoveEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;

    public BranchingListTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initTable();
        this.initSQLStrings();
    }

    private void initTable() {
        IDBStore store = this.getMappingStrategy().getStore();
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.table = store.getDBSchema().addTable(tableName);
        IDBField[] dbFields = new IDBField[]{this.table.addField("cdo_source", store.getIDHandler().getDBType()), this.table.addField("cdo_branch", DBType.INTEGER), this.table.addField("cdo_version_added", DBType.INTEGER), this.table.addField("cdo_version_removed", DBType.INTEGER), this.table.addField("cdo_idx", DBType.INTEGER)};
        this.typeMapping = this.getMappingStrategy().createValueMapping(this.getFeature());
        this.typeMapping.createDBField(this.table, "cdo_value");
        IDBField[] iDBFieldArray = dbFields;
        int n = dbFields.length;
        int n2 = 0;
        while (n2 < n) {
            IDBField dbField = iDBFieldArray[n2];
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{dbField});
            ++n2;
        }
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_value");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("<=? AND (");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL OR ");
        builder.append("cdo_version_removed");
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        builder.append("cdo_source");
        builder.append(",");
        builder.append("cdo_branch");
        builder.append(",");
        builder.append("cdo_version_added");
        builder.append(",");
        builder.append("cdo_version_removed");
        builder.append(",");
        builder.append("cdo_idx");
        builder.append(",");
        builder.append("cdo_value");
        builder.append(") VALUES (?, ?, ?, ?, ?, ?)");
        this.sqlInsertEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_value");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        int valuesToRead = list.size();
        if (listChunk != -1 && listChunk < valuesToRead) {
            valuesToRead = listChunk;
        }
        if (valuesToRead == 0) {
            return;
        }
        CDOID id = revision.getID();
        int branchID = revision.getBranch().getID();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        IStoreChunkReader baseReader = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, id);
                stmt.setInt(2, branchID);
                stmt.setInt(3, revision.getVersion());
                stmt.setInt(4, revision.getVersion());
                stmt.setMaxRows(valuesToRead);
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while (valuesToRead > 0 && resultSet.next()) {
                    int index = resultSet.getInt(1);
                    if (index > currentIndex) {
                        if (baseReader == null) {
                            baseReader = this.createBaseChunkReader(accessor, id, branchID);
                        }
                        baseReader.addRangedChunk(currentIndex, index);
                        if (TRACER.isEnabled()) {
                            TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{currentIndex, index});
                        }
                        valuesToRead -= index - currentIndex;
                        currentIndex = index;
                    }
                    Object value = this.typeMapping.readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, value);
                    --valuesToRead;
                }
                if (valuesToRead > 0) {
                    if (baseReader == null) {
                        baseReader = this.createBaseChunkReader(accessor, id, branchID);
                    }
                    baseReader.addRangedChunk(currentIndex, currentIndex + valuesToRead);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{currentIndex, currentIndex + valuesToRead});
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        if (baseReader != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading base revision chunks for feature {0}.{1} of {2} from base revision {3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision, baseReader.getRevision()});
            }
            List baseChunks = baseReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : baseChunks) {
                int startIndex = chunk.getStartIndex();
                int i = 0;
                while (i < chunk.size()) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Copying value {0} at chunk index {1}+{2} to index {3}", new Object[]{chunk.get(i), startIndex, i, startIndex + i});
                    }
                    list.set(startIndex + i, chunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {3} list values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision, list.size()});
        }
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        int i;
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision()});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = chunkReader.getAccessor().getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        IStoreChunkReader baseReader = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(" AND ");
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                idHandler.setCDOID(stmt, 1, chunkReader.getRevision().getID());
                stmt.setInt(2, chunkReader.getRevision().getBranch().getID());
                stmt.setInt(3, chunkReader.getRevision().getVersion());
                stmt.setInt(4, chunkReader.getRevision().getVersion());
                if (TRACER.isEnabled()) {
                    TRACER.format("Readung Chunks: {0}", new Object[]{stmt});
                }
                resultSet = stmt.executeQuery();
                int nextDBIndex = Integer.MAX_VALUE;
                if (resultSet.next()) {
                    nextDBIndex = resultSet.getInt(1);
                }
                for (IStoreChunkReader.Chunk chunk : chunks) {
                    int startIndex = chunk.getStartIndex();
                    int missingValueStartIndex = -1;
                    i = 0;
                    while (i < chunk.size()) {
                        int nextListIndex = startIndex + i;
                        if (nextDBIndex == nextListIndex) {
                            if (missingValueStartIndex != -1) {
                                if (baseReader == null) {
                                    baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), chunkReader.getRevision().getID(), chunkReader.getRevision().getBranch().getID());
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{missingValueStartIndex, nextListIndex});
                                }
                                baseReader.addRangedChunk(missingValueStartIndex, nextListIndex);
                                missingValueStartIndex = -1;
                            }
                            Object value = this.typeMapping.readValue(resultSet);
                            if (TRACER.isEnabled()) {
                                TRACER.format("ChunkReader read value for index {0} from result set: {1}", new Object[]{nextDBIndex, value});
                            }
                            chunk.add(i, value);
                            nextDBIndex = resultSet.next() ? resultSet.getInt(1) : Integer.MAX_VALUE;
                        } else if (missingValueStartIndex == -1) {
                            missingValueStartIndex = nextListIndex;
                        }
                        ++i;
                    }
                    if (missingValueStartIndex == -1) continue;
                    if (baseReader == null) {
                        baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), chunkReader.getRevision().getID(), chunkReader.getRevision().getBranch().getID());
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{missingValueStartIndex, chunk.getStartIndex() + chunk.size()});
                    }
                    baseReader.addRangedChunk(missingValueStartIndex, chunk.getStartIndex() + chunk.size());
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        if (baseReader != null) {
            List baseChunks = baseReader.executeRead();
            Iterator<IStoreChunkReader.Chunk> thisIterator = chunks.iterator();
            IStoreChunkReader.Chunk thisChunk = thisIterator.next();
            for (IStoreChunkReader.Chunk baseChunk : baseChunks) {
                int baseStartIndex = baseChunk.getStartIndex();
                while (baseStartIndex > thisChunk.getStartIndex() + thisChunk.size()) {
                    thisChunk = thisIterator.next();
                }
                int offset = baseStartIndex - thisChunk.getStartIndex();
                i = 0;
                while (i < baseChunk.size()) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Copying base chunk reader value {0} at index {1} to current chunk reader at index {2}.", new Object[]{baseChunk.get(i), baseChunk.getStartIndex() + i, thisChunk.getStartIndex() + i + offset});
                    }
                    thisChunk.add(i + offset, baseChunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision()});
        }
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing done", new Object[0]);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3} : {4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, revision, value});
        }
        this.addEntry(accessor, revision.getID(), revision.getBranch().getID(), revision.getVersion(), index, value);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int lastIndex) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                int i = 0;
                while (i <= lastIndex) {
                    if (this.getValue(accessor, id, branchId, i, false) == null) {
                        this.addHistoricEntry(accessor, id, branchId, 0, newVersion, i, this.getValueFromBase(accessor, id, branchId, i));
                    }
                    ++i;
                }
                stmt = statementCache.getPreparedStatement(this.sqlClearList, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setInt(1, newVersion);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 2, id);
                stmt.setInt(3, branchId);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        InternalCDORevision revision = (InternalCDORevision)accessor.getTransaction().getRevision(id);
        int branchId = accessor.getTransaction().getBranch().getID();
        if (TRACER.isEnabled()) {
            TRACER.format("objectDetached {1}", new Object[]{revision});
        }
        this.clearList(accessor, id, branchId, revision.getVersion(), Integer.MAX_VALUE, revision.getList(this.getFeature()).size() - 1);
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        List listChanges = delta.getListChanges();
        if (listChanges.size() == 0) {
            return;
        }
        InternalCDORevision originalRevision = (InternalCDORevision)accessor.getTransaction().getRevision(id);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, branchId, oldVersion, newVersion);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        int index = listChanges.size() - 1;
        while (index > 0) {
            CDOFeatureDelta listDelta = (CDOFeatureDelta)listChanges.get(index);
            if (listDelta instanceof CDOClearFeatureDelta || listDelta instanceof CDOUnsetFeatureDelta) break;
            --index;
        }
        while (index < listChanges.size()) {
            ((CDOFeatureDelta)listChanges.get(index++)).accept((CDOFeatureDeltaVisitor)visitor);
        }
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int version, int index, Object value) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature {0}.{1} index {2} of {3}:{4}v{5} : {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, version, value});
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, version);
                stmt.setNull(column++, DBType.INTEGER.getCode());
                stmt.setInt(column++, index);
                this.typeMapping.setValue(stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private void addHistoricEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int versionAdded, int versionRemoved, int index, Object value) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding historic value for feature {0}.{1} index {2} of {3}:{4}v{5}-v{6} : {7}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, versionAdded, versionRemoved, value});
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, versionAdded);
                stmt.setInt(column++, versionRemoved);
                stmt.setInt(column++, index);
                this.typeMapping.setValue(stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion});
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlDeleteEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                stmt.setInt(column++, newVersion);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    statementCache.releasePreparedStatement(stmt);
                    stmt = statementCache.getPreparedStatement(this.sqlRemoveEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                    column = 1;
                    stmt.setInt(column++, newVersion);
                    idHandler.setCDOID(stmt, column++, id);
                    stmt.setInt(column++, branchId);
                    stmt.setInt(column++, index);
                    result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                    if (result == 0) {
                        Object value = this.getValueFromBase(accessor, id, branchId, index);
                        this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                    }
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5} FAILED {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature {0}.{1} index {2} of {3}:{4}v{5} FAILED {6}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private Object getValue(IDBStoreAccessor accessor, CDOID id, int branchId, int index, boolean getFromBase) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        Object result = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlGetValue, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                ResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    result = this.typeMapping.readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                    }
                } else if (getFromBase) {
                    result = this.getValueFromBase(accessor, id, branchId, index);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
        return result;
    }

    private Object getValueFromBase(IDBStoreAccessor accessor, CDOID id, int branchID, int index) {
        IStoreChunkReader chunkReader = this.createBaseChunkReader(accessor, id, branchID);
        chunkReader.addSimpleChunk(index);
        List chunks = chunkReader.executeRead();
        return ((IStoreChunkReader.Chunk)chunks.get(0)).get(0);
    }

    private IStoreChunkReader createBaseChunkReader(IDBStoreAccessor accessor, CDOID id, int branchID) {
        IRepository repository = accessor.getStore().getRepository();
        CDOBranchPoint base = repository.getBranchManager().getBranch(branchID).getBase();
        InternalCDORevision baseRevision = (InternalCDORevision)repository.getRevisionManager().getRevision(id, base, 0, 0, true);
        IStoreChunkReader chunkReader = accessor.createChunkReader(baseRevision, this.getFeature());
        return chunkReader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        tableName = this.getTable().getName();
        listJoin = this.getMappingStrategy().getListJoin("a_t", "l_t");
        builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append("cdo_source");
        builder.append(", l_t.");
        builder.append("cdo_value");
        builder.append(", l_t.");
        builder.append("cdo_idx");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" AS l_t, ");
        builder.append(mainTableName);
        builder.append(" AS a_t WHERE ");
        builder.append("a_t." + mainTableWhere);
        builder.append(listJoin);
        builder.append(" AND ");
        builder.append("cdo_value");
        builder.append(" IN ");
        builder.append(idString);
        sql = builder.toString();
        idHandler = this.getMappingStrategy().getStore().getIDHandler();
        resultSet = null;
        stmt = null;
        try {
            stmt = accessor.getConnection().createStatement();
            if (BranchingListTableMappingWithRanges.TRACER.isEnabled()) {
                BranchingListTableMappingWithRanges.TRACER.format("Query XRefs (list): {0}", new Object[]{sql});
            }
            resultSet = stmt.executeQuery(sql);
            ** GOTO lbl-1000
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable var17_18) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw var17_18;
            }
        }
lbl57:
        // 2 sources

        while (true) {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return false;
        }
lbl-1000:
        // 2 sources

        {
            ** while (resultSet.next())
        }
lbl-1000:
        // 1 sources

        {
            sourceID = idHandler.getCDOID(resultSet, 1);
            targetID = idHandler.getCDOID(resultSet, 2);
            idx = resultSet.getInt(3);
            more = context.addXRef(targetID, sourceID, (EReference)this.getFeature(), idx);
            if (BranchingListTableMappingWithRanges.TRACER.isEnabled()) {
                BranchingListTableMappingWithRanges.TRACER.format("  add XRef to context: src={0}, tgt={1}, idx={2}", new Object[]{sourceID, targetID, idx});
            }
            if (more) continue;
            if (!BranchingListTableMappingWithRanges.TRACER.isEnabled()) ** GOTO lbl57
            BranchingListTableMappingWithRanges.TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
            ** continue;
lbl74:
            // 1 sources

            ** GOTO lbl57
        }
lbl75:
        // 1 sources

        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return true;
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private CDOID id;
        private int branchID;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int targetBranchID, int oldVersion, int newVersion) {
            this.accessor = accessor;
            this.id = originalRevision.getID();
            this.branchID = targetBranchID;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.getList(BranchingListTableMappingWithRanges.this.getFeature()).size() - 1;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            Object value = BranchingListTableMappingWithRanges.this.getValue(this.accessor, this.id, this.branchID, fromIdx, true);
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx);
            if (fromIdx < toIdx) {
                this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
            } else {
                this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
            }
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, toIdx, value);
        }

        public void visit(CDOAddFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, startIndex, delta.getValue());
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{startIndex});
            }
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex);
            this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
            --this.lastIndex;
        }

        public void visit(CDOSetFeatureDelta delta) {
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            BranchingListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, index);
            BranchingListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, index, delta.getValue());
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                throw new ImplementationError("Should not be called");
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            BranchingListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex);
            this.lastIndex = -1;
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            BranchingListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex);
            this.lastIndex = -1;
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(BranchingListTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index - 1);
                        idHandler.setCDOID(stmt, column++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            case 0: {
                                Object value = BranchingListTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index);
                                } else {
                                    value = BranchingListTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    TRACER.format("moveOneUp add historic entry at: {0}", new Object[]{index});
                                    BranchingListTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                BranchingListTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index - 1, value);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(BranchingListTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index + 1);
                        idHandler.setCDOID(stmt, column++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            case 0: {
                                Object value = BranchingListTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                    }
                                    BranchingListTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index);
                                } else {
                                    value = BranchingListTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    TRACER.format("moveOneDown add historic entry at: {0}", new Object[]{index});
                                    BranchingListTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown add: {0}", new Object[]{index + 1});
                                }
                                BranchingListTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index + 1, value);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }
    }
}

