/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingFeatureMapTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class HorizontalBranchingMappingStrategy
extends AbstractHorizontalMappingStrategy {
    public boolean hasAuditSupport() {
        return true;
    }

    public boolean hasBranchingSupport() {
        return true;
    }

    public boolean hasDeltaSupport() {
        return false;
    }

    public IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMapping(this, containingClass, feature);
    }

    public IListMapping doCreateFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingFeatureMapTableMapping(this, containingClass, feature);
    }

    protected void rawImportReviseOldRevisions(Connection connection, IDBTable table, OMMonitor monitor) {
        int size;
        ResultSet resultSet;
        PreparedStatement stmtQuery;
        PreparedStatement stmtUpdate;
        IIDHandler idHandler;
        block9: {
            String sqlUpdate = "UPDATE " + table + " SET " + "cdo_revised" + "=? WHERE " + "cdo_id" + "=? AND " + "cdo_branch" + "=? AND " + "cdo_version" + "=?";
            String sqlQuery = "SELECT cdo1.cdo_id, cdo1.cdo_branch, cdo1.cdo_version, cdo2.cdo_created FROM " + table + " cdo1, " + table + " cdo2 WHERE cdo1." + "cdo_id" + "=cdo2." + "cdo_id" + " AND cdo1." + "cdo_branch" + "=cdo2." + "cdo_branch" + " AND (cdo1." + "cdo_version" + "=cdo2." + "cdo_version" + "-1 OR (cdo1." + "cdo_version" + "+cdo2." + "cdo_version" + "=-1 AND cdo1." + "cdo_version" + ">cdo2." + "cdo_version" + ")) AND cdo1." + "cdo_revised" + "=0";
            idHandler = this.getStore().getIDHandler();
            stmtUpdate = null;
            stmtQuery = null;
            resultSet = null;
            stmtUpdate = connection.prepareStatement(sqlUpdate);
            stmtQuery = connection.prepareStatement(sqlQuery, 1004, 1007);
            resultSet = stmtQuery.executeQuery();
            size = DBUtil.getRowCount((ResultSet)resultSet);
            if (size != 0) break block9;
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmtQuery);
            DBUtil.close((Statement)stmtUpdate);
            monitor.done();
            return;
        }
        try {
            try {
                monitor.begin((double)(2 * size));
                while (resultSet.next()) {
                    CDOID id = idHandler.getCDOID(resultSet, 1);
                    int branch = resultSet.getInt(2);
                    int version = resultSet.getInt(3);
                    long revised = resultSet.getLong(4) - 1L;
                    stmtUpdate.setLong(1, revised);
                    idHandler.setCDOID(stmtUpdate, 2, id);
                    stmtUpdate.setInt(3, branch);
                    stmtUpdate.setInt(4, version);
                    stmtUpdate.addBatch();
                    monitor.worked();
                }
                OMMonitor.Async async = monitor.forkAsync((double)size);
                try {
                    stmtUpdate.executeBatch();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(stmtQuery);
            DBUtil.close((Statement)stmtUpdate);
            monitor.done();
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmtQuery);
        DBUtil.close((Statement)stmtUpdate);
        monitor.done();
    }

    protected void rawImportUnreviseNewRevisions(Connection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        String sqlUpdate = "UPDATE " + table + " SET " + "cdo_revised" + "=0 WHERE " + "cdo_branch" + ">=0 AND " + "cdo_created" + "<=" + toCommitTime + " AND " + "cdo_revised" + ">" + toCommitTime + " AND " + "cdo_version" + ">0";
        PreparedStatement stmtUpdate = null;
        try {
            try {
                stmtUpdate = connection.prepareStatement(sqlUpdate);
                monitor.begin();
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    stmtUpdate.executeUpdate();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmtUpdate);
            monitor.done();
            throw throwable;
        }
        DBUtil.close((Statement)stmtUpdate);
        monitor.done();
    }

    public String getListJoin(String attrTable, String listTable) {
        String join = super.getListJoin(attrTable, listTable);
        join = String.valueOf(join) + " AND " + attrTable + "." + "cdo_version";
        join = String.valueOf(join) + "=" + listTable + "." + "cdo_version";
        join = String.valueOf(join) + " AND " + attrTable + "." + "cdo_branch";
        join = String.valueOf(join) + "=" + listTable + "." + "cdo_branch";
        return join;
    }
}

