/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingFeatureMapTableMappingWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMappingWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class HorizontalBranchingMappingStrategyWithRanges
extends AbstractHorizontalMappingStrategy {
    private static final String PROP_COPY_ON_BRANCH = "copyOnBranch";
    private boolean copyOnBranch;

    public boolean hasAuditSupport() {
        return true;
    }

    public boolean hasBranchingSupport() {
        return true;
    }

    public boolean hasDeltaSupport() {
        return true;
    }

    public boolean shallCopyOnBranch() {
        return this.copyOnBranch;
    }

    public IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMappingWithRanges(this, containingClass, feature);
    }

    public IListMapping doCreateFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingFeatureMapTableMappingWithRanges(this, containingClass, feature);
    }

    public String getListJoin(String attrTable, String listTable) {
        String join = super.getListJoin(attrTable, listTable);
        join = String.valueOf(join) + " AND " + listTable + "." + "cdo_version_added";
        join = String.valueOf(join) + "<=" + attrTable + "." + "cdo_version";
        join = String.valueOf(join) + " AND (" + listTable + "." + "cdo_version_removed";
        join = String.valueOf(join) + " IS NULL OR " + listTable + "." + "cdo_version_removed";
        join = String.valueOf(join) + ">" + attrTable + "." + "cdo_version";
        join = String.valueOf(join) + ") AND " + attrTable + "." + "cdo_branch";
        join = String.valueOf(join) + "=" + listTable + "." + "cdo_branch";
        return join;
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        String value = this.getProperties().get(PROP_COPY_ON_BRANCH);
        this.copyOnBranch = value == null ? false : Boolean.valueOf(value);
    }
}

