/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractFeatureMapTableMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.ImplementationError;

public class NonAuditFeatureMapTableMapping
extends AbstractFeatureMapTableMapping
implements IListMappingDeltaSupport {
    private AbstractFeatureMapTableMapping.FieldInfo[] keyFields;
    private static final int TEMP_INDEX = -1;
    private static final int UNBOUNDED_MOVE = -1;
    private String sqlClear;
    private String sqlUpdateIndex;
    private String sqlUpdateValue;
    private String sqlDeleteItem;
    private String sqlMoveDownWithLimit;
    private String sqlMoveDown;
    private String sqlMoveUpWithLimit;
    private String sqlMoveUp;

    public NonAuditFeatureMapTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? ");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_tag");
        builder.append("=?,");
        Iterator<String> iter = this.getColumnNames().iterator();
        while (iter.hasNext()) {
            String column = iter.next();
            builder.append(column);
            builder.append("=?");
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=");
        builder.append("cdo_idx");
        builder.append("-1 WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append(">? ");
        this.sqlMoveDown = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append("<=?");
        this.sqlMoveDownWithLimit = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=");
        builder.append("cdo_idx");
        builder.append("+1 WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append(">=? ");
        this.sqlMoveUp = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append("<?");
        this.sqlMoveUpWithLimit = builder.toString();
    }

    protected AbstractFeatureMapTableMapping.FieldInfo[] getKeyFields() {
        if (this.keyFields == null) {
            DBType dbType = this.getMappingStrategy().getStore().getIDHandler().getDBType();
            this.keyFields = new AbstractFeatureMapTableMapping.FieldInfo[]{new AbstractFeatureMapTableMapping.FieldInfo("cdo_id", dbType)};
        }
        return this.keyFields;
    }

    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, revision.getID());
    }

    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlClear, IPreparedStatementCache.ReuseProbability.HIGH);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void insertListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        this.move1up(accessor, id, index, -1);
        this.insertValue(accessor, id, index, value, timestamp);
    }

    private void insertValue(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                CDOID tag = this.getTagByFeature(entryFeature, timestamp);
                String columnName = this.getColumnName(tag);
                String sql = this.sqlInsert;
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, id);
                int column = this.getKeyFields().length + 1;
                int i = 0;
                while (i < this.getColumnNames().size()) {
                    if (this.getColumnNames().get(i).equals(columnName)) {
                        this.getTypeMapping(tag).setValue(stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                stmt.setInt(column++, index);
                idHandler.setCDOID(stmt, column++, tag);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void moveListItem(IDBStoreAccessor accessor, CDOID id, int oldPosition, int newPosition) {
        if (oldPosition == newPosition) {
            return;
        }
        this.updateOneIndex(accessor, id, oldPosition, -1);
        if (oldPosition < newPosition) {
            this.move1down(accessor, id, oldPosition, newPosition);
        } else {
            this.move1up(accessor, id, newPosition, oldPosition);
        }
        this.updateOneIndex(accessor, id, -1, newPosition);
    }

    private void updateOneIndex(IDBStoreAccessor accessor, CDOID id, int oldIndex, int newIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setInt(1, newIndex);
                idHandler.setCDOID(stmt, 2, id);
                stmt.setInt(3, oldIndex);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void removeListItem(IDBStoreAccessor accessor, CDOID id, int index) {
        this.deleteItem(accessor, id, index);
        this.move1down(accessor, id, index, -1);
    }

    private void move1down(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(upperIndex == -1 ? this.sqlMoveDown : this.sqlMoveDownWithLimit, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, id);
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private void move1up(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(upperIndex == -1 ? this.sqlMoveUp : this.sqlMoveUpWithLimit, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, id);
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    private void deleteItem(IDBStoreAccessor accessor, CDOID id, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlDeleteItem, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, id);
                stmt.setInt(2, index);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void setListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, timestamp);
        String columnName = this.getColumnName(tag);
        ITypeMapping mapping = this.getTypeMapping(tag);
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlUpdateValue, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, tag);
                int column = 2;
                int i = 0;
                while (i < this.getColumnNames().size()) {
                    if (this.getColumnNames().get(i).equals(columnName)) {
                        mapping.setValue(stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, index);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void processDelta(final IDBStoreAccessor accessor, final CDOID id, int branchId, int oldVersion, int newVersion, final long created, CDOListFeatureDelta listDelta) {
        CDOFeatureDeltaVisitor visitor = new CDOFeatureDeltaVisitor(){

            public void visit(CDOMoveFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.moveListItem(accessor, id, delta.getOldPosition(), delta.getNewPosition());
            }

            public void visit(CDOAddFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.insertListItem(accessor, id, delta.getIndex(), delta.getValue(), created);
            }

            public void visit(CDORemoveFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.removeListItem(accessor, id, delta.getIndex());
            }

            public void visit(CDOSetFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.setListItem(accessor, id, delta.getIndex(), delta.getValue(), created);
            }

            public void visit(CDOUnsetFeatureDelta delta) {
                if (delta.getFeature().isUnsettable()) {
                    throw new ImplementationError("Should not be called");
                }
                NonAuditFeatureMapTableMapping.this.clearList(accessor, id);
            }

            public void visit(CDOListFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }

            public void visit(CDOClearFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.clearList(accessor, id);
            }

            public void visit(CDOContainerFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }
        };
        for (CDOFeatureDelta delta : listDelta.getListChanges()) {
            delta.accept(visitor);
        }
    }
}

