/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractObjectTypeMapper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ObjectTypeTable
extends AbstractObjectTypeMapper {
    private IDBTable table;
    private IDBField idField;
    private IDBField typeField;
    private IDBField timeField;
    private String sqlDelete;
    private String sqlInsert;
    private String sqlSelect;

    public final CDOClassifierRef getObjectType(IDBStoreAccessor accessor, CDOID id) {
        ResultSet resultSet;
        PreparedStatement stmt;
        IPreparedStatementCache statementCache;
        IIDHandler idHandler;
        block5: {
            idHandler = this.getMappingStrategy().getStore().getIDHandler();
            statementCache = accessor.getStatementCache();
            stmt = null;
            stmt = statementCache.getPreparedStatement(this.sqlSelect, IPreparedStatementCache.ReuseProbability.MAX);
            idHandler.setCDOID(stmt, 1, id);
            DBUtil.trace((String)stmt.toString());
            resultSet = stmt.executeQuery();
            if (resultSet.next()) break block5;
            DBUtil.trace((String)("ClassID for CDOID " + id + " not found"));
            statementCache.releasePreparedStatement(stmt);
            return null;
        }
        try {
            CDOID classID = idHandler.getCDOID(resultSet, 1);
            EClass eClass = (EClass)this.getMetaDataManager().getMetaInstance(classID);
            CDOClassifierRef cDOClassifierRef = new CDOClassifierRef((EClassifier)eClass);
            statementCache.releasePreparedStatement(stmt);
            return cDOClassifierRef;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    public final void putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        block7: {
            IDBStore store = this.getMappingStrategy().getStore();
            IIDHandler idHandler = store.getIDHandler();
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.MAX);
                    idHandler.setCDOID(stmt, 1, id);
                    idHandler.setCDOID(stmt, 2, this.getMetaDataManager().getMetaID((EModelElement)type, timeStamp));
                    stmt.setLong(3, timeStamp);
                    DBUtil.trace((String)stmt.toString());
                    int result = stmt.executeUpdate();
                    if (result != 1) {
                        throw new DBException("Object type could not be inserted: " + id);
                    }
                }
                catch (SQLException ex) {
                    if (!store.getDBAdapter().isDuplicateKeyException(ex)) {
                        throw new DBException((Throwable)ex);
                    }
                    statementCache.releasePreparedStatement(stmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }
    }

    public final void removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlDelete, IPreparedStatementCache.ReuseProbability.MAX);
                idHandler.setCDOID(stmt, 1, id);
                DBUtil.trace((String)stmt.toString());
                int result = stmt.executeUpdate();
                if (result != 1) {
                    throw new DBException("Object type could not be deleted: " + id);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public CDOID getMaxID(Connection connection, IIDHandler idHandler) {
        ResultSet resultSet;
        Statement stmt;
        block4: {
            CDOID cDOID;
            stmt = null;
            resultSet = null;
            try {
                stmt = connection.createStatement();
                resultSet = stmt.executeQuery("SELECT MAX(" + this.idField + ") FROM " + this.table);
                if (!resultSet.next()) break block4;
                cDOID = idHandler.getCDOID(resultSet, 1);
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return cDOID;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return null;
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE " + this.timeField + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table, null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table, (OMMonitor)monitor);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IDBStore store = this.getMappingStrategy().getStore();
        IDBSchema schema = store.getDBSchema();
        DBType dbType = store.getIDHandler().getDBType();
        this.table = schema.addTable("cdo_objects");
        this.idField = this.table.addField("cdo_id", dbType);
        this.typeField = this.table.addField("cdo_class", dbType);
        this.timeField = this.table.addField("cdo_created", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{this.idField});
        IDBAdapter dbAdapter = store.getDBAdapter();
        IDBStoreAccessor writer = store.getWriter(null);
        Connection connection = writer.getConnection();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                dbAdapter.createTable(this.table, statement);
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)statement);
            writer.release();
        }
        this.sqlSelect = "SELECT " + this.typeField + " FROM " + this.table + " WHERE " + this.idField + "=?";
        this.sqlInsert = "INSERT INTO " + this.table + "(" + this.idField + "," + this.typeField + "," + this.timeField + ") VALUES (?, ?, ?)";
        this.sqlDelete = "DELETE FROM " + this.table + " WHERE " + this.idField + "=?";
    }

    protected void doDeactivate() throws Exception {
        this.table = null;
        this.idField = null;
        this.typeField = null;
        super.doDeactivate();
    }
}

