/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;

public class LockObjectsIndication
extends CDOServerWriteIndication {
    private List<CDORevisionKey> staleRevisions = new LinkedList<CDORevisionKey>();
    private boolean timedOut;
    private boolean passiveUpdatesEnabled;
    private long requiredTimestamp;
    private boolean staleNoUpdate;

    public LockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)24);
    }

    protected void indicating(CDODataInput in) throws IOException {
        InternalSession session = this.getSession();
        this.passiveUpdatesEnabled = session.isPassiveUpdateEnabled();
        int viewID = in.readInt();
        IRWLockManager.LockType lockType = in.readCDOLockType();
        long timeout = in.readLong();
        CDOBranch viewedBranch = in.readCDOBranch();
        int nRevisions = in.readInt();
        CDORevisionKey[] revKeys = new CDORevisionKey[nRevisions];
        int i = 0;
        while (i < nRevisions) {
            revKeys[i] = in.readCDORevisionKey();
            ++i;
        }
        ArrayList<Object> objectsToBeLocked = new ArrayList<Object>();
        boolean isSupportingBranches = this.getRepository().isSupportingBranches();
        CDORevisionKey[] cDORevisionKeyArray = revKeys;
        int n = revKeys.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevisionKey revKey = cDORevisionKeyArray[n2];
            CDOID id = revKey.getID();
            if (isSupportingBranches) {
                objectsToBeLocked.add(CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)viewedBranch));
            } else {
                objectsToBeLocked.add(id);
            }
            ++n2;
        }
        InternalView view = this.getSession().getView(viewID);
        InternalLockManager lockManager = this.getRepository().getLockManager();
        try {
            lockManager.lock(true, lockType, (IView)view, objectsToBeLocked, timeout);
        }
        catch (TimeoutRuntimeException ex) {
            this.timedOut = true;
            return;
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        try {
            CDORevisionKey[] cDORevisionKeyArray2 = revKeys;
            int n3 = revKeys.length;
            int n4 = 0;
            while (n4 < n3) {
                CDORevisionKey revKey = cDORevisionKeyArray2[n4];
                this.checkStale(viewedBranch, revKey);
                ++n4;
            }
        }
        catch (IllegalArgumentException ex) {
            lockManager.unlock(true, lockType, (IView)view, objectsToBeLocked);
            throw ex;
        }
        boolean bl = this.staleNoUpdate = this.staleRevisions.size() > 0 && !this.passiveUpdatesEnabled;
        if (this.staleNoUpdate) {
            lockManager.unlock(true, lockType, (IView)view, objectsToBeLocked);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        boolean lockSuccesful = !this.timedOut && !this.staleNoUpdate;
        out.writeBoolean(lockSuccesful);
        if (lockSuccesful) {
            boolean clientMustWait = this.staleRevisions.size() > 0;
            out.writeBoolean(clientMustWait);
            if (clientMustWait) {
                out.writeLong(this.requiredTimestamp);
            }
        } else {
            out.writeBoolean(this.timedOut);
            if (!this.timedOut) {
                out.writeInt(this.staleRevisions.size());
                for (CDORevisionKey staleRevision : this.staleRevisions) {
                    out.writeCDORevisionKey(staleRevision);
                }
            }
        }
    }

    private void checkStale(CDOBranch viewedBranch, CDORevisionKey revKey) {
        CDOID id = revKey.getID();
        InternalCDORevision rev = this.getRepository().getRevisionManager().getRevision(id, viewedBranch.getHead(), -1, 0, true);
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Object %s not found in branch %s (possibly detached)", id, viewedBranch));
        }
        if (!revKey.equals(rev)) {
            this.staleRevisions.add(revKey);
            this.requiredTimestamp = Math.max(this.requiredTimestamp, rev.getTimeStamp());
        }
    }
}

