/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.net4j.util.WrappedException;

public class ReplicateRepositoryIndication
extends CDOServerReadIndication {
    private int lastReplicatedBranchID;
    private long lastReplicatedCommitTime;

    public ReplicateRepositoryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)42);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.lastReplicatedBranchID = in.readInt();
        this.lastReplicatedCommitTime = in.readLong();
    }

    protected void responding(final CDODataOutput out) throws IOException {
        this.getRepository().replicate(new CDOReplicationContext(){

            public int getLastReplicatedBranchID() {
                return ReplicateRepositoryIndication.this.lastReplicatedBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return ReplicateRepositoryIndication.this.lastReplicatedCommitTime;
            }

            public void handleBranch(CDOBranch branch) {
                try {
                    out.writeByte(1);
                    out.writeCDOBranch(branch);
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                try {
                    out.writeByte(2);
                    out.writeCDOCommitInfo(commitInfo);
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
        out.writeByte(0);
    }
}

