/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import com.objy.db.LockNotGrantedException;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.Iterator;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityFeatureDeltaWriter;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityQueryHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStore;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManagerLocal;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyCommitInfoHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPackageHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranch;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranchManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyCommitInfo;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyLockAreaManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.SmartLock;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreChunkReader;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectivityStoreAccessor
extends StoreAccessor
implements IObjectivityStoreAccessor,
IStoreAccessor.DurableLocking {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjectivityStoreAccessor.class);
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, ObjectivityStoreAccessor.class);
    protected ObjySession objySession = null;
    protected boolean isRead = false;
    protected int sessionID = 0;
    boolean zipped = true;
    private HashMap<CDOID, ObjyObject> newObjyObjectsMap = new HashMap();
    private long readRevisionTime = 0L;
    private int readRevisionCount = 0;

    protected ObjectivityStoreAccessor(ObjectivityStore store, ISession cdoSession) {
        super((Store)store, cdoSession);
        this.isRead = true;
        if (cdoSession != null) {
            this.sessionID = cdoSession.getSessionID();
        }
    }

    public ObjectivityStoreAccessor(ObjectivityStore store, ITransaction transaction) {
        super((Store)store, transaction);
        if (transaction != null) {
            this.sessionID = transaction.getSession().getSessionID();
        }
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        this.ensureSessionBegin();
        try {
            monitor.begin((double)detachedObjects.length);
            HashSet<ooId> containerToLocks = new HashSet<ooId>();
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(id);
                containerToLocks.add(containerID);
                ++n2;
            }
            this.objySession.lockContainers(containerToLocks);
            InternalCDORevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
            long tStart = System.currentTimeMillis();
            CDOID[] cDOIDArray2 = detachedObjects;
            int n3 = detachedObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                CDOID id = cDOIDArray2[n4];
                InternalCDORevision revision = revisionManager.getRevision(id, branch.getHead(), -1, 0, true);
                int version = ObjectUtil.equals((Object)branch, (Object)revision.getBranch()) ? revision.getVersion() : 1;
                this.detachObject(id, version, branch, timeStamp);
                ++n4;
            }
            long tDiff = System.currentTimeMillis() - tStart;
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("detach objects: " + detachedObjects.length + " - time: " + tDiff);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void detachObject(CDOID id, int version, CDOBranch branch, long timeStamp) {
        ObjyObject objyObject = this.getObject(id);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Detaching id " + id + " - OID: " + objyObject.ooId().getStoreString() + " verions: " + version + " in Branch: " + branch.getID() + " and timeStamp: " + timeStamp);
        }
        if (this.getStore().isRequiredToSupportAudits()) {
            if (version > 1) {
                ObjyObject objyRevision = objyObject.getRevisionByVersion(version, branch.getID(), this.objySession.getObjectManager());
                if (objyRevision.getVersion() < 0) {
                    TRACER_DEBUG.trace("... OBJ is already detached...");
                }
                objyRevision.setRevisedTime(timeStamp - 1L);
            }
            objyObject.detach(version, branch, timeStamp);
        } else {
            objyObject.setVersion(-version);
            objyObject.delete(this, this.objySession.getObjectManager());
        }
        this.objySession.getObjectManager().remove(objyObject);
    }

    protected void doActivate() throws Exception {
    }

    public ObjySession getObjySession() {
        int currSessionID = this.sessionID;
        if (!this.isReader()) {
            ITransaction cdoTrx = this.getTransaction();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("getObjySession() - context's transaction: " + (cdoTrx == null ? "null" : cdoTrx.toString()));
            }
            if (cdoTrx != null) {
                this.sessionID = cdoTrx.getSession().getSessionID();
            }
        }
        if (this.objySession != null && currSessionID == this.sessionID) {
            return this.objySession;
        }
        String sessionName = "Session_" + this.sessionID;
        if (this.objySession != null) {
            this.objySession.returnSessionToPool();
        }
        if (this.isReader()) {
            this.objySession = this.getStore().getConnection().getReadSessionFromPool(String.valueOf(sessionName) + "_" + this.getRepositoryName());
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("  getObjySession from read pool, session: " + ((Object)((Object)this.objySession)).toString() + " - isOpen: " + this.objySession.isOpen() + " - sessionName:" + this.objySession.getName());
            }
        } else {
            this.objySession = this.getStore().getConnection().getWriteSessionFromPool(String.valueOf(sessionName) + "_" + this.getRepositoryName());
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("  getObjySession from write pool, session: " + ((Object)((Object)this.objySession)).toString() + " - isOpen: " + this.objySession.isOpen() + " - sessionName:" + this.objySession.getName());
            }
        }
        if (!this.objySession.isOpen()) {
            this.objySession.setMrowMode(8);
            this.objySession.setWaitOption(45000);
            this.objySession.setAllowUnregisterableTypes(true);
            if (this.isRead) {
                this.objySession.setOpenMode(1);
            } else {
                this.objySession.setOpenMode(2);
            }
            this.objySession.begin();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("     calling session.begin() for " + ((Object)((Object)this.objySession)).toString() + " - isRead: " + this.isRead);
            }
        } else if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("     session " + ((Object)((Object)this.objySession)).toString() + " already open.");
        }
        return this.objySession;
    }

    private void returnObjySession() {
        this.ensureSessionJoin();
        if (this.objySession == null) {
            return;
        }
        if (this.objySession.isOpen()) {
            this.objySession.commit();
        }
        this.objySession.returnSessionToPool();
        this.objySession = null;
    }

    protected void doDeactivate() throws Exception {
        this.returnObjySession();
    }

    protected void doPassivate() throws Exception {
        this.returnObjySession();
    }

    protected void doUnpassivate() throws Exception {
    }

    protected void doRollback(IStoreAccessor.CommitContext commitContext) {
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Rollback session " + (Object)((Object)this.objySession));
            }
            this.ensureSessionJoin();
            if (this.objySession.isOpen()) {
                this.objySession.abort();
                if (TRACER_DEBUG.isEnabled()) {
                    TRACER_DEBUG.trace("OBJY: session aborted - Session: " + (Object)((Object)this.objySession) + " - open:" + this.objySession.isOpen());
                }
            }
        }
        catch (RuntimeException exception) {
            TRACER_INFO.trace(exception.getMessage(), (Throwable)exception);
            exception.printStackTrace();
            throw exception;
        }
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        long start = System.nanoTime();
        this.ensureSessionBegin();
        try {
            monitor.begin((double)revisionDeltas.length);
            HashSet<ooId> containerToLocks = new HashSet<ooId>();
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(delta.getID());
                containerToLocks.add(containerID);
                ++n2;
            }
            this.objySession.lockContainers(containerToLocks);
            internalCDORevisionDeltaArray = revisionDeltas;
            n = revisionDeltas.length;
            n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta revisionDelta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(revisionDelta, branch, created);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" writeRevisionDeltas: " + revisionDeltas.length + " - time: " + (double)(System.nanoTime() - start) / 1000000.0);
        }
    }

    private void writeRevisionDelta(InternalCDORevisionDelta delta, CDOBranch branch, long created) {
        int deltaVersion = delta.getVersion();
        int newVersion = 1;
        ObjyObject objyObject = this.getObject(delta.getID());
        TRACER_DEBUG.format("writingRevisionDelta getting Object: {0}, v:{1} - BranchId:{2}", new Object[]{objyObject.ooId().getStoreString(), deltaVersion, delta.getBranch().getID()});
        ObjyObject objyOriginalRevision = objyObject.getRevisionByVersion(deltaVersion, delta.getBranch().getID(), this.objySession.getObjectManager());
        if (branch.getID() == delta.getBranch().getID()) {
            newVersion = deltaVersion + 1;
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Writing revision delta: {0}, v:{1} - OID:{2}, v:{3} - BranchId:{4}", new Object[]{delta, deltaVersion, objyObject.ooId().getStoreString(), objyOriginalRevision.getVersion(), objyOriginalRevision.getBranchId()});
            TRACER_DEBUG.format("... delta branch ID: {0} - revision branch ID: {1}", new Object[]{branch.getID(), objyOriginalRevision.getBranchId()});
        }
        if (objyOriginalRevision.getVersion() != deltaVersion) {
            throw new RuntimeException("ObjecitivityStoreAccessor : Dirty write");
        }
        ObjyObject objyNewRevision = null;
        if (this.getStore().isRequiredToSupportAudits()) {
            ObjyObject objyObjectCopy = this.objySession.getObjectManager().copyRevision(this, objyOriginalRevision);
            TRACER_DEBUG.format("  created new object:{0} by copying object:{1} - v:{2} - newBranch:{3}", new Object[]{objyObjectCopy.ooId().getStoreString(), objyOriginalRevision.ooId().getStoreString(), objyOriginalRevision.getVersion(), branch.getID()});
            objyNewRevision = objyObjectCopy;
            objyNewRevision.setBranchId(branch.getID());
            objyObject.addToRevisions(objyNewRevision);
            if (this.getStore().isRequiredToSupportBranches()) {
                ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(branch.getID());
                ooObj anObj = ooObj.create_ooObj((ooId)objyNewRevision.ooId());
                objyBranch.addRevision(anObj);
            }
            if (newVersion > 1) {
                objyOriginalRevision.setRevisedTime(branch.getPoint(created).getTimeStamp() - 1L);
            }
        } else {
            objyNewRevision = objyOriginalRevision;
        }
        ObjectivityFeatureDeltaWriter visitor = new ObjectivityFeatureDeltaWriter(objyNewRevision);
        delta.accept((CDOFeatureDeltaVisitor)visitor);
        objyNewRevision.setCreationTime(branch.getPoint(created).getTimeStamp());
        objyNewRevision.setVersion(newVersion);
    }

    @Override
    public ObjectivityStore getStore() {
        return (ObjectivityStore)super.getStore();
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        if (TRACER_DEBUG.isEnabled()) {
            ObjyObjectManager.getObjectTime = 0L;
            ObjyObjectManager.updateObjectTime = 0L;
            ObjyObjectManager.resourceCheckAndUpdateTime = 0L;
        }
        long start = System.nanoTime();
        this.ensureSessionBegin();
        try {
            InternalCDORevision revision;
            monitor.begin((double)revisions.length);
            HashSet<ooId> containersToLock = new HashSet<ooId>();
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                revision = internalCDORevisionArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(revision.getID());
                containersToLock.add(containerID);
                ++n2;
            }
            internalCDORevisionArray = revisions;
            n = revisions.length;
            n2 = 0;
            while (n2 < n) {
                revision = internalCDORevisionArray[n2];
                this.writeRevision(revision, monitor.fork());
                ++n2;
            }
        }
        finally {
            this.newObjyObjectsMap.clear();
            monitor.done();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" writeRevisions: " + revisions.length + " - time: " + (double)(System.nanoTime() - start) / 1000000.0);
        }
    }

    public ObjyObject getObject(CDOID id) {
        ObjyObject objyObject = this.objySession.getObjectManager().getObject(id);
        return objyObject.getBaseObject();
    }

    private void writeRevision(InternalCDORevision revision, OMMonitor monitor) {
        block15: {
            OMMonitor.Async async = null;
            try {
                ooObj anObj;
                monitor.begin(1000.0);
                async = monitor.forkAsync();
                long __start = System.nanoTime();
                ObjyObject objyObject = this.newObjyObjectsMap.get(revision.getID());
                if (objyObject == null) {
                    objyObject = this.getObject(revision.getID());
                }
                ObjyObjectManager.getObjectTime += System.nanoTime() - __start;
                if (TRACER_DEBUG.isEnabled()) {
                    TRACER_DEBUG.format("Writing revision: {0} - OID: {1}", new Object[]{revision, objyObject.ooId().getStoreString()});
                }
                ObjyObject newObjyRevision = objyObject;
                if (revision.getVersion() > 1) {
                    ObjyObject oldObjyRevision = objyObject.getRevisionByVersion(revision.getVersion() - 1, revision.getBranch().getID(), this.objySession.getObjectManager());
                    if (oldObjyRevision == null) {
                        new IllegalStateException("Revision with version: " + (revision.getVersion() - 1) + " is not in the store.");
                    }
                    if (this.getStore().isRequiredToSupportAudits()) {
                        newObjyRevision = this.objySession.getObjectManager().newObject(revision.getEClass(), oldObjyRevision.ooId());
                        objyObject.addToRevisions(newObjyRevision);
                    } else {
                        newObjyRevision = oldObjyRevision;
                    }
                }
                if (this.getStore().isRequiredToSupportBranches()) {
                    ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(revision.getBranch().getID());
                    anObj = ooObj.create_ooObj((ooId)newObjyRevision.ooId());
                    try {
                        objyBranch.addRevision(anObj);
                    }
                    catch (LockNotGrantedException ex) {
                        ex.printStackTrace();
                    }
                }
                __start = System.nanoTime();
                newObjyRevision.update(this, revision);
                ObjyObjectManager.updateObjectTime += System.nanoTime() - __start;
                if (!revision.isResourceNode()) break block15;
                __start = System.nanoTime();
                ObjyResourceList resourceList = this.objySession.getResourceList(this.getRepositoryName());
                anObj = (ooObj)this.objySession.getFD().objectFrom(resourceList.ooId());
                SmartLock.lock(anObj.getContainer());
                if (revision.isResourceFolder() || revision.isResource()) {
                    resourceList.checkDuplicateResources(this, revision);
                }
                SmartLock.lock(newObjyRevision);
                try {
                    resourceList.add(newObjyRevision);
                }
                catch (LockNotGrantedException ex) {
                    ex.printStackTrace();
                }
                ObjyObjectManager.resourceCheckAndUpdateTime += System.nanoTime() - __start;
            }
            finally {
                async.stop();
                monitor.done();
            }
        }
    }

    protected void doCommit(OMMonitor monitor) {
        long start = System.currentTimeMillis();
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                try {
                    async = monitor.forkAsync();
                    this.ensureSessionJoin();
                    if (TRACER_DEBUG.isEnabled()) {
                        TRACER_DEBUG.trace("Committing ..." + (Object)((Object)this.objySession) + " nc:" + this.objySession.nestCount());
                    }
                    if (this.objySession.isOpen()) {
                        this.objySession.commit();
                    } else {
                        TRACER_DEBUG.trace("Error: calling objySession.commit() without having an open trx.");
                    }
                    if (TRACER_DEBUG.isEnabled()) {
                        TRACER_DEBUG.trace("Committed");
                    }
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            catch (RuntimeException exception) {
                TRACER_INFO.trace(exception.getMessage(), (Throwable)exception);
                exception.printStackTrace();
                throw exception;
            }
        }
        finally {
            monitor.done();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" readRvisions: " + this.readRevisionCount + " - time: " + (double)this.readRevisionTime / 1000000.0);
            TRACER_DEBUG.trace(" fetchCount: " + ObjyObject.fetchCount + " - updateCount: " + ObjyObject.updateCount);
            TRACER_DEBUG.trace("\t commit time: " + (System.currentTimeMillis() - start));
            this.readRevisionTime = 0L;
            this.readRevisionCount = 0;
            ObjyObject.fetchCount = 0;
            ObjyObject.updateCount = 0;
        }
    }

    @Override
    public IObjectivityStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new ObjectivityStoreChunkReader((IStoreAccessor)this, (CDORevision)revision, feature);
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        byte[] bytes = null;
        this.ensureSessionBegin();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("loadPackageUnit for: {0}", new Object[]{packageUnit.getID()});
        }
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        bytes = objyPackageHandler.readPackageBytes(packageUnit);
        EPackage ePackage = this.createEPackage(packageUnit, bytes);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getPackageRegistry());
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)this.zipped, (ResourceSet)resourceSet, (boolean)false);
    }

    private CDOPackageRegistry getPackageRegistry() {
        return this.getStore().getRepository().getPackageRegistry();
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        ObjyResourceList resourceList;
        int size;
        this.ensureSessionBegin();
        String pathPrefix = context.getName();
        boolean exactMatch = context.exactMatch();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("queryResources() for : " + (pathPrefix == null ? "NULL" : pathPrefix) + " - exactMatch: " + exactMatch, new Object[0]);
        }
        if ((size = (resourceList = this.objySession.getResourceList(this.getRepositoryName())).size()) == 0) {
            CDOID resourceID = OBJYCDOIDUtil.getCDOID(null);
            context.addResource(resourceID);
        }
        int i = 0;
        while (i < size) {
            ObjyObject resource = resourceList.getResource(i);
            if (resource != null) {
                ObjyObject resourceRevision = resource;
                if (this.getStore().isRequiredToSupportBranches()) {
                    try {
                        resourceRevision = resource.getRevision(context.getTimeStamp(), context.getBranch().getID(), this.objySession.getObjectManager());
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                } else if (this.getStore().isRequiredToSupportAudits()) {
                    try {
                        resourceRevision = resource.getRevision(context.getTimeStamp(), 0, this.objySession.getObjectManager());
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                }
                if (resourceRevision != null && resourceRevision.getVersion() >= 0) {
                    String resourceName = ObjyResourceList.getResourceName(resourceRevision);
                    CDOID resourceID = OBJYCDOIDUtil.getCDOID(resource.ooId());
                    if (exactMatch && pathPrefix != null && pathPrefix.equals(resourceName) || pathPrefix == null && resourceName == null) {
                        if (!context.addResource(resourceID)) {
                            if (!TRACER_DEBUG.isEnabled()) break;
                            TRACER_DEBUG.format("   queryResources(1.1) got: " + resource.ooId().getStoreString() + " - version: " + resource.getVersion(), new Object[0]);
                            break;
                        }
                    } else if (!exactMatch && resourceName != null && resourceName.startsWith(pathPrefix)) {
                        context.addResource(resourceID);
                        if (TRACER_DEBUG.isEnabled()) {
                            TRACER_DEBUG.format("   queryResources(1.2) got: " + resource.ooId().getStoreString() + " - version: " + resource.getVersion(), new Object[0]);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        this.ensureSessionBegin();
        Set<CDOID> targetIDs = context.getTargetObjects().keySet();
        Map sourceCandidates = context.getSourceCandidates();
        CDOBranch branch = context.getBranch();
        ObjyBranchManager branchManager = this.objySession.getBranchManager(this.getRepositoryName());
        ObjyBranch objyBranch = branchManager.getBranch(branch.getID());
        ObjyObject objyObject = null;
        SortedSet<?> revisions = objyBranch.getRevisions();
        for (Object anObj : revisions) {
            objyObject = this.objySession.getObjectManager().getObject(((ooObj)anObj).getOid());
            EClass eClass = ObjySchema.getEClass(this.getStore(), objyObject.objyClass());
            CDOID sourceID = objyObject.getRevisionId();
            List eReferences = (List)sourceCandidates.get(eClass);
            if (eReferences == null) continue;
            for (EReference eReference : eReferences) {
                if (eReference.isMany()) {
                    List<Object> results = objyObject.fetchList(this, (EStructuralFeature)eReference, 0, -1);
                    if (results == null) continue;
                    try {
                        int index = 0;
                        for (Object id : results) {
                            if (this.queryXRefs(context, targetIDs, (CDOID)id, sourceID, eReference, index++)) continue;
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                Object value = objyObject.get((EStructuralFeature)eReference);
                CDOID id = (CDOID)value;
                if (this.queryXRefs(context, targetIDs, id, sourceID, eReference, 0)) continue;
                return;
            }
        }
    }

    private boolean queryXRefs(IStoreAccessor.QueryXRefsContext context, Set<CDOID> targetIDs, CDOID targetID, CDOID sourceID, EReference sourceReference, int index) {
        for (CDOID id : targetIDs) {
            if (!id.equals(targetID) || context.addXRef(targetID, sourceID, sourceReference, index)) continue;
            return false;
        }
        return true;
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("readPackageUnits()", new Object[0]);
        }
        this.ensureSessionBegin();
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        Collection<InternalCDOPackageUnit> packageUnits = objyPackageHandler.readPackageUnits();
        return packageUnits;
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        boolean ok;
        long __start = System.nanoTime();
        this.ensureSessionBegin();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("RR - Read rev for: {0}, TS:{1}", new Object[]{id, branchPoint.getTimeStamp()});
        }
        if (id instanceof CDOIDExternal) {
            TRACER_DEBUG.trace("objy can't read revision for external CDOID: " + id.toString());
            return null;
        }
        ObjyObject objyObject = this.getObject(id);
        if (objyObject == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("RR - objyObject is NULL 4 ID:" + id, new Object[0]);
            }
            return null;
        }
        InternalCDORevision revision = this.createRevision(objyObject, id);
        revision.setBranchPoint(branchPoint);
        ObjyObject objyRevision = objyObject;
        if (this.getStore().isRequiredToSupportBranches()) {
            try {
                objyRevision = objyObject.getRevision(branchPoint.getTimeStamp(), branchPoint.getBranch().getID(), this.objySession.getObjectManager());
                if (objyRevision == null) {
                    TRACER_DEBUG.format("RR - branches ID:{0}, OB:{1}, BPB:{2}, BPTS:{3}", new Object[]{id, objyObject.getBranchId(), branchPoint.getBranch().getID(), branchPoint.getTimeStamp()});
                }
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        } else if (this.getStore().isRequiredToSupportAudits()) {
            try {
                objyRevision = objyObject.getRevision(branchPoint.getTimeStamp(), 0, this.objySession.getObjectManager());
                if (objyRevision == null) {
                    TRACER_DEBUG.format("RR - audit ID:{0}, OB:{1}, BPB:{2}, BPTS:{3}", new Object[]{id, objyObject.getBranchId(), branchPoint.getBranch().getID(), branchPoint.getTimeStamp()});
                }
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        }
        if (objyRevision == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("RR - objyRevision is NULL 4 ID:" + id, new Object[0]);
            }
            return null;
        }
        if (objyRevision.getVersion() < 0) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("RR - ...revision for: {0} - OID: {1} is detached.", new Object[]{id, objyObject.ooId().getStoreString()});
            }
            EClass eClass = ObjySchema.getEClass(this.getStore(), objyObject.objyClass());
            return new DetachedCDORevision(eClass, id, branchPoint.getBranch(), -objyRevision.getVersion(), objyRevision.getCreationTime());
        }
        CDOBranchPoint branchPoint2 = revision.getBranch().getPoint(objyRevision.getCreationTime());
        revision.setBranchPoint(branchPoint2);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("RR - Fetching revision details for: {0} - OID:{1}", new Object[]{id, objyRevision.ooId().getStoreString()});
        }
        if (!(ok = objyRevision.fetch(this, revision, listChunk))) {
            TRACER_DEBUG.format("RR - Fetch rev failed 4: {0}, :{1}", new Object[]{id, objyRevision.ooId().getStoreString()});
        }
        this.readRevisionTime += System.nanoTime() - __start;
        ++this.readRevisionCount;
        return ok ? revision : null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        ObjyObject objyObject;
        long __start = System.nanoTime();
        this.ensureSessionBegin();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("RRBV - Read rev 4: {0}, ver: {1}", new Object[]{id, branchVersion.getVersion()});
        }
        if ((objyObject = this.getObject(id)) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("RRBV - objyObject is NULL for ID: " + id, new Object[0]);
            }
            return null;
        }
        ObjyObject objyRevision = null;
        objyRevision = objyObject.getRevisionByVersion(branchVersion.getVersion(), branchVersion.getBranch().getID(), this.objySession.getObjectManager());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Reading revision by version {0} for: {1} - OID: {2}", new Object[]{branchVersion.getVersion(), id, objyObject.ooId().getStoreString()});
        }
        if (objyRevision == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("RRBV - objyRevision is NULL for ID: ", new Object[]{id});
            }
            return null;
        }
        InternalCDORevision revision = this.createRevision(objyRevision, id);
        revision.setVersion(branchVersion.getVersion());
        revision.setBranchPoint(branchVersion.getBranch().getHead());
        boolean ok = objyRevision.fetch(this, revision, listChunk);
        if (ok && objyRevision.getVersion() != branchVersion.getVersion()) {
            throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + branchVersion + ".");
        }
        this.readRevisionTime += System.nanoTime() - __start;
        ++this.readRevisionCount;
        return ok ? revision : null;
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("writePackageUnits()", new Object[0]);
        }
        this.ensureSessionBegin();
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        InternalCDOPackageRegistry packageRegistry = this.getStore().getRepository().getPackageRegistry();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            objyPackageHandler.writePackages((CDOPackageRegistry)packageRegistry, packageUnit, monitor);
            ++n2;
        }
    }

    private InternalCDORevision createRevision(ObjyObject objyObject, CDOID id) {
        EClass eClass = ObjySchema.getEClass(this.getStore(), objyObject.objyClass());
        if (eClass == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("OBJY: Can't find eClass for id:" + id);
            }
            return null;
        }
        return this.getStore().createRevision(eClass, id);
    }

    private String getRepositoryName() {
        return this.getStore().getRepository().getName();
    }

    public void addIDMappings(InternalCommitContext commitContext, OMMonitor monitor) {
        long __start = System.nanoTime();
        this.ensureSessionBegin();
        if (commitContext.getNewObjects().length > 0) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("creating " + commitContext.getNewObjects().length + " new objects and assigning new IDs");
            }
            InternalCDORevision[] newObjects = commitContext.getNewObjects();
            try {
                monitor.begin((double)newObjects.length);
                ObjyPlacementManagerLocal placementManager = new ObjyPlacementManagerLocal(this.getStore(), this.objySession, commitContext, this.newObjyObjectsMap);
                InternalCDORevision[] internalCDORevisionArray = newObjects;
                int n = newObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDORevision revision = internalCDORevisionArray[n2];
                    try {
                        placementManager.processRevision(revision);
                    }
                    catch (ObjyRuntimeException ex) {
                        System.out.println("IS: Exception, Session: " + (Object)((Object)this.objySession) + " open status: " + this.objySession.isOpen());
                        ex.printStackTrace();
                    }
                    monitor.worked();
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" addIDMappings for " + commitContext.getNewObjects().length + " - time: " + (double)(System.nanoTime() - __start) / 1000000.0);
            TRACER_DEBUG.trace("  createObjects : " + ObjyObject.createObjectCount + " - time: " + (double)ObjyObject.createObjectTime / 1000000.0);
            ObjyObject.createObjectTime = 0L;
            ObjyObject.createObjectCount = 0;
        }
    }

    protected CDOID getNextCDOID(CDORevision revision) {
        throw new UnsupportedOperationException();
    }

    public void ensureActiveSession() {
        this.ensureSessionBegin();
    }

    protected void ensureSessionBegin() {
        this.getObjySession();
        if (!this.objySession.isJoined()) {
            this.objySession.join();
        }
        if (!this.objySession.isOpen()) {
            if (this.isRead) {
                this.objySession.setOpenMode(1);
            } else {
                this.objySession.setOpenMode(2);
            }
            this.objySession.begin();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace(" ensureBeginSession() called begin() on session: " + (Object)((Object)this.objySession) + " [name: " + this.objySession.getName() + " - open: " + this.objySession.isOpen() + "]");
            }
        }
    }

    private void ensureSessionJoin() {
        assert (this.objySession != null);
        if (this.objySession != null && !this.objySession.isJoined()) {
            this.objySession.join();
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.ensureSessionBegin();
        ObjyCommitInfoHandler commitInfoHandler = this.getStore().getCommitInfoHandler();
        List<ObjyCommitInfo> commitInfoList = commitInfoHandler.getCommitInfo(branch, startTime, endTime);
        InternalSessionManager manager = this.getSession().getManager();
        InternalRepository repository = manager.getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        for (ObjyCommitInfo ooCommitInfo : commitInfoList) {
            long timeStamp = ooCommitInfo.getTimeStamp();
            long previousTimeStamp = ooCommitInfo.getPreviousTimeStamp();
            String userID = ooCommitInfo.getUserId();
            String comment = ooCommitInfo.getComment();
            CDOBranch infoBranch = branch;
            if (infoBranch == null) {
                int id = ooCommitInfo.getBranchId();
                infoBranch = branchManager.getBranch(id);
            }
            CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, previousTimeStamp, userID, comment, null);
            handler.handleCommitInfo(commitInfo);
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.ensureSessionBegin();
        try {
            ObjyCommitInfoHandler commitInfoHandler = this.getStore().getCommitInfoHandler();
            commitInfoHandler.writeCommitInfo(branch.getID(), timeStamp, previousTimeStamp, userID, comment);
        }
        catch (ObjyRuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        if ("OBJY".equals(info.getQueryLanguage())) {
            return new ObjectivityQueryHandler(this);
        }
        return null;
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.ensureSessionBegin();
        boolean convertToUpdate = false;
        if (this.isRead) {
            TRACER_DEBUG.trace("-->> createBranch() - Hack... Hack... changing read to update.");
            this.objySession.commit();
            this.objySession.setOpenMode(2);
            convertToUpdate = true;
            this.objySession.begin();
        }
        Pair<Integer, Long> retValue = this.objySession.getBranchManager(this.getRepositoryName()).createBranch(branchID, branchInfo);
        if (convertToUpdate) {
            this.objySession.commit();
            this.objySession.setOpenMode(1);
            this.objySession.begin();
        }
        return retValue;
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        this.ensureSessionBegin();
        ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(branchID);
        return objyBranch != null ? objyBranch.getBranchInfo() : null;
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        int count = 0;
        List<ObjyBranch> branches = this.objySession.getBranchManager(this.getRepositoryName()).getBranches(startID, endID);
        InternalCDOBranchManager branchManager = this.getStore().getRepository().getBranchManager();
        for (ObjyBranch objyBranch : branches) {
            InternalCDOBranch branch = branchManager.getBranch(objyBranch.getBranchId(), new InternalCDOBranchManager.BranchLoader.BranchInfo(objyBranch.getBranchName(), objyBranch.getBaseBranchId(), objyBranch.getBaseBranchTimeStamp()));
            branchHandler.handleBranch((CDOBranch)branch);
            ++count;
        }
        return count;
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        this.ensureSessionBegin();
        ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
        List<ObjyBranch> objyBranchList = this.objySession.getBranchManager(this.getRepositoryName()).getSubBranches(branchID);
        for (ObjyBranch objyBranch : objyBranchList) {
            InternalCDOBranchManager.BranchLoader.SubBranchInfo subBranchInfo = new InternalCDOBranchManager.BranchLoader.SubBranchInfo(objyBranch.getBranchId(), objyBranch.getBranchName(), objyBranch.getBaseBranchTimeStamp());
            result.add(subBranchInfo);
        }
        return result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.ensureSessionBegin();
        InternalRepository repository = this.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        Iterator itr = this.objySession.getFD().scan("ObjyBase");
        ObjyObject objyObject = null;
        while (itr.hasNext()) {
            objyObject = this.objySession.getObjectManager().getObject(((ooObj)itr).getOid());
            if (this.handleRevision(objyObject, eClass, branch, timeStamp, exactTime, handler, revisionManager, branchManager)) continue;
            return;
        }
        throw new UnsupportedOperationException();
    }

    private boolean handleRevision(ObjyObject objyObject, EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler, CDORevisionManager revisionManager, CDOBranchManager branchManager) {
        long endTime;
        long startTime;
        if (objyObject.getVersion() < 0) {
            return true;
        }
        if (eClass != null && ObjySchema.getEClass(this.getStore(), objyObject.objyClass()) != eClass) {
            return true;
        }
        if (branch != null && objyObject.getBranchId() != (long)branch.getID()) {
            return true;
        }
        if (timeStamp != -1L && (exactTime ? timeStamp != 0L && objyObject.getCreationTime() != timeStamp : !CDOCommonUtil.isValidTimeStamp((long)timeStamp, (long)(startTime = objyObject.getCreationTime()), (long)(endTime = objyObject.getRevisedTime())))) {
            return true;
        }
        CDOBranchVersion branchVersion = branchManager.getBranch((int)objyObject.getBranchId()).getVersion(Math.abs(objyObject.getVersion()));
        InternalCDORevision revision = (InternalCDORevision)revisionManager.getRevisionByVersion(OBJYCDOIDUtil.getCDOID(objyObject.ooId()), branchVersion, -1, true);
        return handler.handleRevision((CDORevision)revision);
    }

    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        monitor.begin((double)segments.length);
        try {
            this.ensureSessionBegin();
            ObjyBranchManager objyBranchManager = this.objySession.getBranchManager(this.getRepositoryName());
            ObjyObjectManager objyObjectManager = this.objySession.getObjectManager();
            HashSet<CDOID> results = new HashSet<CDOID>();
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                ObjyBranch objyBranch = objyBranchManager.getBranch(segment.getBranch().getID());
                SortedSet<?> revisions = objyBranch.getRevisions();
                this.readChangeSet(monitor.fork(), segment, objyObjectManager, revisions, results);
                ++n2;
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("ChangeSet " + ((Object)results).toString());
            }
            HashSet<CDOID> hashSet = results;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    protected void readChangeSet(OMMonitor monitor, CDOChangeSetSegment segment, ObjyObjectManager objyObjectManager, SortedSet<?> revisions, Set<CDOID> results) {
        int size = revisions.size();
        monitor.begin((double)size);
        OMMonitor.Async async = null;
        try {
            async = monitor.forkAsync();
            for (ooObj anObj : revisions) {
                ObjyObject objyObject = objyObjectManager.getObject(anObj.getOid());
                long creationTime = objyObject.getCreationTime();
                long revisedTime = objyObject.getRevisedTime();
                if (creationTime >= segment.getTimeStamp() && (revisedTime <= segment.getEndTime() || revisedTime == 0L)) {
                    results.add(objyObject.getRevisionId());
                }
                monitor.worked();
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    public void queryLobs(List<byte[]> ids) {
        throw new UnsupportedOperationException();
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void loadLob(byte[] id, OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawStore(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void rawStore(InternalCDORevision revision, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void rawStore(byte[] id, long size, InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawStore(byte[] id, long size, Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void rawDelete(CDOID id, int version, CDOBranch branch, EClass eClass, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void rawCommit(double commitWork, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        throw new UnsupportedOperationException();
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        this.ensureSessionBegin();
        InternalCDOBranchManager branchManager = this.getStore().getRepository().getBranchManager();
        ObjyLockAreaManager objyLockAreaManager = this.objySession.getLockAreaManager(this.getRepositoryName());
        objyLockAreaManager.getLockAreas(branchManager, userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        throw new UnsupportedOperationException();
    }

    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    public void unlock(String durableLockingID) {
        throw new UnsupportedOperationException();
    }
}

