/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreChunkReader;
import org.eclipse.emf.cdo.spi.server.StoreChunkReader;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectivityStoreChunkReader
extends StoreChunkReader
implements IObjectivityStoreChunkReader {
    public ObjectivityStoreChunkReader(IStoreAccessor accessor, CDORevision revision, EStructuralFeature feature) {
        super(accessor, revision, feature);
    }

    @Override
    public ObjectivityStoreAccessor getAccessor() {
        return (ObjectivityStoreAccessor)super.getAccessor();
    }

    public List<IStoreChunkReader.Chunk> executeRead() {
        CDOID id = this.getRevision().getID();
        this.getAccessor().ensureActiveSession();
        ObjyObject objyObject = this.getAccessor().getObject(id);
        ObjyObject objyRevision = objyObject.getRevisionByVersion(this.getRevision().getVersion(), this.getRevision().getBranch().getID(), this.getAccessor().getObjySession().getObjectManager());
        List chunks = this.getChunks();
        for (IStoreChunkReader.Chunk chunk : chunks) {
            int chunkStartIndex = chunk.getStartIndex();
            int chunkSize = chunk.size();
            List<Object> objects = objyRevision.fetchList(this.getAccessor(), this.getFeature(), chunkStartIndex, chunkSize);
            int i = 0;
            for (Object obj : objects) {
                chunk.add(i++, obj);
            }
        }
        return chunks;
    }
}

