/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.app.Iterator;
import com.objy.db.app.Session;
import com.objy.db.app.ooContObj;
import com.objy.db.app.ooDBObj;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.net4j.util.io.TMPUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.w3c.dom.Element;

public class FdManager {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, FdManager.class);
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, FdManager.class);
    private static final String DEFAULT_VALUE = "_DEFAULT_";
    private String fdName = "test";
    private String fdFileHost = "_DEFAULT_";
    private String fdDirPath = null;
    private String lockServerHost = "_DEFAULT_";
    private String fdNumber = "12345";
    private String pageSize = "_DEFAULT_";
    private String fdFilePath = null;
    private String bootFilePath = null;
    private boolean initialized = false;
    private String logDirPath = null;

    protected void initialize(boolean reset) {
        if (this.fdDirPath == null) {
            File dataFolder = TMPUtil.createTempFolder((String)"Objy", (String)"data");
            this.fdDirPath = dataFolder.getAbsolutePath();
        }
        if (this.noDefaultValueSet(this.logDirPath)) {
            this.logDirPath = this.fdDirPath;
        }
        if (this.fdFilePath == null) {
            this.fdFilePath = String.valueOf(this.fdDirPath) + File.separator + this.fdName + ".fdb";
        }
        if (this.bootFilePath == null) {
            this.bootFilePath = String.valueOf(this.fdDirPath) + File.separator + this.fdName + ".boot";
        }
        if (!this.initialized) {
            this.initialized = reset ? this.resetFD() : (!this.fdExists() ? this.createFD() : true);
        }
    }

    public String getFd() {
        return this.bootFilePath;
    }

    public boolean resetFD() {
        return this.deleteDBs();
    }

    public boolean resetFD_OLD() {
        boolean bRet = true;
        if (this.fdExists()) {
            bRet = this.deleteFD();
        }
        if (bRet) {
            bRet = this.createFD();
        }
        return bRet;
    }

    private boolean createFD() {
        boolean bRet = false;
        Process proc = null;
        StringBuilder command = new StringBuilder(256);
        command.append("oonewfd");
        command.append(" -fdfilepath ").append(this.fdFilePath);
        command.append(" -lockserver ").append(this.getLockServerHost());
        command.append(" -fdnumber ").append(this.fdNumber);
        command.append(" -pagesize ").append(this.getPageSize());
        command.append(' ').append(this.bootFilePath);
        TRACER_INFO.trace("Createing FD: '" + this.bootFilePath + "'.");
        try {
            proc = Runtime.getRuntime().exec(command.toString());
            if (proc.waitFor() != 0) {
                this.dumpStream(proc.getErrorStream());
                throw new RuntimeException("Error creating FD...");
            }
            this.dumpStream(proc.getInputStream());
            bRet = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    public boolean deleteFD() {
        boolean bRet = false;
        Process proc = null;
        File file = new File(this.bootFilePath);
        if (!file.exists()) {
            return true;
        }
        String command = "oodeletefd -force " + this.bootFilePath;
        TRACER_INFO.trace("Deleting FD: '" + this.bootFilePath + "'.");
        try {
            proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                this.dumpStream(proc.getErrorStream());
                throw new RuntimeException("Error deleting FD...");
            }
            this.dumpStream(proc.getInputStream());
            bRet = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    private boolean deleteDBs() {
        boolean bRet = false;
        Process proc = null;
        String command = "oodeletedb -all  -force " + this.bootFilePath;
        TRACER_INFO.trace("Deleting all DBs from : '" + this.bootFilePath + "'.");
        try {
            proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                this.dumpStream(proc.getErrorStream());
                throw new RuntimeException("Error deleting DBs...");
            }
            this.dumpStream(proc.getInputStream());
            bRet = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    private boolean deleteDBs_cl() {
        boolean bRet = false;
        Process proc = null;
        String command = "oodeletedb -all  -force " + this.bootFilePath;
        TRACER_INFO.trace("Deleting all DBs from : '" + this.bootFilePath + "'.");
        try {
            proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                this.dumpStream(proc.getErrorStream());
                throw new RuntimeException("Error deleting DBs...");
            }
            this.dumpStream(proc.getInputStream());
            bRet = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    private boolean fdExists() {
        boolean bRet = false;
        File file = new File(this.bootFilePath);
        bRet = file.exists();
        return bRet;
    }

    private boolean loadSchema() {
        boolean bRet = false;
        Process proc = null;
        String command = "ooschemaupgrade -infile config" + File.separator + "schema.txt " + this.bootFilePath;
        TRACER_DEBUG.trace("Loading schema to FD: '" + this.bootFilePath + "'.");
        try {
            proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                this.dumpStream(proc.getErrorStream());
            } else {
                this.dumpStream(proc.getInputStream());
                bRet = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return bRet;
    }

    public String getFdFileHost() {
        if (this.noDefaultValueSet(this.fdFileHost)) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                this.fdFileHost = address.getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return this.fdFileHost;
    }

    public void setFdFileHost(String fdFileHost) {
        this.fdFileHost = fdFileHost;
    }

    public String getFdDirPath() {
        return this.fdDirPath;
    }

    public void setFdDirPath(String fdDirPath) {
        this.fdDirPath = fdDirPath;
    }

    public String getLockServerHost() {
        if (this.noDefaultValueSet(this.lockServerHost)) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                this.lockServerHost = address.getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return this.lockServerHost;
    }

    public void setLockServerHost(String lockServerHost) {
        this.lockServerHost = lockServerHost;
    }

    public String getFdNumber() {
        return this.fdNumber;
    }

    public void setFdNumber(String fdNumber) {
        this.fdNumber = fdNumber;
    }

    public String getPageSize() {
        if (this.noDefaultValueSet(this.pageSize)) {
            this.pageSize = "8192";
        }
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getFdName() {
        return this.fdName;
    }

    public void setFdName(String fdName) {
        this.fdName = fdName;
    }

    private void dumpStream(InputStream inStream) {
        BufferedInputStream inBuffStream = new BufferedInputStream(inStream);
        try {
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = inBuffStream.read(buffer)) != -1) {
                String chunk = new String(buffer, 0, bytesRead);
                TRACER_DEBUG.trace(chunk);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configure() {
        this.initialize(false);
    }

    public void configure(Element storeConfig) {
    }

    public void configure(String name) {
        this.fdDirPath = String.valueOf(this.fdDirPath) + File.separator + name;
        File dir = new File(this.fdDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Integer number = Math.abs(new Random().nextInt() % 65000);
        this.fdNumber = number.toString();
        this.initialize(false);
    }

    public void removeData() {
        Session session = new Session();
        session.setIndexMode(3);
        session.begin();
        Iterator itr = session.getFD().containedDBs();
        ooDBObj dbObj = null;
        ArrayList<ooDBObj> dbList = new ArrayList<ooDBObj>();
        ArrayList<ooContObj> contList = new ArrayList<ooContObj>();
        while (itr.hasNext()) {
            dbObj = (ooDBObj)itr.next();
            dbList.add(dbObj);
            Iterator contItr = dbObj.contains();
            while (contItr.hasNext()) {
                contList.add((ooContObj)contItr.next());
            }
        }
        for (ooContObj cont : contList) {
            cont.delete();
        }
        session.commit();
        session.terminate();
    }

    boolean noDefaultValueSet(String value) {
        return value == null || value.length() == 0 || value.equals(DEFAULT_VALUE);
    }

    public void setlogDirPath(String logDirPath) {
        this.logDirPath = logDirPath;
    }

    public String getLogPath() {
        return this.logDirPath;
    }
}

