/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Class;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooTreeListX;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.IManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListId;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.TypeConvert;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ManyReferenceMapper
extends BasicTypeMapper
implements IManyTypeMapper {
    static d_Class dClassObject = null;
    static ManyReferenceMapper INSTANCE = new ManyReferenceMapper();

    private static d_Class getArrayListClass() {
        if (dClassObject == null) {
            dClassObject = ObjySchema.getTopModule().resolve_class(ObjyArrayListId.className);
        }
        return dClassObject;
    }

    public boolean createSchema(Proposed_Class propClass, EStructuralFeature feature) {
        try {
            propClass.add_ref_attribute(-1, d_Access_Kind.d_PUBLIC, feature.getName(), 1L, ObjyArrayListId.className, false);
            return true;
        }
        catch (ObjyRuntimeException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Object getValue(ObjyObject internal, EStructuralFeature feature, int index) {
        ObjyArrayListId list = this.getList(internal, feature);
        if (list != null) {
            return list.get(index);
        }
        try {
            throw new Exception("Trying to getValue of object while the list is null.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setValue(ObjyObject internal, EStructuralFeature feature, int index, Object newValue) {
        ObjyArrayListId list = this.getList(internal, feature);
        try {
            if (list == null) {
                throw new Exception("Trying to setValue for object while the list is null.");
            }
            list.set(index, TypeConvert.toOoId(newValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjyArrayListId getList(ObjyObject objyObject, EStructuralFeature feature) {
        String attributeName = this.getAttributeName(feature);
        ObjyArrayListId list = (ObjyArrayListId)objyObject.getFeatureList(attributeName);
        if (list == null) {
            try {
                ooId oid = objyObject.get_ooId(attributeName);
                if (!oid.isNull()) {
                    list = new ObjyArrayListId(Class_Object.class_object_from_oid((ooId)oid));
                    objyObject.setFeatureList(attributeName, list);
                }
            }
            catch (ObjyRuntimeException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public int size(ObjyObject objyObject, EStructuralFeature feature) {
        ObjyArrayListId list = this.getList(objyObject, feature);
        return (int)(list == null ? 0L : list.size());
    }

    public void add(ObjyObject objyObject, EStructuralFeature feature, int index, Object value) {
        ooId obj = TypeConvert.toOoId(value);
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            list.add(index, obj);
        } else {
            try {
                throw new Exception("Trying to add objects while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addAll(ObjyObject objyObject, EStructuralFeature feature, int index, Object[] value) {
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            list.addAll(index, value);
        } else {
            try {
                throw new Exception("Trying to addAll objects while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean validate(d_Attribute ooAttribute, EStructuralFeature feature) {
        System.out.println("OBJYIMPL: ManyReferenceMapper.validate() - not implemented.");
        return true;
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
        ooTreeListX list = new ooTreeListX(2, false);
        ooObj anObj = ooObj.create_ooObj((ooId)classObject.objectID());
        anObj.cluster((Object)list);
        classObject.nset_ooId(this.getAttributeName(feature), list.getOid());
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        String attributeName = this.getAttributeName(feature);
        ooId tobeDeleted = objyObject.get_ooId(attributeName);
        ooObj objectToDelete = ooObj.create_ooObj((ooId)tobeDeleted);
        objectToDelete.delete();
        objyObject.set_ooId(this.getAttributeName(feature), null);
        objyObject.setFeatureList(attributeName, null);
    }

    public void clear(ObjyObject objyObject, EStructuralFeature feature) {
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            list.clear();
        } else {
            try {
                throw new Exception("Trying to clear objects while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature, int index) {
        Object oldValue = this.getValue(objyObject, feature, index);
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            list.remove(index);
        } else {
            try {
                throw new Exception("Trying to remove element while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return oldValue;
    }

    public Object[] getAll(ObjyObject objyObject, EStructuralFeature feature, int index, int chunkSize) {
        int size = this.size(objyObject, feature);
        if (chunkSize != -1) {
            size = Math.min(size, chunkSize);
        }
        Object[] ooIds = null;
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            ooIds = list.getAll(index, size);
        } else {
            try {
                throw new Exception("Trying to getAll objects while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ooIds;
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void setAll(ObjyObject objyObject, EStructuralFeature feature, int index, Object[] newValues) {
        this.addAll(objyObject, feature, 0, newValues);
    }

    public void move(ObjyObject objyObject, EStructuralFeature feature, int targetIndex, int sourceIndex) {
        ObjyArrayListId list = this.getList(objyObject, feature);
        if (list != null) {
            list.move(targetIndex, sourceIndex);
        } else {
            try {
                throw new Exception("Trying to move element while the list is null.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

