/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Basic_Attribute;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.Proposed_Property;
import com.objy.as.app.VArray_Object;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Module;
import com.objy.as.app.ooBaseType;
import java.util.Date;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.IManyTypeMapper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class NumericManyTypeMapper
extends BasicTypeMapper
implements IManyTypeMapper {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, NumericManyTypeMapper.class);
    public static TMBoolean TMBOOLEAN = new TMBoolean();
    public static TMByte TMBYTE = new TMByte();
    public static TMChar TMCHAR = new TMChar();
    public static TMDate TMDATE = new TMDate();
    public static TMDouble TMDOUBLE = new TMDouble();
    public static TMFloat TMFLOAT = new TMFloat();
    public static TMInteger TMINTEGER = new TMInteger();
    public static TMLong TMLONG = new TMLong();
    public static TMShort TMSHORT = new TMShort();

    protected abstract Object fromNumericValue(Numeric_Value var1, boolean var2);

    protected abstract Numeric_Value toNumericValue(Object var1);

    protected abstract ooBaseType getObjyBaseType();

    private String embeddedClassName() {
        return "oo_" + this.getObjyBaseType() + "_Class";
    }

    private d_Class getEmbeddedClass() {
        d_Class embeddedClass = ObjySchema.getTopModule().resolve_class(this.embeddedClassName());
        return embeddedClass;
    }

    private boolean createEmbeddedClass() {
        boolean bDone = true;
        d_Module top_mod = ObjySchema.getTopModule();
        boolean inProcess = top_mod.proposed_classes().hasNext();
        Proposed_Class propClass = top_mod.propose_new_class(this.embeddedClassName());
        propClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, "value", 1L, this.getObjyBaseType());
        propClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, "isNull", 1L, ooBaseType.ooBOOLEAN);
        if (!inProcess) {
            top_mod.activate_proposals(true, true);
        }
        return bDone;
    }

    public boolean createSchema(Proposed_Class proposedClass, EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Adding attribute " + feature.getName() + "  " + this.getClass().getName());
        }
        if (this.getEmbeddedClass() == null && !this.createEmbeddedClass()) {
            return false;
        }
        proposedClass.add_varray_attribute(-1, d_Access_Kind.d_PUBLIC, this.getAttributeName(feature), 1L, this.embeddedClassName());
        return false;
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
        Proposed_Property prop = proposedooClass.resolve_property(this.getAttributeName(feature));
        if (prop instanceof Proposed_Basic_Attribute) {
            Proposed_Basic_Attribute attr = (Proposed_Basic_Attribute)prop;
            attr.change_base_type(this.getObjyBaseType());
        }
    }

    public boolean validate(d_Attribute dAttribute, EStructuralFeature feature) {
        System.out.println(">>>OBJYIMPL: NumericManyTypeMapper.validate() - not implemented.");
        return true;
    }

    public void setValue(ObjyObject objyObject, EStructuralFeature feature, int index, Object newValue) {
        boolean isNull = newValue == null;
        Numeric_Value numericValue = this.toNumericValue(newValue);
        Numeric_Value isNullValue = isNull ? numericTrue : numericFalse;
        Class_Object embedded = this.getArray(objyObject, feature).get_class_obj((long)index);
        embedded.set_numeric(0, numericValue);
        embedded.set_numeric(1, isNullValue);
    }

    public Object getValue(ObjyObject objyObject, EStructuralFeature feature, int index) {
        Numeric_Value numericValue = null;
        Class_Object embedded = this.getArray(objyObject, feature).get_class_obj((long)index);
        numericValue = embedded.get_numeric(0);
        boolean isNull = embedded.get_numeric(1).booleanValue();
        return this.fromNumericValue(numericValue, isNull);
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature, int index) {
        long size = (int)this.getArray(objyObject, feature).size();
        int i = index;
        while ((long)i < size - 1L) {
            this.setValue(objyObject, feature, i, this.getValue(objyObject, feature, i + 1));
            ++i;
        }
        this.getArray(objyObject, feature).resize(size - 1L);
        return null;
    }

    public void add(ObjyObject objyObject, EStructuralFeature feature, int index, Object value) {
        int arraySize = this.size(objyObject, feature);
        if (index < arraySize - 1) {
            VArray_Object array = this.getArray(objyObject, feature);
            array.resize((long)(arraySize + 1));
            int i = arraySize;
            while (i > index) {
                Class_Object newEmbedded = array.get_class_obj((long)i);
                Class_Object oldEmbedded = array.get_class_obj((long)(i - 1));
                newEmbedded.set_numeric(0, oldEmbedded.get_numeric(0));
                newEmbedded.set_numeric(1, oldEmbedded.get_numeric(1));
                --i;
            }
        }
        if (index != -1 && index > arraySize) {
            throw new UnsupportedOperationException("adding object beyond VArray size()?!!... Implement Me!!!");
        }
        this.getArray(objyObject, feature).resize((long)(arraySize + 1));
        this.setValue(objyObject, feature, index, value);
    }

    public void addAll(ObjyObject objyObject, EStructuralFeature feature, int index, Object[] values) {
        int arraySize = this.size(objyObject, feature);
        if (index < arraySize - 1) {
            throw new UnsupportedOperationException("adding objects inside VArray?!!... Implement Me!!!");
        }
        if (index != -1 && index > arraySize) {
            throw new UnsupportedOperationException("adding objects beyond VArray size()?!!... Implement Me!!!");
        }
        int newSize = arraySize + values.length;
        this.getArray(objyObject, feature).resize((long)newSize);
        int i = 0;
        while (i < values.length) {
            this.setValue(objyObject, feature, arraySize + i, values[i]);
            ++i;
        }
    }

    public void clear(ObjyObject objyObject, EStructuralFeature feature) {
        this.getArray(objyObject, feature).resize(0L);
    }

    public void setAll(ObjyObject objyObject, EStructuralFeature feature, int index, Object[] newValues) {
        VArray_Object array = this.getArray(objyObject, feature);
        array.resize((long)newValues.length);
        int i = 0;
        while (i < newValues.length) {
            this.setValue(objyObject, feature, i, newValues[i]);
            ++i;
        }
    }

    public Object[] getAll(ObjyObject objyObject, EStructuralFeature feature, int index, int chunkSize) {
        int size = this.size(objyObject, feature);
        if (chunkSize != -1) {
            size = Math.min(size, chunkSize);
        }
        Object[] values = new Object[size];
        int i = 0;
        while (i < size) {
            values[i] = this.getValue(objyObject, feature, i + index);
            ++i;
        }
        return values;
    }

    public int size(ObjyObject objyObject, EStructuralFeature feature) {
        return (int)this.getArray(objyObject, feature).size();
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void move(ObjyObject objyObject, EStructuralFeature feature, int targetIndex, int sourceIndex) {
        if (targetIndex == sourceIndex) {
            return;
        }
        Object value = this.getValue(objyObject, feature, sourceIndex);
        if (sourceIndex > targetIndex) {
            int i = sourceIndex;
            while (i > targetIndex) {
                this.setValue(objyObject, feature, i, this.getValue(objyObject, feature, i - 1));
                --i;
            }
        } else if (sourceIndex < targetIndex) {
            int i = sourceIndex;
            while (i < targetIndex) {
                this.setValue(objyObject, feature, i, this.getValue(objyObject, feature, i + 1));
                ++i;
            }
        }
        this.setValue(objyObject, feature, targetIndex, value);
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
    }

    protected VArray_Object getArray(ObjyObject objyObject, EStructuralFeature feature) {
        String attributeName = this.getAttributeName(feature);
        return objyObject.get_varray(attributeName);
    }

    public static class TMBoolean
    extends NumericManyTypeMapper {
        protected ooBaseType getObjyBaseType() {
            return ooBaseType.ooBOOLEAN;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Boolean value = null;
            if (!isNull) {
                value = numericValue.booleanValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(false);
            }
            return new Numeric_Value(((Boolean)value).booleanValue());
        }
    }

    public static class TMByte
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT8;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Byte value = null;
            if (!isNull) {
                value = numericValue.byteValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Byte)value).byteValue());
        }
    }

    public static class TMChar
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT8;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Character value = null;
            if (!isNull) {
                value = Character.valueOf(numericValue.charValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Character)value).charValue());
        }
    }

    public static class TMDate
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Date value = null;
            if (!isNull) {
                value = new Date(numericValue.longValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Date)value).getTime());
        }
    }

    public static class TMDouble
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooFLOAT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Double value = null;
            if (!isNull) {
                value = numericValue.doubleValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0.0);
            }
            return new Numeric_Value(((Double)value).doubleValue());
        }
    }

    public static class TMFloat
    extends NumericManyTypeMapper {
        protected ooBaseType getObjyBaseType() {
            return ooBaseType.ooFLOAT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Float value = null;
            if (!isNull) {
                value = Float.valueOf(numericValue.floatValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0.0);
            }
            return new Numeric_Value(((Float)value).floatValue());
        }
    }

    public static class TMInteger
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT32;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Integer value = null;
            if (!isNull) {
                value = numericValue.intValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Integer)value).intValue());
        }
    }

    public static class TMLong
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Long value = null;
            if (!isNull) {
                value = numericValue.longValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Long)value).longValue());
        }
    }

    public static class TMShort
    extends NumericManyTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT16;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Short value = null;
            if (!isNull) {
                value = numericValue.shortValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Short)value).shortValue());
        }
    }
}

