/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import java.util.HashMap;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BigDecimalTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BigIntegerTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ByteArrayTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.CustomDataManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.CustomDataTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.EnumTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.FeatureMapTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ManyReferenceMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.NumericManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.NumericTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.SingleReferenceMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.StringManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.StringTypeMapper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyMapper {
    public static ObjyMapper INSTANCE = new ObjyMapper();
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyMapper.class);
    protected HashMap<EClassifier, ITypeMapper> typeMap = new HashMap();
    protected HashMap<EClassifier, ITypeMapper> manyTypeMap = new HashMap();
    private ITypeMapper manyRef = ManyReferenceMapper.INSTANCE;
    private ITypeMapper singleRef = new SingleReferenceMapper();

    public ObjyMapper() {
        this.initMap();
        this.initManyMap();
    }

    public ITypeMapper getTypeMapper(EStructuralFeature feature) {
        if (feature == null || !EMFUtil.isPersistent((EStructuralFeature)feature)) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("feature is transient " + feature);
            }
            return null;
        }
        boolean isMany = false;
        if (feature.isMany()) {
            isMany = true;
        }
        if (feature instanceof EAttribute) {
            EClassifier type = feature.getEType();
            if (type.eIsProxy()) {
                URI a = EcoreUtil.getURI((EObject)type);
                type = EcorePackage.eINSTANCE.eResource().getEObject(a.fragment());
            }
            ITypeMapper attrMapper = null;
            attrMapper = isMany ? this.manyTypeMap.get(type) : this.typeMap.get(type);
            if (attrMapper != null) {
                return attrMapper;
            }
            if (type instanceof EEnum) {
                return EnumTypeMapper.INSTANCE;
            }
            if (type instanceof EDataType) {
                if (isMany) {
                    return CustomDataManyTypeMapper.INSTANCE;
                }
                return CustomDataTypeMapper.INSTANCE;
            }
        } else if (feature instanceof EReference) {
            if (isMany) {
                return this.manyRef;
            }
            return this.singleRef;
        }
        TRACER_DEBUG.trace("ERROR: " + feature.getEType() + " not supported for feature " + ((EClassifier)feature.eContainer()).getName() + "." + feature.getName());
        throw new RuntimeException(feature.getEType() + " not supported for feature " + ((EClassifier)feature.eContainer()).getName() + "." + feature.getName());
    }

    protected void initMap() {
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), NumericTypeMapper.TMBOOLEAN);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), NumericTypeMapper.TMBYTE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), NumericTypeMapper.TMCHAR);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDate(), NumericTypeMapper.TMDATE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), NumericTypeMapper.TMDOUBLE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), NumericTypeMapper.TMFLOAT);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), NumericTypeMapper.TMINTEGER);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getELong(), NumericTypeMapper.TMLONG);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), NumericTypeMapper.TMSHORT);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEString(), StringTypeMapper.INSTANCE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), NumericTypeMapper.TMBOOLEAN);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), NumericTypeMapper.TMBYTE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), NumericTypeMapper.TMCHAR);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), NumericTypeMapper.TMDOUBLE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), NumericTypeMapper.TMINTEGER);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), NumericTypeMapper.TMLONG);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), NumericTypeMapper.TMFLOAT);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteArray(), ByteArrayTypeMapper.INSTANCE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), BigDecimalTypeMapper.INSTANCE);
        this.typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), BigIntegerTypeMapper.INSTANCE);
    }

    private void initManyMap() {
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), NumericManyTypeMapper.TMBOOLEAN);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), NumericManyTypeMapper.TMBYTE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), NumericManyTypeMapper.TMCHAR);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDate(), NumericManyTypeMapper.TMDATE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), NumericManyTypeMapper.TMDOUBLE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), NumericManyTypeMapper.TMFLOAT);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), NumericManyTypeMapper.TMINTEGER);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getELong(), NumericManyTypeMapper.TMLONG);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), NumericManyTypeMapper.TMSHORT);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEString(), StringManyTypeMapper.INSTANCE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), NumericManyTypeMapper.TMBOOLEAN);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), NumericManyTypeMapper.TMBYTE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), NumericManyTypeMapper.TMCHAR);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), NumericManyTypeMapper.TMDOUBLE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), NumericManyTypeMapper.TMFLOAT);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), NumericManyTypeMapper.TMINTEGER);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), NumericManyTypeMapper.TMLONG);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteArray(), NumericManyTypeMapper.TMBYTE);
        this.manyTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFeatureMapEntry(), FeatureMapTypeMapper.INSTANCE);
    }
}

