/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.db.app.ooId;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.TypeConvert;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SingleReferenceMapper
extends BasicTypeMapper
implements ISingleTypeMapper {
    public static SingleReferenceMapper INSTANCE = new SingleReferenceMapper();

    public boolean createSchema(Proposed_Class proposedClasses, EStructuralFeature feature) {
        EClassifier destination = feature.getEType();
        String destinationClassName = ObjySchema.getObjectivityClassName(destination);
        proposedClasses.add_ref_attribute(-1, d_Access_Kind.d_PUBLIC, feature.getName(), 1L, destinationClassName, false);
        return false;
    }

    public Object getValue(ObjyObject objyObject, EStructuralFeature feature) {
        String attributeName = this.getAttributeName(feature);
        return this.getValue(objyObject, attributeName);
    }

    public Object getValue(ObjyObject objyObject, String attributeName) {
        Class_Object refClassObject;
        ooId childObject = objyObject.get_ooId(attributeName);
        if (!childObject.isNull() && (refClassObject = Class_Object.class_object_from_oid((ooId)childObject)).type_of().name().equals(ObjyProxy.className)) {
            ObjyProxy proxyObject = new ObjyProxy(refClassObject);
            return OBJYCDOIDUtil.createCDIDExternal(proxyObject);
        }
        return OBJYCDOIDUtil.getCDOID(childObject);
    }

    public void setValue(ObjyObject objyObject, EStructuralFeature feature, Object newValue) {
        String attributeName = this.getAttributeName(feature);
        this.setValue(objyObject, attributeName, newValue);
    }

    public void setValue(ObjyObject objyObject, String attributeName, Object newValue) {
        ooId ooid = null;
        if (newValue instanceof CDOIDExternal) {
            System.out.println("... CDOIDExternal inserted, content:" + ((CDOIDExternal)newValue).getURI());
            ObjyProxy proxyObject = ObjyProxy.createObject(objyObject.ooId());
            proxyObject.setUri(((CDOIDExternal)newValue).getURI());
            ooid = proxyObject.ooId();
        } else {
            ooid = TypeConvert.toOoId(newValue);
        }
        objyObject.set_ooId(attributeName, ooid);
    }

    public boolean validate(d_Attribute ooAttribute, EStructuralFeature feature) {
        System.out.println(">>>OBJYIMPL: SingleRefernceMapper.validate() - not implemented.");
        return true;
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        String attributeName = this.getAttributeName(feature);
        ooId childOid = objyObject.get_ooId(attributeName);
        if (!childOid.isNull()) {
            this.setValue(objyObject, feature, null);
        }
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }
}

