/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.utils;

import com.objy.db.FetchCompletedWithErrors;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.Session;
import com.objy.db.app.ooContObj;
import com.objy.db.app.ooObj;
import com.objy.db.iapp.ActivateInfo;
import com.objy.db.iapp.FetchErrorInfo;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class SmartLock {
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, SmartLock.class);
    private static final ContextTracer TRACER_ERROR = new ContextTracer(OM.ERROR, SmartLock.class);

    public static boolean lock(ObjyObject objyObject) {
        ooObj objectToLock = (ooObj)Session.getCurrent().getFD().objectFrom(objyObject.ooId());
        if (!objectToLock.isPersistent()) {
            return false;
        }
        ooContObj container = null;
        container = objectToLock instanceof ooContObj ? (ooContObj)objectToLock : objectToLock.getContainer();
        return SmartLock.lock(container);
    }

    public static boolean readLock(ooContObj container) {
        container.fetch();
        if (container.isUpdated()) {
            container.refresh(10);
            return true;
        }
        try {
            container.lock(10);
        }
        catch (Exception e) {
            container.refresh(10);
        }
        return false;
    }

    public static boolean lock(ooContObj container) {
        container.fetch();
        if (container.isUpdated()) {
            container.refresh(11);
            return true;
        }
        try {
            container.lock(11);
        }
        catch (Exception e) {
            container.refresh(11);
        }
        return false;
    }

    public static boolean unlock(ooObj objectToLock) {
        Session.getCurrent().checkpoint(1);
        return false;
    }

    public static void safeActivate(ooObj object, ActivateInfo fcweEx) {
        Vector errors;
        if (!fcweEx.hasFetchErrors()) {
            return;
        }
        if (TRACER_INFO.isEnabled()) {
            TRACER_INFO.trace("   >> Object: " + object.getOid().getStoreString() + " Fetch with errors");
        }
        if ((errors = fcweEx.getFetchErrors()) != null) {
            Enumeration errs = errors.elements();
            FetchErrorInfo feInfo = null;
            HashSet<ooContObj> hashSet = new HashSet<ooContObj>();
            hashSet.add(object.getContainer());
            while (errs.hasMoreElements()) {
                feInfo = (FetchErrorInfo)errs.nextElement();
                TRACER_INFO.trace("  >> ... fieldName: " + feInfo.getFieldName());
                TRACER_INFO.trace("  >> ... Msg: " + feInfo.getErrorMessage());
                String needFetchingOID = feInfo.getOid().getStoreString();
                TRACER_INFO.trace("  >> ... OID: " + needFetchingOID);
                try {
                    TRACER_INFO.trace("  >> Trying to refetch the object....");
                    String contID = "#" + feInfo.getOid().getDB() + "-" + feInfo.getOid().getOC() + "-" + "1-1";
                    TRACER_INFO.trace("contID: " + contID);
                    ooContObj tempCont = (ooContObj)Session.getCurrent().getFD().objectFrom(contID);
                    if (hashSet.contains(tempCont)) continue;
                    hashSet.add(tempCont);
                }
                catch (ObjyRuntimeException ex) {
                    TRACER_ERROR.trace("FATAL", (Throwable)ex);
                }
            }
            Iterator itrCont = hashSet.iterator();
            int numCont = 0;
            while (itrCont.hasNext()) {
                ooContObj cont = (ooContObj)itrCont.next();
                if (!cont.isUpdated()) continue;
                TRACER_INFO.trace("RECOVER : REFRESH CONT " + cont.getOid().getStoreString());
                cont.refresh(10);
                ++numCont;
            }
            if (numCont != 0) {
                object.markFetchRequired();
                object.fetch();
            } else {
                throw new FetchCompletedWithErrors("Fetch completed but errors occurred", (Object)object, fcweEx.getFetchErrors());
            }
        }
    }
}

