/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.ocl.CDOExtentCreator;
import org.eclipse.emf.cdo.server.ocl.CDOExtentMap;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetDataRevisionProvider;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.ProblemAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryHandler
implements IQueryHandler {
    private static final EcoreFactory FACTORY = EcoreFactory.eINSTANCE;
    public static final String LANGUAGE_NAME = "ocl";

    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        block15: {
            String queryString = info.getQueryString();
            CDOExtentMap extentMap = null;
            try {
                try {
                    ProblemAware problemAware;
                    Diagnostic problems;
                    EClassifier classifier;
                    IView revisionProvider = context.getView();
                    CDOChangeSetData changeSetData = info.getChangeSetData();
                    if (changeSetData != null) {
                        revisionProvider = new CDOChangeSetDataRevisionProvider((CDORevisionProvider)revisionProvider, changeSetData);
                    }
                    ISession session = context.getView().getSession();
                    CDOView view = CDOServerUtil.openView((ISession)session, (CDOBranchPoint)context, (boolean)info.isLegacyModeEnabled(), (CDORevisionProvider)revisionProvider);
                    CDOPackageRegistry packageRegistry = view.getSession().getPackageRegistry();
                    EcoreEnvironmentFactory envFactory = new EcoreEnvironmentFactory((EPackage.Registry)packageRegistry);
                    OCL ocl = OCL.newInstance((EnvironmentFactory)envFactory);
                    extentMap = this.createExtentMap(view, changeSetData, context);
                    ocl.setExtentMap((Map)extentMap);
                    OCLHelper helper = ocl.createOCLHelper();
                    InternalEObject object = null;
                    Object contextParameter = info.getContext();
                    if (contextParameter instanceof CDOID) {
                        CDOID id = (CDOID)contextParameter;
                        if (id.isNull()) {
                            classifier = this.getArbitraryContextClassifier(packageRegistry);
                        } else {
                            InternalCDOObject cdoObject = (InternalCDOObject)view.getObject(id);
                            object = cdoObject.cdoInternalInstance();
                            classifier = object.eClass();
                        }
                    } else {
                        classifier = contextParameter instanceof EClassifier ? (EClassifier)contextParameter : this.getArbitraryContextClassifier(packageRegistry);
                    }
                    helper.setContext((Object)classifier);
                    HashMap<String, Object> parameters = new HashMap<String, Object>(info.getParameters());
                    this.initEnvironment(ocl.getEnvironment(), packageRegistry, parameters);
                    OCLExpression expr = helper.createQuery(queryString);
                    Query query = ocl.createQuery(expr);
                    Set entrySet = parameters.entrySet();
                    for (Map.Entry parameter : entrySet) {
                        query.getEvaluationEnvironment().add((String)parameter.getKey(), parameter.getValue());
                    }
                    Object evaluated = this.evaluate((Query<EClassifier, EClass, EObject>)query, (EObject)object);
                    if (evaluated instanceof Collection) {
                        Collection results = (Collection)evaluated;
                        for (Object result : results) {
                            CDORevision revision;
                            if (!(result instanceof EObject) || context.addResult((Object)(revision = this.getRevision((EObject)result, view)))) continue;
                            break block15;
                        }
                        break block15;
                    }
                    if (query instanceof ProblemAware && (problems = (problemAware = (ProblemAware)query).getProblems()) != null) {
                        throw new DiagnosticException(problems);
                    }
                    throw new IllegalStateException("Invalid result: " + evaluated.toString());
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex, (String)("Problem executing OCL query: " + queryString));
                }
            }
            finally {
                if (extentMap != null) {
                    extentMap.cancel();
                }
            }
        }
    }

    protected CDORevision getRevision(EObject object, CDOView view) {
        return FSMUtil.adapt((Object)object, (CDOView)view).cdoRevision();
    }

    protected Object evaluate(Query<EClassifier, EClass, EObject> query, EObject object) {
        if (object == null) {
            return query.evaluate();
        }
        return query.evaluate((Object)object);
    }

    protected CDOExtentMap createExtentMap(CDOView view, CDOChangeSetData changeSetData, IQueryContext context) {
        CDOExtentCreator creator = this.createsLazyExtents() ? new CDOExtentCreator.Lazy(view) : new CDOExtentCreator(view);
        creator.setChangeSetData(changeSetData);
        creator.setRevisionCacheAdder((CDORevisionCacheAdder)context.getView().getRepository().getRevisionManager());
        return new CDOExtentMap(creator);
    }

    protected boolean createsLazyExtents() {
        return false;
    }

    protected EClassifier getArbitraryContextClassifier(CDOPackageRegistry packageRegistry) {
        CDOPackageUnit[] cDOPackageUnitArray = packageRegistry.getPackageUnits();
        int n = cDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageUnit packageUnit = cDOPackageUnitArray[n2];
            CDOPackageInfo[] cDOPackageInfoArray = packageUnit.getPackageInfos();
            int n3 = cDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Iterator iterator;
                CDOPackageInfo packageInfo = cDOPackageInfoArray[n4];
                if (!packageUnit.isSystem() && (iterator = packageInfo.getEPackage().getEClassifiers().iterator()).hasNext()) {
                    EClassifier classifier = (EClassifier)iterator.next();
                    return classifier;
                }
                ++n4;
            }
            ++n2;
        }
        throw new IllegalStateException("Context missing");
    }

    protected void initEnvironment(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> environment, CDOPackageRegistry packageRegistry, Map<String, Object> parameters) {
        OCLStandardLibrary stdLib = environment.getOCLStandardLibrary();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            OCLExpression<EClassifier> initExpression = this.createInitExpression((OCLStandardLibrary<EClassifier>)stdLib, packageRegistry, value);
            Variable variable = FACTORY.createVariable();
            variable.setName(name);
            variable.setType((Object)((EClassifier)initExpression.getType()));
            variable.setInitExpression(initExpression);
            this.addEnvironmentVariable(environment, (org.eclipse.ocl.expressions.Variable<EClassifier, ?>)variable);
        }
    }

    protected OCLExpression<EClassifier> createInitExpression(OCLStandardLibrary<EClassifier> stdLib, CDOPackageRegistry packageRegistry, Object value) {
        if (value instanceof String) {
            String v = (String)value;
            StringLiteralExp literal = FACTORY.createStringLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getString()));
            literal.setStringSymbol(v);
            return literal;
        }
        if (value instanceof Boolean) {
            Boolean v = (Boolean)value;
            BooleanLiteralExp literal = FACTORY.createBooleanLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getBoolean()));
            literal.setBooleanSymbol(v);
            return literal;
        }
        Integer integerValue = this.getInteger(value);
        if (integerValue != null) {
            IntegerLiteralExp literal = FACTORY.createIntegerLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getInteger()));
            literal.setIntegerSymbol(integerValue);
            return literal;
        }
        Double doubleValue = this.getDouble(value);
        if (doubleValue != null) {
            RealLiteralExp literal = FACTORY.createRealLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getReal()));
            literal.setRealSymbol(doubleValue);
            return literal;
        }
        if (value instanceof Enumerator) {
            Enumerator v = (Enumerator)value;
            String name = v.getName();
            EEnumLiteral eEnumLiteral = packageRegistry.getEnumLiteralFor(v);
            if (eEnumLiteral == null) {
                throw new IllegalArgumentException("Enum literal not found: " + name);
            }
            EnumLiteralExp literal = FACTORY.createEnumLiteralExp();
            literal.setType((Object)eEnumLiteral.getEEnum());
            literal.setReferredEnumLiteral((Object)eEnumLiteral);
            return literal;
        }
        throw new IllegalArgumentException("Unrecognized parameter type: " + value.getClass().getName());
    }

    private Integer getInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return (int)((Short)value);
        }
        if (value instanceof Byte) {
            return (int)((Byte)value);
        }
        return null;
    }

    private Double getDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return null;
    }

    protected void addEnvironmentVariable(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> environment, org.eclipse.ocl.expressions.Variable<EClassifier, ?> variable) {
        environment.addElement(variable.getName(), variable, true);
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new Factory());
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super(OCLQueryHandler.LANGUAGE_NAME);
        }

        public OCLQueryHandler create(String description) throws ProductCreationException {
            return new OCLQueryHandler();
        }
    }
}

