/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockManager
extends RWLockManager<Object, IView>
implements InternalLockManager {
    private InternalRepository repository;
    private Map<String, InternalView> openViews = new HashMap<String, InternalView>();
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionListener = new ContainerEventAdapter<IView>(){

        protected void onRemoved(IContainer<IView> container, IView view) {
            String durableLockingID = view.getDurableLockingID();
            if (durableLockingID == null) {
                LockManager.this.unlock(view);
            } else {
                LockManager.this.changeContext(view, new DurableView(durableLockingID));
                LockManager.this.unregisterOpenView(durableLockingID);
            }
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            session.addListener(LockManager.this.sessionListener);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            session.removeListener(LockManager.this.sessionListener);
        }
    };

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
    }

    @Override
    public Object getLockEntryObject(Object key) {
        RWLockManager.LockEntry lockEntry = this.getLockEntry(key);
        return lockEntry.getObject();
    }

    @Override
    public Object getLockKey(CDOID id, CDOBranch branch) {
        if (this.repository.isSupportingBranches()) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch);
        }
        return id;
    }

    @Override
    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks(final IView view) {
        final HashMap<CDOID, IDurableLockingManager.LockGrade> result = new HashMap<CDOID, IDurableLockingManager.LockGrade>();
        RWLockManager.LockEntryHandler<Object, IView> handler = new RWLockManager.LockEntryHandler<Object, IView>(){

            public boolean handleLockEntry(RWLockManager.LockEntry<Object, IView> lockEntry) {
                CDOID id = LockManager.this.getLockKeyID(lockEntry.getObject());
                IDurableLockingManager.LockGrade grade = IDurableLockingManager.LockGrade.NONE;
                if (lockEntry.isReadLock((Object)view)) {
                    grade = grade.getUpdated(IRWLockManager.LockType.READ, true);
                }
                if (lockEntry.isWriteLock((Object)view)) {
                    grade = grade.getUpdated(IRWLockManager.LockType.WRITE, true);
                }
                if (grade != IDurableLockingManager.LockGrade.NONE) {
                    result.put(id, grade);
                }
                return true;
            }
        };
        this.handleLockEntries(view, (RWLockManager.LockEntryHandler)handler);
        return result;
    }

    @Override
    public void lock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, long timeout) throws InterruptedException {
        String durableLockingID = null;
        IStoreAccessor.DurableLocking accessor = null;
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            accessor = this.getDurableLocking();
        }
        super.lock(type, (Object)view, objectsToLock, timeout);
        if (accessor != null) {
            accessor.lock(durableLockingID, type, objectsToLock);
        }
    }

    @Override
    public void unlock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToUnlock) {
        String durableLockingID;
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.unlock(durableLockingID, type, objectsToUnlock);
        }
        super.unlock(type, (Object)view, objectsToUnlock);
    }

    @Override
    public void unlock(boolean explicit, IView view) {
        String durableLockingID;
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.unlock(durableLockingID);
        }
        super.unlock((Object)view);
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        return accessor.createLockArea(userID, branchPoint, readOnly, locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDurableLockingManager.LockArea createLockArea(InternalView view) {
        String userID = view.getSession().getUserID();
        CDOBranchPoint branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        boolean readOnly = view.isReadOnly();
        Map<CDOID, IDurableLockingManager.LockGrade> locks = this.getLocks(view);
        IDurableLockingManager.LockArea area = this.createLockArea(userID, branchPoint, readOnly, locks);
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            this.openViews.put(area.getDurableLockingID(), view);
        }
        return area;
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        return accessor.getLockArea(durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        if (userIDPrefix == null) {
            userIDPrefix = "";
        }
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.getLockAreas(userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.deleteLockArea(durableLockingID);
        this.unregisterOpenView(durableLockingID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IView openView(ISession session, int viewID, boolean readOnly, final String durableLockingID) {
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            InternalView view = this.openViews.get(durableLockingID);
            if (view != null) {
                throw new IllegalStateException("Durable view is already open: " + view);
            }
            IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
            if (area.isReadOnly() != readOnly) {
                throw new IllegalStateException("Durable read-only state does not match the request");
            }
            view = readOnly ? (InternalView)session.openView(viewID, (CDOBranchPoint)area) : (InternalView)((Object)session.openTransaction(viewID, (CDOBranchPoint)area));
            this.changeContext(new DurableView(durableLockingID), view);
            view.setDurableLockingID(durableLockingID);
            view.addListener((IListener)new LifecycleEventAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onDeactivated(ILifecycle lifecycle) {
                    Map map = LockManager.this.openViews;
                    synchronized (map) {
                        LockManager.this.openViews.remove(durableLockingID);
                    }
                }
            });
            this.openViews.put(durableLockingID, view);
            return view;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.loadDurableLocks();
        this.getRepository().getSessionManager().addListener(this.sessionManagerListener);
    }

    protected void doDeactivate() throws Exception {
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.removeListener(this.sessionManagerListener);
        ISession[] iSessionArray = sessionManager.getSessions();
        int n = iSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISession session = iSessionArray[n2];
            session.removeListener(this.sessionListener);
            ++n2;
        }
        super.doDeactivate();
    }

    private IStoreAccessor.DurableLocking getDurableLocking() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor instanceof IStoreAccessor.DurableLocking) {
            return (IStoreAccessor.DurableLocking)((Object)accessor);
        }
        throw new IllegalStateException("Store does not support durable locking");
    }

    private void loadDurableLocks() {
        InternalStore store = this.repository.getStore();
        IStoreAccessor reader = null;
        try {
            reader = store.getReader(null);
            if (reader instanceof IStoreAccessor.DurableLocking) {
                StoreThreadLocal.setAccessor(reader);
                DurableLockLoader handler = new DurableLockLoader();
                this.getLockAreas(null, handler);
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOpenView(String durableLockingID) {
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            InternalView view = this.openViews.remove(durableLockingID);
            if (view != null) {
                view.setDurableLockingID(null);
            }
        }
    }

    @Override
    public CDOID getLockKeyID(Object key) {
        if (key instanceof CDOID) {
            return (CDOID)key;
        }
        if (key instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)key).getID();
        }
        throw new ImplementationError("Unexpected lock object: " + key);
    }

    private final class DurableLockLoader
    implements IDurableLockingManager.LockArea.Handler {
        private DurableLockLoader() {
        }

        public boolean handleLockArea(IDurableLockingManager.LockArea area) {
            DurableView view = new DurableView(area.getDurableLockingID());
            ArrayList<Object> readLocks = new ArrayList<Object>();
            ArrayList<Object> writeLocks = new ArrayList<Object>();
            for (Map.Entry entry : area.getLocks().entrySet()) {
                Object key = LockManager.this.getLockKey((CDOID)entry.getKey(), area.getBranch());
                IDurableLockingManager.LockGrade grade = (IDurableLockingManager.LockGrade)entry.getValue();
                if (grade.isRead()) {
                    readLocks.add(key);
                }
                if (!grade.isWrite()) continue;
                writeLocks.add(key);
            }
            try {
                LockManager.this.lock(IRWLockManager.LockType.READ, view, readLocks, 1000L);
                LockManager.this.lock(IRWLockManager.LockType.WRITE, view, writeLocks, 1000L);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            return true;
        }
    }

    private final class DurableView
    implements IView {
        private String durableLockingID;

        public DurableView(String durableLockingID) {
            this.durableLockingID = durableLockingID;
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }

        public int getViewID() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException();
        }

        public CDOBranch getBranch() {
            throw new UnsupportedOperationException();
        }

        public long getTimeStamp() {
            throw new UnsupportedOperationException();
        }

        public CDORevision getRevision(CDOID id) {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public boolean isClosed() {
            throw new UnsupportedOperationException();
        }

        public IRepository getRepository() {
            throw new UnsupportedOperationException();
        }

        public ISession getSession() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.durableLockingID.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DurableView) {
                DurableView that = (DurableView)obj;
                return this.durableLockingID.equals(that.getDurableLockingID());
            }
            return false;
        }

        public String toString() {
            return MessageFormat.format("DurableView[{0}]", this.durableLockingID);
        }
    }
}

