/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
extends Container<ISession>
implements InternalSessionManager {
    public static final int DEFAULT_TOKEN_LENGTH = 1024;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private InternalRepository repository;
    @ReflectUtil.ExcludeFromDump
    private String encryptionAlgorithmName = "PBEWithMD5AndDES";
    @ReflectUtil.ExcludeFromDump
    private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
    @ReflectUtil.ExcludeFromDump
    private int encryptionIterationCount = 20;
    private int tokenLength = 1024;
    private IRandomizer randomizer;
    private IUserManager userManager;
    private final Map<Integer, InternalSession> sessions = new HashMap<Integer, InternalSession>();
    private final AtomicInteger lastSessionID = new AtomicInteger();

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
        this.checkInactive();
        this.encryptionAlgorithmName = encryptionAlgorithmName;
    }

    public byte[] getEncryptionSaltBytes() {
        return this.encryptionSaltBytes;
    }

    public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
        this.checkInactive();
        this.encryptionSaltBytes = encryptionSaltBytes;
    }

    public int getEncryptionIterationCount() {
        return this.encryptionIterationCount;
    }

    public void setEncryptionIterationCount(int encryptionIterationCount) {
        this.checkInactive();
        this.encryptionIterationCount = encryptionIterationCount;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.checkInactive();
        this.tokenLength = tokenLength;
    }

    public IRandomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(IRandomizer randomizer) {
        this.checkInactive();
        this.randomizer = randomizer;
    }

    public IUserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession[] getSessions() {
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.values().toArray(new InternalSession[this.sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession getSession(int sessionID) {
        this.checkActive();
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.get(sessionID);
        }
    }

    public InternalSession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession openSession(ISessionProtocol sessionProtocol) {
        int id = this.lastSessionID.incrementAndGet();
        if (TRACER.isEnabled()) {
            TRACER.trace("Opening session " + id);
        }
        String userID = this.authenticateUser(sessionProtocol);
        InternalSession session = this.createSession(id, userID, sessionProtocol);
        LifecycleUtil.activate((Object)session);
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            this.sessions.put(id, session);
        }
        this.fireElementAddedEvent(session);
        this.sendRemoteSessionNotification(session, (byte)1);
        return session;
    }

    protected InternalSession createSession(int id, String userID, ISessionProtocol protocol) {
        return new Session(this, protocol, id, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(InternalSession session) {
        int sessionID = session.getSessionID();
        InternalSession removeSession = null;
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            removeSession = this.sessions.remove(sessionID);
        }
        if (removeSession != null) {
            this.fireElementRemovedEvent(session);
            this.sendRemoteSessionNotification(session, (byte)2);
        }
    }

    @Override
    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryTypeNotification(oldType, newType);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryStateNotification(oldState, newState);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    public void sendBranchNotification(InternalSession sender, InternalCDOBranch branch) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendBranchNotification(branch);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendCommitNotification(commitInfo);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) {
        try {
            InternalSession[] internalSessionArray = this.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                if (session != sender && session.isSubscribed()) {
                    try {
                        session.sendRemoteSessionNotification(sender, opcode);
                    }
                    catch (Exception ex) {
                        this.handleNotificationProblem(session, ex);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            OM.LOG.warn("A problem occured while notifying other sessions", (Throwable)ex);
        }
    }

    @Override
    public List<Integer> sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message, int[] recipients) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < recipients.length) {
            InternalSession recipient = this.getSession(recipients[i]);
            try {
                if (recipient != null && recipient.isSubscribed()) {
                    recipient.sendRemoteMessageNotification(sender, message);
                    result.add(recipient.getSessionID());
                }
            }
            catch (Exception ex) {
                this.handleNotificationProblem(recipient, ex);
            }
            ++i;
        }
        return result;
    }

    protected void handleNotificationProblem(InternalSession session, Throwable t) {
        OM.LOG.warn("A problem occured while notifying session " + session, t);
    }

    protected String authenticateUser(ISessionProtocol protocol) throws SecurityException {
        if (protocol == null) {
            return null;
        }
        if (this.userManager == null) {
            return null;
        }
        try {
            byte[] randomToken = this.createRandomToken();
            CDOAuthenticationResult result = protocol.sendAuthenticationChallenge(randomToken);
            String userID = result.getUserID();
            byte[] cryptedToken = this.encryptToken(userID, randomToken);
            boolean success = Arrays.equals(result.getCryptedToken(), cryptedToken);
            if (success) {
                return userID;
            }
            throw new SecurityException("User not authenticated");
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    protected byte[] createRandomToken() {
        byte[] token = new byte[this.tokenLength];
        this.randomizer.nextBytes(token);
        return token;
    }

    protected byte[] encryptToken(String userID, byte[] token) throws NegotiationException {
        try {
            return this.userManager.encrypt(userID, token, this.getEncryptionAlgorithmName(), this.getEncryptionSaltBytes(), this.getEncryptionIterationCount());
        }
        catch (Exception ex) {
            OM.LOG.error("Token encryption failed", (Throwable)ex);
            return null;
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.userManager == null) {
            OM.LOG.info("No user manager configured. Users will not be authenticated");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.userManager != null) {
            if (this.randomizer == null) {
                this.randomizer = new Randomizer();
            }
            LifecycleUtil.activate((Object)this.randomizer);
        }
    }

    protected void doDeactivate() throws Exception {
        InternalSession[] activeSessions = this.getSessions();
        int i = 0;
        while (i < activeSessions.length) {
            LifecycleUtil.deactivate((Object)activeSessions[i]);
            ++i;
        }
        super.doDeactivate();
    }
}

