/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.FailureCommitInfo;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ContainmentCycleDetectedException;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.StubCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCommitContext
implements InternalCommitContext {
    private static final InternalCDORevision DETACHED = new StubCDORevision(null);
    private final InternalTransaction transaction;
    private InternalRepository repository;
    private InternalCDORevisionManager revisionManager;
    private InternalLockManager lockManager;
    private InternalCDOPackageRegistry repositoryPackageRegistry;
    private boolean packageRegistryLocked;
    private TransactionPackageRegistry packageRegistry;
    private IStoreAccessor accessor;
    private long timeStamp = 0L;
    private long previousTimeStamp = 0L;
    private String commitComment;
    private InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[0];
    private InternalCDORevision[] newObjects = new InternalCDORevision[0];
    private InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[0];
    private CDOID[] detachedObjects = new CDOID[0];
    private Map<CDOID, EClass> detachedObjectTypes;
    private InternalCDORevision[] dirtyObjects = new InternalCDORevision[0];
    private InternalCDORevision[] cachedDetachedRevisions = new InternalCDORevision[0];
    private Map<CDOID, InternalCDORevision> cachedRevisions;
    private Set<Object> lockedObjects = new HashSet<Object>();
    private List<CDOID> lockedTargets;
    private ConcurrentMap<CDOID, CDOID> idMappings = new ConcurrentHashMap<CDOID, CDOID>();
    private CDOReferenceAdjuster idMapper = new CDOIDMapper(this.idMappings);
    private String rollbackMessage;
    private List<CDOIDReference> xRefs;
    private boolean ensuringReferentialIntegrity;
    private boolean autoReleaseLocksEnabled;
    private ExtendedDataInputStream lobs;

    public TransactionCommitContext(InternalTransaction transaction) {
        this.transaction = transaction;
        this.repository = transaction.getRepository();
        this.revisionManager = this.repository.getRevisionManager();
        this.lockManager = this.repository.getLockManager();
        this.ensuringReferentialIntegrity = this.repository.isEnsuringReferentialIntegrity();
        this.repositoryPackageRegistry = this.repository.getPackageRegistry(false);
        this.packageRegistry = new TransactionPackageRegistry(this.repositoryPackageRegistry);
        this.packageRegistry.activate();
    }

    @Override
    public InternalTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public CDOBranchPoint getBranchPoint() {
        return this.transaction.getBranch().getPoint(this.timeStamp);
    }

    @Override
    public String getUserID() {
        return this.transaction.getSession().getUserID();
    }

    @Override
    public String getCommitComment() {
        return this.commitComment;
    }

    @Override
    public boolean isAutoReleaseLocksEnabled() {
        return this.autoReleaseLocksEnabled;
    }

    @Override
    public String getRollbackMessage() {
        return this.rollbackMessage;
    }

    @Override
    public List<CDOIDReference> getXRefs() {
        return this.xRefs;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public InternalCDOPackageUnit[] getNewPackageUnits() {
        return this.newPackageUnits;
    }

    @Override
    public InternalCDORevision[] getNewObjects() {
        return this.newObjects;
    }

    @Override
    public InternalCDORevision[] getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public CDOID[] getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, EClass> getDetachedObjectTypes() {
        return this.detachedObjectTypes;
    }

    @Override
    public InternalCDORevision[] getDetachedRevisions() {
        InternalCDORevision[] internalCDORevisionArray = this.cachedDetachedRevisions;
        int n = this.cachedDetachedRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision cachedDetachedRevision = internalCDORevisionArray[n2];
            if (cachedDetachedRevision == null) {
                throw new AssertionError((Object)"Detached revisions are incomplete");
            }
            ++n2;
        }
        return this.cachedDetachedRevisions;
    }

    @Override
    public InternalCDORevisionDelta[] getDirtyObjectDeltas() {
        return this.dirtyObjectDeltas;
    }

    public CDORevision getRevision(CDOID id) {
        InternalCDORevision revision;
        if (this.cachedRevisions == null) {
            this.cachedRevisions = this.cacheRevisions();
        }
        if ((revision = this.cachedRevisions.get(id)) == DETACHED) {
            return null;
        }
        if (revision != null) {
            return revision;
        }
        return this.transaction.getRevision(id);
    }

    private Map<CDOID, InternalCDORevision> cacheRevisions() {
        InternalCDORevision revision;
        int i;
        HashMap<CDOID, InternalCDORevision> cache = new HashMap<CDOID, InternalCDORevision>();
        if (this.newObjects != null) {
            i = 0;
            while (i < this.newObjects.length) {
                revision = this.newObjects[i];
                cache.put(revision.getID(), revision);
                ++i;
            }
        }
        if (this.dirtyObjects != null) {
            i = 0;
            while (i < this.dirtyObjects.length) {
                revision = this.dirtyObjects[i];
                cache.put(revision.getID(), revision);
                ++i;
            }
        }
        if (this.detachedObjects != null) {
            i = 0;
            while (i < this.detachedObjects.length) {
                cache.put(this.detachedObjects[i], DETACHED);
                ++i;
            }
        }
        return cache;
    }

    @Override
    public Map<CDOID, CDOID> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }

    @Override
    public void addIDMapping(CDOID oldID, CDOID newID) {
        if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
            throw new IllegalStateException("newID=" + newID);
        }
        CDOID previousMapping = this.idMappings.putIfAbsent(oldID, newID);
        if (previousMapping != null) {
            throw new IllegalStateException("previousMapping != null");
        }
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        boolean mapIDs = !this.idMappings.isEmpty();
        monitor.begin((double)(1 + (mapIDs ? this.newObjects.length + this.dirtyObjects.length + this.dirtyObjectDeltas.length : 0)));
        try {
            if (mapIDs) {
                this.applyIDMappings(this.newObjects, monitor.fork((double)this.newObjects.length));
                this.applyIDMappings(this.dirtyObjects, monitor.fork((double)this.dirtyObjects.length));
                InternalCDORevisionDelta[] internalCDORevisionDeltaArray = this.dirtyObjectDeltas;
                int n = this.dirtyObjectDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDORevisionDelta dirtyObjectDelta = internalCDORevisionDeltaArray[n2];
                    dirtyObjectDelta.adjustReferences(this.idMapper);
                    monitor.worked();
                    ++n2;
                }
            }
            this.notifyBeforeCommitting(monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void notifyBeforeCommitting(OMMonitor monitor) {
        this.repository.notifyWriteAccessHandlers(this.transaction, this, true, monitor.fork());
    }

    @Override
    public void preWrite() {
        this.accessor = this.repository.getStore().getWriter(this.transaction);
        StoreThreadLocal.setAccessor(this.accessor);
        StoreThreadLocal.setCommitContext(this);
    }

    @Override
    public void setNewPackageUnits(InternalCDOPackageUnit[] newPackageUnits) {
        this.newPackageUnits = newPackageUnits;
    }

    @Override
    public void setNewObjects(InternalCDORevision[] newObjects) {
        this.newObjects = newObjects;
    }

    @Override
    public void setDirtyObjectDeltas(InternalCDORevisionDelta[] dirtyObjectDeltas) {
        this.dirtyObjectDeltas = dirtyObjectDeltas;
    }

    @Override
    public void setDetachedObjects(CDOID[] detachedObjects) {
        this.detachedObjects = detachedObjects;
    }

    @Override
    public void setDetachedObjectTypes(Map<CDOID, EClass> detachedObjectTypes) {
        this.detachedObjectTypes = detachedObjectTypes;
    }

    @Override
    public void setAutoReleaseLocksEnabled(boolean on) {
        this.autoReleaseLocksEnabled = on;
    }

    @Override
    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    @Override
    public ExtendedDataInputStream getLobs() {
        return this.lobs;
    }

    @Override
    public void setLobs(ExtendedDataInputStream in) {
        this.lobs = in;
    }

    @Override
    public void write(OMMonitor monitor) {
        try {
            try {
                monitor.begin(107.0);
                this.dirtyObjects = new InternalCDORevision[this.dirtyObjectDeltas.length];
                if (this.newPackageUnits.length != 0 && this.repository instanceof Repository) {
                    ((Repository)this.repository).getPackageRegistryCommitLock().acquire();
                    this.packageRegistryLocked = true;
                    ArrayList<InternalCDOPackageUnit> noDuplicates = new ArrayList<InternalCDOPackageUnit>();
                    InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
                    int n = this.newPackageUnits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
                        String id = newPackageUnit.getID();
                        if (!this.repositoryPackageRegistry.containsKey((Object)id)) {
                            noDuplicates.add(newPackageUnit);
                        }
                        ++n2;
                    }
                    int newSize = noDuplicates.size();
                    if (this.newPackageUnits.length != newSize) {
                        this.newPackageUnits = noDuplicates.toArray(new InternalCDOPackageUnit[newSize]);
                    }
                }
                this.lockObjects();
                monitor.worked();
                this.setTimeStamp(monitor.fork());
                this.adjustForCommit();
                monitor.worked();
                this.computeDirtyObjects(monitor.fork());
                this.checkXRefs();
                monitor.worked();
                if (this.rollbackMessage == null) {
                    this.detachObjects(monitor.fork());
                    this.accessor.write(this, monitor.fork(100.0));
                }
            }
            catch (Throwable t) {
                this.handleException(t);
                this.finishMonitor(monitor);
            }
        }
        finally {
            this.finishMonitor(monitor);
        }
    }

    @Override
    public void commit(OMMonitor monitor) {
        try {
            try {
                monitor.begin(101.0);
                this.accessor.commit(monitor.fork(100.0));
                this.updateInfraStructure(monitor.fork());
                this.repository.endCommit(this.timeStamp);
            }
            catch (Throwable ex) {
                this.handleException(ex);
                this.finishMonitor(monitor);
            }
        }
        finally {
            this.finishMonitor(monitor);
        }
    }

    private void handleException(Throwable ex) {
        try {
            OM.LOG.error(ex);
            String storeClass = this.repository.getStore().getClass().getSimpleName();
            this.rollback("Rollback in " + storeClass + ": " + StringUtil.formatException((Throwable)ex));
        }
        catch (Exception ex1) {
            if (this.rollbackMessage == null) {
                this.rollbackMessage = ex1.getMessage();
            }
            try {
                OM.LOG.error((Throwable)ex1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void finishMonitor(OMMonitor monitor) {
        try {
            monitor.done();
        }
        catch (Exception ex) {
            try {
                OM.LOG.warn((Throwable)ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setTimeStamp(OMMonitor mmonitor) {
        long[] times = this.createTimeStamp(mmonitor);
        this.timeStamp = times[0];
        this.previousTimeStamp = times[1];
        CheckUtil.checkState((this.timeStamp != 0L ? 1 : 0) != 0, (String)"Commit timestamp must not be 0");
    }

    protected long[] createTimeStamp(OMMonitor monitor) {
        return this.repository.createCommitTimeStamp(monitor);
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    protected void setTimeStamp(long timeStamp) {
        this.repository.forceCommitTimeStamp(timeStamp, (OMMonitor)new Monitor());
        this.timeStamp = timeStamp;
    }

    @Override
    public long getPreviousTimeStamp() {
        return this.previousTimeStamp;
    }

    @Override
    public void postCommit(boolean success) {
        if (this.packageRegistryLocked) {
            ((Repository)this.repository).getPackageRegistryCommitLock().release();
        }
        try {
            try {
                ISession sender = this.transaction.getSession();
                CDOCommitInfo commitInfo = success ? this.createCommitInfo() : this.createFailureCommitInfo();
                this.repository.sendCommitNotification((InternalSession)sender, commitInfo);
            }
            catch (Exception ex) {
                OM.LOG.warn("A problem occured while notifying other sessions", (Throwable)ex);
                StoreThreadLocal.release();
                this.accessor = null;
                this.lockedTargets = null;
                if (this.packageRegistry != null) {
                    this.packageRegistry.deactivate();
                    this.packageRegistry = null;
                }
            }
        }
        finally {
            StoreThreadLocal.release();
            this.accessor = null;
            this.lockedTargets = null;
            if (this.packageRegistry != null) {
                this.packageRegistry.deactivate();
                this.packageRegistry = null;
            }
        }
    }

    @Override
    public CDOCommitInfo createCommitInfo() {
        CDOBranch branch = this.transaction.getBranch();
        String userID = this.transaction.getSession().getUserID();
        CDOCommitData commitData = this.createCommitData();
        InternalCDOCommitInfoManager commitInfoManager = this.repository.getCommitInfoManager();
        return commitInfoManager.createCommitInfo(branch, this.timeStamp, this.previousTimeStamp, userID, this.commitComment, commitData);
    }

    public CDOCommitInfo createFailureCommitInfo() {
        return new FailureCommitInfo(this.timeStamp, this.previousTimeStamp);
    }

    private CDOCommitData createCommitData() {
        IndexedList.ArrayBacked<CDOPackageUnit> newPackageUnitsCollection = new IndexedList.ArrayBacked<CDOPackageUnit>(){

            protected CDOPackageUnit[] getArray() {
                return TransactionCommitContext.this.newPackageUnits;
            }
        };
        IndexedList.ArrayBacked<CDOIDAndVersion> newObjectsCollection = new IndexedList.ArrayBacked<CDOIDAndVersion>(){

            protected CDOIDAndVersion[] getArray() {
                return TransactionCommitContext.this.newObjects;
            }
        };
        IndexedList.ArrayBacked<CDORevisionKey> changedObjectsCollection = new IndexedList.ArrayBacked<CDORevisionKey>(){

            protected CDORevisionKey[] getArray() {
                return TransactionCommitContext.this.dirtyObjectDeltas;
            }
        };
        IndexedList<CDOIDAndVersion> detachedObjectsCollection = new IndexedList<CDOIDAndVersion>(){

            public CDOIDAndVersion get(int i) {
                if (TransactionCommitContext.this.cachedDetachedRevisions[i] != null) {
                    return TransactionCommitContext.this.cachedDetachedRevisions[i];
                }
                return CDOIDUtil.createIDAndVersion((CDOID)TransactionCommitContext.this.detachedObjects[i], (int)0);
            }

            public int size() {
                return TransactionCommitContext.this.detachedObjects.length;
            }
        };
        return new CDOCommitDataImpl((List)newPackageUnitsCollection, (List)newObjectsCollection, (List)changedObjectsCollection, (List)detachedObjectsCollection);
    }

    protected void adjustForCommit() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            newPackageUnit.setTimeStamp(this.timeStamp);
            ++n2;
        }
        CDOBranch branch = this.transaction.getBranch();
        InternalCDORevision[] internalCDORevisionArray = this.newObjects;
        int n3 = this.newObjects.length;
        n = 0;
        while (n < n3) {
            InternalCDORevision newObject = internalCDORevisionArray[n];
            newObject.adjustForCommit(branch, this.timeStamp);
            ++n;
        }
    }

    protected void lockObjects() throws InterruptedException {
        this.lockedObjects.clear();
        this.lockedTargets = null;
        try {
            InternalCDORevisionDelta delta;
            final boolean supportingBranches = this.repository.isSupportingBranches();
            CDOFeatureDeltaVisitorImpl deltaTargetLocker = null;
            if (this.ensuringReferentialIntegrity) {
                final HashSet<CDOID> newIDs = new HashSet<CDOID>();
                int i = 0;
                while (i < this.newObjects.length) {
                    InternalCDORevision newRevision = this.newObjects[i];
                    CDOID newID = newRevision.getID();
                    if (newID instanceof CDOIDObject) {
                        newIDs.add(newID);
                    }
                    ++i;
                }
                deltaTargetLocker = new CDOFeatureDeltaVisitorImpl(){

                    public void visit(CDOAddFeatureDelta delta) {
                        TransactionCommitContext.this.lockTarget(delta.getValue(), newIDs, supportingBranches);
                    }

                    public void visit(CDOSetFeatureDelta delta) {
                        TransactionCommitContext.this.lockTarget(delta.getValue(), newIDs, supportingBranches);
                    }
                };
                CDOReferenceAdjuster revisionTargetLocker = new CDOReferenceAdjuster(){

                    public Object adjustReference(Object value, EStructuralFeature feature, int index) {
                        TransactionCommitContext.this.lockTarget(value, newIDs, supportingBranches);
                        return value;
                    }
                };
                int i2 = 0;
                while (i2 < this.newObjects.length) {
                    InternalCDORevision newRevision = this.newObjects[i2];
                    newRevision.adjustReferences(revisionTargetLocker);
                    ++i2;
                }
            }
            int i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                delta = this.dirtyObjectDeltas[i];
                CDOID id = delta.getID();
                Object key = this.lockManager.getLockKey(id, this.transaction.getBranch());
                this.lockedObjects.add(new DeltaLockWrapper(key, delta));
                if (this.hasContainmentChanges(delta) && this.isContainerLocked(delta)) {
                    throw new ContainmentCycleDetectedException("Parent (" + key + ") is already locked for containment changes");
                }
                ++i;
            }
            i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                delta = this.dirtyObjectDeltas[i];
                if (deltaTargetLocker != null) {
                    delta.accept((CDOFeatureDeltaVisitor)deltaTargetLocker);
                }
                ++i;
            }
            i = 0;
            while (i < this.detachedObjects.length) {
                CDOID id = this.detachedObjects[i];
                Object key = this.lockManager.getLockKey(id, this.transaction.getBranch());
                this.lockedObjects.add(key);
                ++i;
            }
            if (!this.lockedObjects.isEmpty()) {
                this.lockManager.lock(IRWLockManager.LockType.WRITE, this.transaction, this.lockedObjects, 1000L);
                if (this.lockedTargets != null) {
                    for (CDOID id : this.lockedTargets) {
                        InternalCDORevision revision = this.revisionManager.getRevision(id, (CDOBranchPoint)this.transaction, -1, 0, true);
                        if (revision != null && !(revision instanceof DetachedCDORevision)) continue;
                        throw new IllegalStateException("Object " + id + " can not be referenced anymore because it has been detached");
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            this.lockedObjects.clear();
            this.lockedTargets = null;
            throw ex;
        }
    }

    private boolean isContainerLocked(InternalCDORevisionDelta delta) {
        CDOID id = delta.getID();
        InternalCDORevision revision = this.revisionManager.getRevisionByVersion(id, (CDOBranchVersion)delta, -1, true);
        if (revision == null) {
            throw new ConcurrentModificationException("Attempt by " + this.transaction + " to modify historical revision: " + CDORevisionUtil.copyRevisionKey((CDORevisionKey)delta));
        }
        return this.isContainerLocked(revision);
    }

    private boolean isContainerLocked(InternalCDORevision revision) {
        InternalCDORevisionDelta delta;
        Object object;
        CDOID id = (CDOID)revision.getContainerID();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return false;
        }
        Object key = this.lockManager.getLockKey(id, this.transaction.getBranch());
        DeltaLockWrapper lockWrapper = new DeltaLockWrapper(key, null);
        if (this.lockManager.hasLockByOthers(IRWLockManager.LockType.WRITE, this.transaction, lockWrapper) && (object = this.lockManager.getLockEntryObject(lockWrapper)) instanceof DeltaLockWrapper && (delta = ((DeltaLockWrapper)object).getDelta()) != null && this.hasContainmentChanges(delta)) {
            return true;
        }
        InternalCDORevision parent = this.revisionManager.getRevision(id, (CDOBranchPoint)this.transaction, -1, 0, true);
        if (parent != null) {
            return this.isContainerLocked(parent);
        }
        return false;
    }

    private boolean hasContainmentChanges(InternalCDORevisionDelta delta) {
        for (CDOFeatureDelta featureDelta : delta.getFeatureDeltas()) {
            EStructuralFeature feature = featureDelta.getFeature();
            if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) continue;
            return true;
        }
        return false;
    }

    private void lockTarget(Object value, Set<CDOID> newIDs, boolean supportingBranches) {
        if (value instanceof CDOIDObject) {
            CDOIDObject id = (CDOIDObject)value;
            if (id.isNull()) {
                return;
            }
            if (newIDs.contains(id)) {
                return;
            }
            if (this.detachedObjectTypes != null && this.detachedObjectTypes.containsKey(id)) {
                throw new IllegalStateException("This commit deletes object " + id + " and adds a reference at the same time");
            }
            Object key = this.lockManager.getLockKey((CDOID)id, this.transaction.getBranch());
            this.lockedObjects.add(key);
            if (this.lockedTargets == null) {
                this.lockedTargets = new ArrayList<CDOID>();
            }
            this.lockedTargets.add((CDOID)id);
        }
    }

    protected void checkXRefs() {
        if (this.ensuringReferentialIntegrity && this.detachedObjectTypes != null) {
            XRefContext context = new XRefContext();
            this.xRefs = context.getXRefs(this.accessor);
            if (!this.xRefs.isEmpty()) {
                this.rollbackMessage = "Referential integrity violated";
            }
        }
    }

    private synchronized void unlockObjects() {
        if (!this.lockedObjects.isEmpty()) {
            this.lockManager.unlock(IRWLockManager.LockType.WRITE, this.transaction, this.lockedObjects);
            this.lockedObjects.clear();
        }
    }

    private void computeDirtyObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.dirtyObjectDeltas.length);
            int i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                this.dirtyObjects[i] = this.computeDirtyObject(this.dirtyObjectDeltas[i]);
                if (this.dirtyObjects[i] == null) {
                    throw new IllegalStateException("Can not retrieve origin revision for " + this.dirtyObjectDeltas[i]);
                }
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision computeDirtyObject(InternalCDORevisionDelta delta) {
        CDOID id = delta.getID();
        InternalCDORevision oldRevision = this.revisionManager.getRevisionByVersion(id, (CDOBranchVersion)delta, -1, true);
        if (oldRevision == null) {
            throw new IllegalStateException("Origin revision not found for " + delta);
        }
        CDOBranch branch = this.transaction.getBranch();
        if (ObjectUtil.equals((Object)oldRevision.getBranch(), (Object)branch) && oldRevision.isHistorical()) {
            throw new ConcurrentModificationException("Attempt by " + this.transaction + " to modify historical revision: " + oldRevision);
        }
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)oldRevision.getEClass());
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                this.repository.ensureChunk(oldRevision, feature, 0, oldRevision.getList(feature).size());
            }
            ++n2;
        }
        InternalCDORevision newRevision = oldRevision.copy();
        newRevision.adjustForCommit(branch, this.timeStamp);
        delta.apply((CDORevision)newRevision);
        return newRevision;
    }

    private void applyIDMappings(InternalCDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    CDOID newID = (CDOID)this.idMappings.get(revision.getID());
                    if (newID != null) {
                        revision.setID(newID);
                    }
                    revision.adjustReferences(this.idMapper);
                    monitor.worked();
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public synchronized void rollback(String message) {
        if (this.rollbackMessage == null) {
            this.rollbackMessage = message;
            this.unlockObjects();
            if (this.accessor != null) {
                try {
                    try {
                        this.accessor.rollback();
                    }
                    catch (RuntimeException ex) {
                        OM.LOG.warn("Problem while rolling back  the transaction", (Throwable)ex);
                        this.repository.failCommit(this.timeStamp);
                    }
                }
                finally {
                    this.repository.failCommit(this.timeStamp);
                }
            }
        }
    }

    protected IStoreAccessor getAccessor() {
        return this.accessor;
    }

    private void updateInfraStructure(OMMonitor monitor) {
        try {
            monitor.begin(7.0);
            this.addNewPackageUnits(monitor.fork());
            this.addRevisions((CDORevision[])this.newObjects, monitor.fork());
            this.addRevisions((CDORevision[])this.dirtyObjects, monitor.fork());
            this.reviseDetachedObjects(monitor.fork());
            this.unlockObjects();
            monitor.worked();
            if (this.isAutoReleaseLocksEnabled()) {
                this.repository.getLockManager().unlock(this.transaction);
            }
            monitor.worked();
            this.repository.notifyWriteAccessHandlers(this.transaction, this, false, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPackageUnits(OMMonitor monitor) {
        InternalCDOPackageRegistry repositoryPackageRegistry;
        InternalCDOPackageRegistry internalCDOPackageRegistry = repositoryPackageRegistry = this.repository.getPackageRegistry(false);
        synchronized (internalCDOPackageRegistry) {
            try {
                monitor.begin((double)this.newPackageUnits.length);
                int i = 0;
                while (i < this.newPackageUnits.length) {
                    this.newPackageUnits[i].setState(CDOPackageUnit.State.LOADED);
                    repositoryPackageRegistry.putPackageUnit(this.newPackageUnits[i]);
                    monitor.worked();
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void addRevisions(CDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                if (revision != null) {
                    this.revisionManager.addRevision(revision);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void reviseDetachedObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.cachedDetachedRevisions.length);
            long revised = this.getBranchPoint().getTimeStamp() - 1L;
            InternalCDORevision[] internalCDORevisionArray = this.cachedDetachedRevisions;
            int n = this.cachedDetachedRevisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    revision.setRevised(revised);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void detachObjects(OMMonitor monitor) {
        int size = this.detachedObjects.length;
        this.cachedDetachedRevisions = new InternalCDORevision[size];
        CDOID[] detachedObjects = this.getDetachedObjects();
        try {
            monitor.begin((double)size);
            int i = 0;
            while (i < size) {
                CDOID id = detachedObjects[i];
                this.cachedDetachedRevisions[i] = (InternalCDORevision)this.revisionManager.getCache().getRevision(id, (CDOBranchPoint)this.transaction);
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public String toString() {
        return MessageFormat.format("TransactionCommitContext[{0}, {1}, {2}]", this.transaction.getSession(), this.transaction, CDOCommonUtil.formatTimeStamp((long)this.timeStamp));
    }

    private static final class DeltaLockWrapper
    implements CDOIDAndBranch {
        private Object key;
        private InternalCDORevisionDelta delta;

        public DeltaLockWrapper(Object key, InternalCDORevisionDelta delta) {
            this.key = key;
            this.delta = delta;
        }

        public Object getKey() {
            return this.key;
        }

        public InternalCDORevisionDelta getDelta() {
            return this.delta;
        }

        public CDOID getID() {
            return this.key instanceof CDOIDAndBranch ? ((CDOIDAndBranch)this.key).getID() : (CDOID)this.key;
        }

        public CDOBranch getBranch() {
            return this.key instanceof CDOIDAndBranch ? ((CDOIDAndBranch)this.key).getBranch() : null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeltaLockWrapper) {
                DeltaLockWrapper wrapper = (DeltaLockWrapper)obj;
                return this.key.equals(wrapper.getKey());
            }
            return this.key.equals(obj);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransactionPackageRegistry
    extends CDOPackageRegistryImpl {
        private static final long serialVersionUID = 1L;

        public TransactionPackageRegistry(InternalCDOPackageRegistry repositoryPackageRegistry) {
            this.delegateRegistry = repositoryPackageRegistry;
            this.setPackageLoader(repositoryPackageRegistry.getPackageLoader());
        }

        public synchronized void putPackageUnit(InternalCDOPackageUnit packageUnit) {
            LifecycleUtil.checkActive((Object)((Object)this));
            packageUnit.setPackageRegistry((InternalCDOPackageRegistry)this);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n = internalCDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                EPackage ePackage = packageInfo.getEPackage();
                this.basicPut(ePackage.getNsURI(), ePackage);
                ++n2;
            }
            this.resetInternalCaches();
        }

        protected void disposePackageUnits() {
        }

        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class XRefContext
    implements IStoreAccessor.QueryXRefsContext {
        private Map<EClass, List<EReference>> sourceCandidates = new HashMap<EClass, List<EReference>>();
        private Set<CDOID> detachedIDs = new HashSet<CDOID>();
        private Set<CDOID> dirtyIDs = new HashSet<CDOID>();
        private List<CDOIDReference> result = new ArrayList<CDOIDReference>();

        public XRefContext() {
            XRefsQueryHandler.collectSourceCandidates(TransactionCommitContext.this.transaction, TransactionCommitContext.this.detachedObjectTypes.values(), this.sourceCandidates);
            CDOID[] cDOIDArray = TransactionCommitContext.this.detachedObjects;
            int n = cDOIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                this.detachedIDs.add(id);
                ++n2;
            }
            cDOIDArray = TransactionCommitContext.this.dirtyObjects;
            n = cDOIDArray.length;
            n2 = 0;
            while (n2 < n) {
                CDOID revision = cDOIDArray[n2];
                this.dirtyIDs.add(revision.getID());
                ++n2;
            }
        }

        public List<CDOIDReference> getXRefs(IStoreAccessor accessor) {
            accessor.queryXRefs(this);
            this.checkDirtyObjects();
            return this.result;
        }

        private void checkDirtyObjects() {
            final CDOID[] dirtyID = new CDOID[1];
            CDOReferenceAdjuster dirtyObjectChecker = new CDOReferenceAdjuster(){

                public Object adjustReference(Object targetID, EStructuralFeature feature, int index) {
                    if (feature != CDOContainerFeatureDelta.CONTAINER_FEATURE && XRefContext.this.detachedIDs.contains(targetID)) {
                        XRefContext.this.result.add(new CDOIDReference((CDOID)targetID, dirtyID[0], feature, index));
                    }
                    return targetID;
                }
            };
            InternalCDORevision[] internalCDORevisionArray = TransactionCommitContext.this.dirtyObjects;
            int n = internalCDORevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision dirtyObject = internalCDORevisionArray[n2];
                dirtyID[0] = dirtyObject.getID();
                dirtyObject.adjustReferences(dirtyObjectChecker);
                ++n2;
            }
        }

        public long getTimeStamp() {
            return 0L;
        }

        public CDOBranch getBranch() {
            return TransactionCommitContext.this.transaction.getBranch();
        }

        @Override
        public Map<CDOID, EClass> getTargetObjects() {
            return TransactionCommitContext.this.detachedObjectTypes;
        }

        @Override
        public EReference[] getSourceReferences() {
            return new EReference[0];
        }

        @Override
        public Map<EClass, List<EReference>> getSourceCandidates() {
            return this.sourceCandidates;
        }

        @Override
        public int getMaxResults() {
            return -1;
        }

        @Override
        public boolean addXRef(CDOID targetID, CDOID sourceID, EReference sourceReference, int sourceIndex) {
            if (CDOIDUtil.isNull((CDOID)targetID)) {
                return true;
            }
            if (this.detachedIDs.contains(sourceID)) {
                return true;
            }
            if (this.dirtyIDs.contains(sourceID)) {
                return true;
            }
            this.result.add(new CDOIDReference(targetID, sourceID, (EStructuralFeature)sourceReference, sourceIndex));
            return true;
        }
    }
}

