/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.embedded;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOQueryQueue;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedClientSession;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedServerSessionProtocol;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedClientSessionProtocol
extends Lifecycle
implements CDOSessionProtocol {
    private EmbeddedClientSession session;
    private EmbeddedServerSessionProtocol serverSessionProtocol;
    private InternalRepository repository;

    public EmbeddedClientSessionProtocol(EmbeddedClientSession session) {
        this.session = session;
    }

    public EmbeddedClientSession getSession() {
        return this.session;
    }

    public EmbeddedServerSessionProtocol getServerSessionProtocol() {
        return this.serverSessionProtocol;
    }

    public InternalSession openSession(boolean passiveUpdateEnabled) {
        this.repository = this.session.getRepository();
        this.activate();
        return this.serverSessionProtocol.openSession(this.repository, passiveUpdateEnabled);
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        throw new UnsupportedOperationException();
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        throw new UnsupportedOperationException();
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        throw new UnsupportedOperationException();
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
        CDOSessionProtocol.RepositoryTimeResult result = new CDOSessionProtocol.RepositoryTimeResult();
        long timeStamp = System.currentTimeMillis();
        result.setRequested(timeStamp);
        result.setIndicated(timeStamp);
        result.setResponded(timeStamp);
        result.setConfirmed(timeStamp);
        return result;
    }

    public void disablePassiveUpdate() {
        throw new UnsupportedOperationException();
    }

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode mode) {
        throw new UnsupportedOperationException();
    }

    public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        throw new UnsupportedOperationException();
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        try {
            InternalSession session = this.serverSessionProtocol.getSession();
            StoreThreadLocal.setSession(session);
            InternalCDORevision internalCDORevision = this.repository.getRevisionManager().getRevisionByVersion(id, branchVersion, referenceChunk, true);
            return internalCDORevision;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    public List<InternalCDORevision> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        try {
            InternalSession session = this.serverSessionProtocol.getSession();
            StoreThreadLocal.setSession(session);
            ArrayList<CDOID> ids = new ArrayList<CDOID>(infos.size());
            for (RevisionInfo info : infos) {
                ids.add(info.getID());
            }
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            StoreThreadLocal.release();
            throw throwable;
        }
    }

    public CDOSessionProtocol.RefreshSessionResult refresh(long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
        throw new UnsupportedOperationException();
    }

    public void openView(int viewID, boolean readOnly, CDOBranchPoint branchPoint) {
        InternalSession session = this.serverSessionProtocol.getSession();
        if (readOnly) {
            session.openView(viewID, branchPoint);
        } else {
            session.openTransaction(viewID, branchPoint);
        }
    }

    public CDOBranchPoint openView(int viewID, boolean readOnly, String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    public void switchTarget(int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void closeView(int viewID) {
        InternalView view = this.serverSessionProtocol.getSession().getView(viewID);
        if (view != null) {
            view.close();
        }
    }

    public void changeSubscription(int viewID, List<CDOID> ids, boolean subscribeMode, boolean clear) {
        throw new UnsupportedOperationException();
    }

    public void query(CDOView view, AbstractQueryIterator<?> query) {
        InternalView serverView = this.serverSessionProtocol.getSession().getView(view.getViewID());
        InternalQueryManager queryManager = this.repository.getQueryManager();
        InternalQueryResult result = queryManager.execute(serverView, query.getQueryInfo());
        query.setQueryID(result.getQueryID());
        CDOQueryQueue resultQueue = query.getQueue();
        try {
            try {
                while (result.hasNext()) {
                    Object object = result.next();
                    resultQueue.add(object);
                }
            }
            catch (RuntimeException ex) {
                resultQueue.setException((Throwable)ex);
                resultQueue.close();
            }
            catch (Throwable throwable) {
                resultQueue.setException((Throwable)new RuntimeException(throwable.getMessage(), throwable));
                resultQueue.close();
            }
        }
        finally {
            resultQueue.close();
        }
    }

    public boolean cancelQuery(int queryID) {
        this.repository.getQueryManager().cancel(queryID);
        return true;
    }

    public boolean isObjectLocked(CDOView view, CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.LockObjectsResult lockObjects(List<InternalCDORevision> viewedRevisions, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void unlockObjects(CDOView view, Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        throw new UnsupportedOperationException();
    }

    public String changeLockArea(CDOView view, boolean create) {
        throw new UnsupportedOperationException();
    }

    public List<byte[]> queryLobs(Set<byte[]> ids) {
        throw new UnsupportedOperationException();
    }

    public void loadLob(CDOLobInfo info, Object outputStreamOrWriter) {
        throw new UnsupportedOperationException();
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitTransaction(int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        monitor.begin(2.0);
        boolean success = false;
        InternalCommitContext serverCommitContext = null;
        CDOSessionProtocol.CommitTransactionResult result = null;
        try {
            InternalTransaction serverTransaction = (InternalTransaction)this.serverSessionProtocol.getSession().getView(transactionID);
            serverCommitContext = serverTransaction.createCommitContext();
            serverCommitContext.preWrite();
            serverCommitContext.setAutoReleaseLocksEnabled(releaseLocks);
            List npu = commitData.getNewPackageUnits();
            serverCommitContext.setNewPackageUnits(npu.toArray(new InternalCDOPackageUnit[npu.size()]));
            List no = commitData.getNewObjects();
            InternalCDORevision[] array = new InternalCDORevision[no.size()];
            int index = 0;
            for (CDOIDAndVersion object : no) {
                InternalCDORevision revision = (InternalCDORevision)object;
                array[index++] = revision;
            }
            serverCommitContext.setNewObjects(array);
            List rd = commitData.getChangedObjects();
            serverCommitContext.setDirtyObjectDeltas(rd.toArray(new InternalCDORevisionDelta[rd.size()]));
            List detachedObjects = commitData.getDetachedObjects();
            serverCommitContext.setDetachedObjects(detachedObjects.toArray(new CDOID[detachedObjects.size()]));
            serverCommitContext.write(monitor.fork());
            boolean bl = success = serverCommitContext.getRollbackMessage() == null;
            if (success) {
                serverCommitContext.commit(monitor.fork());
            } else {
                monitor.worked();
            }
        }
        finally {
            if (serverCommitContext != null) {
                serverCommitContext.postCommit(success);
            }
            monitor.done();
        }
        return result;
    }

    public CDOSessionProtocol.CommitTransactionResult commitDelegation(CDOBranch branch, String userID, String comment, CDOCommitData commitData, Map<CDOID, EClass> detachedObjectTypes, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
        throw new UnsupportedOperationException();
    }

    public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage message, List<CDORemoteSession> recipients) {
        throw new UnsupportedOperationException();
    }

    public boolean unsubscribeRemoteSessions() {
        throw new UnsupportedOperationException();
    }

    public void replicateRepository(CDOReplicationContext context, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void replicateRepositoryRaw(CDORawReplicationContext context, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... ranges) {
        throw new UnsupportedOperationException();
    }

    public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        throw new UnsupportedOperationException();
    }

    public CDOAuthenticationResult handleAuthenticationChallenge(byte[] randomToken) throws Exception {
        CDOAuthenticator authenticator = this.getSession().getAuthenticator();
        if (authenticator == null) {
            throw new IllegalStateException("No authenticator configured");
        }
        CDOAuthenticationResult result = authenticator.authenticate(randomToken);
        if (result == null) {
            throw new SecurityException("Not authenticated");
        }
        String userID = result.getUserID();
        if (userID == null) {
            throw new SecurityException("No user ID");
        }
        byte[] cryptedToken = result.getCryptedToken();
        if (cryptedToken == null) {
            throw new SecurityException("No crypted token");
        }
        return result;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.serverSessionProtocol = new EmbeddedServerSessionProtocol(this);
        this.serverSessionProtocol.activate();
    }

    protected void doDeactivate() throws Exception {
        this.serverSessionProtocol.deactivate();
        this.serverSessionProtocol = null;
        super.doDeactivate();
    }
}

