/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.net4j.util.HexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurableLockArea
implements IDurableLockingManager.LockArea {
    public static final int DEFAULT_DURABLE_LOCKING_ID_BYTES = 32;
    private String durableLockingID;
    private String userID;
    private CDOBranchPoint branchPoint;
    private boolean readOnly;
    private Map<CDOID, IDurableLockingManager.LockGrade> locks;

    public DurableLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        this.durableLockingID = durableLockingID;
        this.userID = userID;
        this.branchPoint = branchPoint;
        this.readOnly = readOnly;
        this.locks = locks;
    }

    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    public String getUserID() {
        return this.userID;
    }

    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks() {
        return this.locks;
    }

    public String toString() {
        return MessageFormat.format("DurableLockArea[id={0}, user={1}, branchPoint={2}, readOnly={3}, locks={4}]", this.durableLockingID, this.userID, this.branchPoint, this.readOnly, this.locks);
    }

    public static String createDurableLockingID() {
        return DurableLockArea.createDurableLockingID(32);
    }

    public static String createDurableLockingID(int bytes) {
        byte[] buffer = new byte[bytes];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(buffer);
        return HexUtil.bytesToHex((byte[])buffer);
    }
}

