/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.net4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongIDStore
extends Store {
    public static final Set<CDOID.ObjectType> OBJECT_ID_TYPES = Collections.singleton(CDOID.ObjectType.LONG);
    public static final long NULL = CDOIDUtil.getLong((CDOID)CDOID.NULL);
    @ReflectUtil.ExcludeFromDump
    private transient AtomicLong lastObjectID = new AtomicLong();
    @ReflectUtil.ExcludeFromDump
    private transient AtomicLong nextLocalObjectID = new AtomicLong(Long.MAX_VALUE);

    public LongIDStore(String type, Set<IStore.ChangeFormat> supportedChangeFormats, Set<IStore.RevisionTemporality> supportedRevisionTemporalities, Set<IStore.RevisionParallelism> supportedRevisionParallelisms) {
        super(type, OBJECT_ID_TYPES, supportedChangeFormats, supportedRevisionTemporalities, supportedRevisionParallelisms);
    }

    @Override
    public CDOID createObjectID(String val) {
        Long id = Long.valueOf(val);
        return CDOIDUtil.createLong((long)id);
    }

    public long getLastObjectID() {
        return this.lastObjectID.get();
    }

    public void setLastObjectID(long lastObjectID) {
        this.lastObjectID.set(lastObjectID);
    }

    public long getNextLocalObjectID() {
        return this.nextLocalObjectID.get();
    }

    public void setNextLocalObjectID(long nextLocalObjectID) {
        this.nextLocalObjectID.set(nextLocalObjectID);
    }

    public CDOID getNextCDOID(LongIDStoreAccessor accessor, CDORevision revision) {
        if (revision.getBranch().isLocal()) {
            return CDOIDUtil.createLong((long)this.nextLocalObjectID.getAndDecrement());
        }
        return CDOIDUtil.createLong((long)this.lastObjectID.incrementAndGet());
    }

    @Override
    public boolean isLocal(CDOID id) {
        long value = CDOIDUtil.getLong((CDOID)id);
        return value > this.nextLocalObjectID.get();
    }

    public void ensureLastObjectID(CDOID id) {
        long addedID = CDOIDUtil.getLong((CDOID)id);
        if (addedID > this.getLastObjectID()) {
            this.setLastObjectID(addedID);
        }
    }
}

