/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.server.LimitedInputStream;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class StoreAccessor
extends StoreAccessorBase {
    protected StoreAccessor(Store store, ISession session) {
        super(store, session);
    }

    protected StoreAccessor(Store store, ITransaction transaction) {
        super(store, transaction);
    }

    protected void doWrite(InternalCommitContext context, OMMonitor monitor) {
        block14: {
            CDOBranch branch = context.getBranchPoint().getBranch();
            long timeStamp = context.getBranchPoint().getTimeStamp();
            long previousTimeStamp = context.getPreviousTimeStamp();
            String userID = context.getUserID();
            String commitComment = context.getCommitComment();
            boolean deltas = this.getStore().getSupportedChangeFormats().contains((Object)IStore.ChangeFormat.DELTA);
            InternalCDOPackageUnit[] newPackageUnits = context.getNewPackageUnits();
            InternalCDORevision[] newObjects = context.getNewObjects();
            CDOID[] detachedObjects = context.getDetachedObjects();
            int dirtyCount = deltas ? context.getDirtyObjectDeltas().length : context.getDirtyObjects().length;
            try {
                ExtendedDataInputStream in;
                monitor.begin((double)(1 + newPackageUnits.length + 2 + newObjects.length + detachedObjects.length + dirtyCount));
                this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, commitComment, monitor.fork());
                if (newPackageUnits.length != 0) {
                    this.writePackageUnits(newPackageUnits, monitor.fork((double)newPackageUnits.length));
                }
                this.addIDMappings(context, monitor.fork());
                this.applyIDMappings(context, monitor);
                if (detachedObjects.length != 0) {
                    this.detachObjects(detachedObjects, branch, timeStamp, monitor.fork((double)detachedObjects.length));
                }
                if (newObjects.length != 0) {
                    this.writeRevisions(newObjects, branch, monitor.fork((double)newObjects.length));
                }
                if (dirtyCount != 0) {
                    if (deltas) {
                        this.writeRevisionDeltas(context.getDirtyObjectDeltas(), branch, timeStamp, monitor.fork((double)dirtyCount));
                    } else {
                        this.writeRevisions(context.getDirtyObjects(), branch, monitor.fork((double)dirtyCount));
                    }
                }
                if ((in = context.getLobs()) == null) break block14;
                try {
                    int count = in.readInt();
                    int i = 0;
                    while (i < count) {
                        byte[] id = in.readByteArray();
                        long size = in.readLong();
                        if (size > 0L) {
                            this.writeBlob(id, size, new LimitedInputStream((InputStream)in, size));
                        } else {
                            this.writeClob(id, -size, new InputStreamReader(new LimitedInputStream((InputStream)in, -size)));
                        }
                        ++i;
                    }
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        context.applyIDMappings(monitor.fork());
    }

    protected abstract void writeCommitInfo(CDOBranch var1, long var2, long var4, String var6, String var7, OMMonitor var8);

    protected abstract void writeRevisions(InternalCDORevision[] var1, CDOBranch var2, OMMonitor var3);

    protected abstract void writeRevisionDeltas(InternalCDORevisionDelta[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void detachObjects(CDOID[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void writeBlob(byte[] var1, long var2, InputStream var4) throws IOException;

    protected abstract void writeClob(byte[] var1, long var2, Reader var4) throws IOException;
}

