/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.location;

import org.eclipse.emf.cdo.location.IRepositoryLocationManager;
import org.eclipse.emf.cdo.ui.internal.location.NewRepositoryLocationDialog;
import org.eclipse.emf.cdo.ui.internal.location.RepositoryLocationItemProvider;
import org.eclipse.emf.cdo.ui.internal.location.bundle.OM;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocationsView
extends ContainerView {
    private NewLocationAction newAction;

    protected IRepositoryLocationManager getContainer() {
        return IRepositoryLocationManager.INSTANCE;
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new RepositoryLocationItemProvider();
    }

    protected Control createUI(Composite parent) {
        this.newAction = new NewLocationAction();
        return super.createUI(parent);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newAction);
        manager.add((IAction)this.getRefreshAction());
        super.fillLocalToolBar(manager);
    }

    private class NewLocationAction
    extends Action {
        public NewLocationAction() {
            this.setText("New Location");
            this.setToolTipText("Add a new repository location");
            this.setImageDescriptor(OM.getImageDescriptor("icons/add.gif"));
        }

        public void run() {
            try {
                NewRepositoryLocationDialog dialog = new NewRepositoryLocationDialog(RepositoryLocationsView.this.getSite().getShell());
                if (dialog.open() == 0) {
                    String connectorType = dialog.getConnectorType();
                    String connectorDescription = dialog.getConnectorDescription();
                    String repositoryName = dialog.getRepositoryName();
                    IRepositoryLocationManager.INSTANCE.addRepositoryLocation(connectorType, connectorDescription, repositoryName);
                }
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
                throw ex;
            }
        }
    }
}

