/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.ui.IPersistableElement;

public class CDOEditorInputImpl
extends PlatformObject
implements CDOEditorInput {
    private CDOView view;
    private boolean viewOwned;
    private String resourcePath;

    public CDOEditorInputImpl(CDOView view, String resourcePath) {
        this(view, resourcePath, false);
    }

    public CDOEditorInputImpl(CDOView view, String resourcePath, boolean viewOwned) {
        this.view = view;
        this.viewOwned = viewOwned;
        this.resourcePath = resourcePath;
    }

    public CDOView getView() {
        return this.view;
    }

    public boolean isViewOwned() {
        return this.viewOwned;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return CDOItemProvider.getViewImageDescriptor(this.view);
    }

    public String getName() {
        if (this.resourcePath != null) {
            return new Path(this.resourcePath).lastSegment();
        }
        return this.view.getSession().getRepositoryInfo().getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        long timeStamp;
        if (this.view.isClosed()) {
            return Messages.getString("CDOEditorInputImpl.0");
        }
        CDOSession session = this.view.getSession();
        String repositoryName = session.getRepositoryInfo().getName();
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryName);
        if (this.resourcePath != null) {
            builder.append(this.resourcePath);
        }
        builder.append(" [");
        builder.append(session.getSessionID());
        builder.append(":");
        builder.append(this.view.getViewID());
        builder.append("]");
        if (this.view.isReadOnly()) {
            builder.append(" readonly");
        }
        if ((timeStamp = this.view.getTimeStamp()) != 0L) {
            builder.append(CDOCommonUtil.formatTimeStamp((long)timeStamp));
        }
        return builder.toString();
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.view) ^ ObjectUtil.hashCode((Object)this.resourcePath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOEditorInputImpl) {
            CDOEditorInputImpl that = (CDOEditorInputImpl)obj;
            return ObjectUtil.equals((Object)this.view, (Object)that.view) && ObjectUtil.equals((Object)this.resourcePath, (Object)that.resourcePath);
        }
        return false;
    }
}

