/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.internal.ui.actions.ResourceNodeNameInputValidator;
import org.eclipse.emf.cdo.internal.ui.actions.ViewAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IWorkbenchPage;

public class CreateResourceNodeAction
extends ViewAction {
    private static final String TITLE_RESOURCE = Messages.getString("CreateResourceAction.0");
    private static final String TITLE_FOLDER = Messages.getString("CreateResourceNodeAction.0");
    private static final String TOOL_TIP_RESOURCE = Messages.getString("CreateResourceAction.1");
    private static final String TOOL_TIP_FOLDER = Messages.getString("CreateResourceNodeAction.1");
    private CDOItemProvider itemProvider;
    private CDOResourceNode selectedNode;
    private boolean createFolder;
    private String resourceNodeName;

    public CreateResourceNodeAction(CDOItemProvider itemProvider, IWorkbenchPage page, CDOView view, CDOResourceNode node, boolean createFolder) {
        super(page, createFolder ? String.valueOf(TITLE_FOLDER) + INTERACTIVE : String.valueOf(TITLE_RESOURCE) + INTERACTIVE, createFolder ? TOOL_TIP_FOLDER : TOOL_TIP_RESOURCE, null, view);
        this.selectedNode = node;
        this.itemProvider = itemProvider;
        this.createFolder = createFolder;
    }

    protected void preRun() throws Exception {
        InputDialog dialog = new InputDialog(this.getShell(), this.createFolder ? TITLE_FOLDER : TITLE_RESOURCE, this.createFolder ? "Enter folder name" : Messages.getString("CreateResourceAction.2"), "res" + (ViewAction.lastResourceNumber + 1), (IInputValidator)new ResourceNodeNameInputValidator(this.selectedNode));
        if (dialog.open() == 0) {
            ++ViewAction.lastResourceNumber;
            this.resourceNodeName = dialog.getValue();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOTransaction transaction = this.getTransaction();
        CDOResourceFolder node = null;
        if (this.createFolder) {
            node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
            node.setName(this.resourceNodeName);
            if (this.selectedNode instanceof CDOResourceFolder) {
                ((CDOResourceFolder)this.selectedNode).getNodes().add((Object)node);
            } else {
                ((CDOResource)this.selectedNode).getContents().add((Object)node);
            }
        } else {
            node = this.selectedNode instanceof CDOResourceFolder ? transaction.createResource(String.valueOf(this.selectedNode.getPath()) + "/" + this.resourceNodeName) : transaction.createResource(this.resourceNodeName);
        }
        transaction.commit();
        this.itemProvider.refreshViewer(true);
        this.itemProvider.selectElement(node, true);
        if (!this.createFolder) {
            String resourcePath = node.getPath();
            CDOEditorUtil.openEditor(this.getPage(), (CDOView)transaction, resourcePath);
        }
    }
}

