/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenSessionDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.emf.cdo.ui.widgets.SessionComposite;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public final class OpenSessionAction
extends LongRunningAction {
    private static final String TITLE = OpenSessionDialog.TITLE;
    private static final String TOOL_TIP = Messages.getString("OpenSessionAction.0");
    private SessionComposite sessionComposite;

    public OpenSessionAction(IWorkbenchPage page) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, CDOSessionsView.getAddImageDescriptor());
    }

    protected void preRun() throws Exception {
        OpenSessionDialog dialog = new OpenSessionDialog(this.getPage());
        if (dialog.open() == 0) {
            this.sessionComposite = dialog.getSessionComposite();
            this.sessionComposite.rememberSettings();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        try {
            String description = this.sessionComposite.getSessionDescription();
            InternalCDOSession session = (InternalCDOSession)this.getContainer().getElement("org.eclipse.emf.cdo.sessions", "cdo", description);
            if (this.sessionComposite.isAutomaticRegistry()) {
                CDOPackageRegistryPopulator.populate((CDOPackageRegistry)session.getPackageRegistry());
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)OpenSessionAction.this.getShell(), (String)OpenSessionAction.this.getText(), (String)(String.valueOf(Messages.getString("OpenSessionAction.3")) + ex.getMessage()));
                }
            });
        }
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

