/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.BulkAddDialog;
import org.eclipse.emf.cdo.internal.ui.dialogs.RollbackTransactionDialog;
import org.eclipse.emf.cdo.internal.ui.editor.PluginDelegator;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEventHandler;
import org.eclipse.emf.cdo.ui.CDOLabelProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.transaction.TransactionException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    public static final String copyright = "Copyright (c) 2004 - 2011 Eike Stepper (Berlin, Germany) and others.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n   Eike Stepper - initial API and implementation";
    public static final String EDITOR_ID = "org.eclipse.emf.cdo.ui.CDOEditor";
    private static final Object EMPTY_INPUT = new Object();
    protected CDOView view;
    protected Object viewerInput;
    protected CDOEventHandler eventHandler;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == CDOEditor.this.contentOutlinePage) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.setCurrentViewer((Viewer)CDOEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == CDOEditor.this.propertySheetPage) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.handleActivate();
                }
            } else if (p == CDOEditor.this) {
                CDOEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = CDOEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            CDOEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            CDOEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!CDOEditor.this.updateProblemIndication) return;
                        CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                CDOEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).CDOEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).CDOEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).CDOEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!CDOEditor.this.isDirty()) {
                                CDOEditor.this.getSite().getPage().closeEditor((IEditorPart)CDOEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).CDOEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (CDOEditor.this.getSite().getPage().getActiveEditor() == CDOEditor.this) {
                                CDOEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                PluginDelegator.INSTANCE.log((Object)exception);
            }
        }
    };
    private IListener viewTargetListener = new IListener(){
        private CDOID inputID;

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewTargetChangedEvent) {
                CDOObject object;
                Object input = CDOEditor.this.selectionViewer.getInput();
                if (input == EMPTY_INPUT) {
                    if (this.inputID != null) {
                        try {
                            CDOObject object2 = CDOEditor.this.view.getObject(this.inputID);
                            CDOEditor.this.selectionViewer.setInput((Object)object2);
                            this.inputID = null;
                        }
                        catch (Exception object2) {}
                    }
                } else if (input instanceof EObject && (object = CDOUtil.getCDOObject((EObject)((EObject)input))).cdoInvalid()) {
                    this.inputID = object.cdoID();
                    CDOEditor.this.selectionViewer.setInput(EMPTY_INPUT);
                }
            }
        }
    };

    protected void handleActivateGen() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleActivate() {
        this.handleActivateGen();
        this.setCurrentViewer((Viewer)this.selectionViewer);
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.cdo.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    PluginDelegator.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        PluginDelegator.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)CDOEditor.getString("_UI_FileConflict_label"), (String)CDOEditor.getString("_WARN_FileConflict"));
    }

    public CDOEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                CDOEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CDOEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            CDOEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).CDOEditor.this.propertySheetPage != null && !(this).CDOEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).CDOEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initializeEditingDomain() {
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        this.adapterFactory = new ComposedAdapterFactory(registry);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (CDOEditor.this.currentViewer != null) {
                        CDOEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        CDOEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public CDOView getView() {
        return this.view;
    }

    public void createModelGen() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public void createModel() {
        try {
            CDOEditorInput editorInput = (CDOEditorInput)this.getEditorInput();
            this.view = editorInput.getView();
            this.view.addListener(this.viewTargetListener);
            BasicCommandStack commandStack = new BasicCommandStack();
            commandStack.addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(final EventObject event) {
                    try {
                        if (CDOEditor.this.getContainer() != null && !CDOEditor.this.getContainer().isDisposed()) {
                            CDOEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                                    if (mostRecentCommand != null) {
                                        CDOEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                                    }
                                    if ((this).CDOEditor.this.propertySheetPage != null && !(this).CDOEditor.this.propertySheetPage.getControl().isDisposed()) {
                                        (this).CDOEditor.this.propertySheetPage.refresh();
                                    }
                                }
                            });
                        }
                    }
                    catch (RuntimeException ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            });
            ResourceSet resourceSet = this.view.getResourceSet();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, resourceSet);
            resourceSet.eAdapters().add((Object)new EditingDomainProviderAdapter());
            String resourcePath = editorInput.getResourcePath();
            if (resourcePath == null) {
                this.viewerInput = resourceSet;
            } else {
                URI resourceURI = CDOURIUtil.createResourceURI((CDOView)this.view, (String)resourcePath);
                this.viewerInput = resourceSet.getResource(resourceURI, true);
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.cdo.ui", 0, CDOEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.cdo.ui", 0, CDOEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, CDOEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CDOEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    CDOEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CDOEditor.this.updateProblemIndication();
            }
        });
    }

    public void createPages() {
        try {
            boolean sliderAllowed;
            this.createModel();
            this.getContainer().setLayoutData((Object)UIUtil.createGridData());
            this.getContainer().setLayout((Layout)UIUtil.createGridLayout((int)1));
            Composite composite = UIUtil.createGridComposite((Composite)this.getContainer(), (int)1);
            composite.setLayoutData((Object)UIUtil.createGridData());
            composite.setLayout((Layout)UIUtil.createGridLayout((int)1));
            Tree tree = new Tree(composite, 2050);
            tree.setLayoutData((Object)UIUtil.createGridData());
            final HashSet<CDOID> expandedIDs = new HashSet<CDOID>();
            boolean bl = sliderAllowed = this.view.isReadOnly() && this.view.getSession().getRepositoryInfo().isSupportingAudits();
            if (sliderAllowed) {
                this.createTimeSlider(composite, expandedIDs);
            }
            this.selectionViewer = new TreeViewer(tree){

                public void setSelection(ISelection selection, boolean reveal) {
                    if (sliderAllowed && selection instanceof IStructuredSelection) {
                        IStructuredSelection ssel = (IStructuredSelection)selection;
                        Iterator it = ssel.iterator();
                        while (it.hasNext()) {
                            Object object = it.next();
                            if (!(object instanceof EObject)) continue;
                            CDOObject cdoObject = CDOUtil.getCDOObject((EObject)((EObject)object));
                            switch (cdoObject.cdoState()) {
                                case TRANSIENT: 
                                case INVALID: 
                                case INVALID_CONFLICT: 
                                case PREPARED: {
                                    it.remove();
                                }
                            }
                        }
                    }
                    super.setSelection(selection, reveal);
                }
            };
            this.selectionViewer.addTreeListener(new ITreeViewerListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    CDOID id = this.getID(event.getElement());
                    if (id != null) {
                        expandedIDs.add(id);
                    }
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    CDOID id = this.getID(event.getElement());
                    if (id != null) {
                        expandedIDs.remove(id);
                    }
                }

                private CDOID getID(Object element) {
                    if (element instanceof EObject) {
                        CDOObject object = CDOUtil.getCDOObject((EObject)((EObject)element));
                        return object.cdoID();
                    }
                    return null;
                }
            });
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider(this.createContentProvider());
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.selectionViewer.setInput(this.viewerInput);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)composite);
            this.setPageText(pageIndex, CDOEditor.getString("_UI_SelectionPage_label"));
            this.setActivePage(0);
            this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
                boolean guard = false;

                public void controlResized(ControlEvent event) {
                    if (!this.guard) {
                        this.guard = true;
                        CDOEditor.this.hideTabs();
                        this.guard = false;
                    }
                }
            });
            this.updateProblemIndication();
            this.eventHandler = new CDOEventHandler(this.view, this.selectionViewer){

                protected void objectInvalidated(InternalCDOObject cdoObject) {
                    if (CDOUtil.isLegacyObject((EObject)cdoObject)) {
                        CDOStateMachine.INSTANCE.read(cdoObject);
                    }
                }

                protected void viewConflict(CDOObject conflictingObject, boolean firstConflict) {
                    CDOEditor.this.refreshViewer(conflictingObject);
                }

                protected void viewClosed() {
                    CDOEditor.this.closeEditor();
                }

                protected void viewDirtyStateChanged() {
                    CDOResource resource;
                    if (CDOEditor.this.viewerInput instanceof CDOResource && !CDOEditor.this.view.isObjectRegistered((resource = (CDOResource)CDOEditor.this.viewerInput).cdoID())) {
                        CDOEditor.this.closeEditor();
                        return;
                    }
                    CDOEditor.this.fireDirtyPropertyChange();
                }
            };
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
        this.getViewer().getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    CDOEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void createTimeSlider(final Composite composite, final Set<CDOID> expandedIDs) {
        CDOSession session = this.view.getSession();
        final long startTimeStamp = session.getRepositoryInfo().getCreationTime();
        long endTimeStamp = session.getLastUpdateTime();
        boolean MIN = false;
        int MAX = 100000;
        long absoluteTimeWindowLength = endTimeStamp - startTimeStamp;
        long scaleFactor = 100000L;
        final double stepSize = (double)absoluteTimeWindowLength / 100000.0;
        final Group group = new Group(composite, 0);
        group.setLayoutData((Object)UIUtil.createEmptyGridData());
        group.setLayout((Layout)new FillLayout());
        group.setText(CDOCommonUtil.formatTimeStamp((long)endTimeStamp));
        group.setVisible(false);
        final Scale scale = new Scale((Composite)group, 256);
        scale.setMinimum(0);
        scale.setMaximum(100000);
        scale.setSelection(100000);
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long value = scale.getSelection();
                long timeStamp = startTimeStamp + Math.round(stepSize * (double)value);
                group.setText(CDOCommonUtil.formatTimeStamp((long)timeStamp));
                CDOEditor.this.view.setTimeStamp(timeStamp);
                CDOEditor.this.selectionViewer.refresh();
                this.setExpandedStates();
            }

            private void setExpandedStates() {
                for (CDOID id : expandedIDs) {
                    try {
                        CDOObject object = CDOEditor.this.view.getObject(id);
                        CDOEditor.this.selectionViewer.setExpandedState((Object)object, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        Action action = new Action(){

            public void run() {
                if (group.isVisible()) {
                    group.setVisible(false);
                    group.setLayoutData((Object)UIUtil.createEmptyGridData());
                    composite.layout();
                } else {
                    group.setVisible(true);
                    group.setLayoutData((Object)new GridData(4, 50, true, false));
                    composite.layout();
                }
            }
        };
        action.setEnabled(true);
        action.setChecked(false);
        action.setImageDescriptor(SharedIcons.getDescriptor((String)"etool16/slider.png"));
        action.setToolTipText(Messages.getString("CDOEditor.1"));
        this.getActionBars().getToolBarManager().add((IAction)action);
    }

    protected IContentProvider createContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
    }

    protected ILabelProvider createLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new CDOLabelProvider((AdapterFactory)this.adapterFactory, this.view, this.selectionViewer), this.createLabelDecorator());
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() != null && !this.getContainer().isDisposed() && this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, CDOEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() != null && !this.getContainer().isDisposed() && this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    CDOEditor.this.contentOutlineViewer = this.getTreeViewer();
                    CDOEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    CDOEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)CDOEditor.this.adapterFactory));
                    CDOEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)CDOEditor.this.adapterFactory));
                    CDOEditor.this.contentOutlineViewer.setInput(CDOEditor.this.viewerInput);
                    CDOEditor.this.createContextMenuFor((StructuredViewer)CDOEditor.this.contentOutlineViewer);
                    if (!CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet()).isEmpty()) {
                        CDOEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet()).get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    CDOEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CDOEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    CDOEditor.this.setSelectionToViewer(selection);
                    CDOEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        return this.view.isDirty();
    }

    public void doSaveGen(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CDOEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CDOEditor.this.isPersisted(resource) || CDOEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            CDOEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        CDOEditor.this.resourceToDiagnosticMap.put(resource, CDOEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            PluginDelegator.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        Display.getCurrent().asyncExec(null);
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean first = true;
                EList resources = CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet());
                monitor.beginTask("", resources.size());
                try {
                    for (Resource resource : resources) {
                        if ((first || !resource.getContents().isEmpty() || CDOEditor.this.isPersisted(resource)) && !CDOEditor.this.editingDomain.isReadOnly(resource)) {
                            try {
                                CDOEditor.this.savedResources.add(resource);
                                saveOptions.put(CDOResource.OPTION_SAVE_PROGRESS_MONITOR, new SubProgressMonitor(monitor, 1));
                                saveOptions.put(CDOResource.OPTION_SAVE_OVERRIDE_TRANSACTION, CDOEditor.this.view);
                                resource.save(saveOptions);
                            }
                            catch (TransactionException exception) {
                                OM.LOG.error((Throwable)exception);
                                Shell shell = CDOEditor.this.getSite().getShell();
                                shell.getDisplay().syncExec(new Runnable(){

                                    public void run() {
                                        CDOTransaction transaction = (CDOTransaction)(this).CDOEditor.this.view;
                                        String title = Messages.getString("CDOEditor.17");
                                        String message = Messages.getString("CDOEditor.18");
                                        RollbackTransactionDialog dialog = new RollbackTransactionDialog(CDOEditor.this.getEditorSite().getPage(), title, message, transaction);
                                        if (dialog.open() == 0) {
                                            transaction.rollback();
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {
                                OM.LOG.error((Throwable)exception);
                                CDOEditor.this.resourceToDiagnosticMap.put(resource, CDOEditor.this.analyzeResourceProblems(resource, exception));
                            }
                            first = false;
                            continue;
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        }
        catch (Exception exception) {
            PluginDelegator.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowedGen() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        throw new UnsupportedOperationException();
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            PluginDelegator.INSTANCE.log((Object)exception);
        }
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.setInputWithNotify(editorInput);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(CDOEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return PluginDelegator.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return PluginDelegator.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        Object element;
        IStructuredSelection sel;
        this.menuAboutToShowGen(menuManager);
        MenuManager submenuManager = new MenuManager(Messages.getString("CDOEditor.23"));
        if (this.populateNewRoot(submenuManager)) {
            menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        }
        if ((sel = (IStructuredSelection)this.editorSelection).size() == 1 && (element = sel.getFirstElement()) instanceof EObject) {
            final EObject object = (EObject)element;
            final ArrayList<EReference> features = new ArrayList<EReference>();
            for (EReference containment : object.eClass().getEAllContainments()) {
                if (!containment.isMany()) continue;
                features.add(containment);
            }
            if (!features.isEmpty()) {
                final IWorkbenchPage page = this.getSite().getPage();
                menuManager.insertBefore("edit", (IAction)new LongRunningAction(page, String.valueOf(Messages.getString("CDOEditor.26")) + SafeAction.INTERACTIVE){
                    private EReference feature;
                    private int instances;

                    protected void preRun() throws Exception {
                        BulkAddDialog dialog = new BulkAddDialog(page, features);
                        if (dialog.open() == 0) {
                            this.feature = dialog.getFeature();
                            this.instances = dialog.getInstances();
                        } else {
                            this.cancel();
                        }
                    }

                    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
                        ArrayList<EObject> children = new ArrayList<EObject>();
                        int i = 0;
                        while (i < this.instances) {
                            EObject child = EcoreUtil.create((EClass)this.feature.getEReferenceType());
                            children.add(child);
                            ++i;
                        }
                        EList list = (EList)object.eGet((EStructuralFeature)this.feature);
                        list.addAll(children);
                    }
                });
            }
        }
    }

    protected boolean populateNewRoot(MenuManager menuManager) {
        boolean populated = false;
        CDOPackageRegistry packageRegistry = this.view.getSession().getPackageRegistry();
        Map.Entry[] entryArray = EMFUtil.getSortedRegistryEntries((EPackage.Registry)packageRegistry);
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = entryArray[n2];
            IContributionItem item = this.populateSubMenu((String)entry.getKey(), entry.getValue(), packageRegistry);
            if (item != null) {
                menuManager.add(item);
                populated = true;
            }
            ++n2;
        }
        return populated;
    }

    private IContributionItem populateSubMenu(String nsURI, Object value, final CDOPackageRegistry packageRegistry) {
        if (value instanceof EPackage) {
            EPackage ePackage = (EPackage)value;
            CDOPackageInfo packageInfo = packageRegistry.getPackageInfo(ePackage);
            CDOPackageUnit packageUnit = packageInfo.getPackageUnit();
            if (packageUnit.isResource()) {
                return null;
            }
            ImageDescriptor imageDescriptor = SharedIcons.getDescriptor((String)"obj16/EPackage.gif");
            MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
            this.populateSubMenu(ePackage, submenuManager);
            return submenuManager;
        }
        ImageDescriptor imageDescriptor = SharedIcons.getDescriptor((String)"obj16/EPackageUnknown.gif");
        final MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
        submenuManager.setRemoveAllWhenShown(true);
        submenuManager.add((IAction)new Action(Messages.getString("CDOEditor.27")){});
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String nsURI = submenuManager.getMenuText();
                EPackage ePackage = packageRegistry.getEPackage(nsURI);
                if (ePackage != null) {
                    CDOEditor.this.populateSubMenu(ePackage, submenuManager);
                } else {
                    OM.LOG.warn(MessageFormat.format(Messages.getString("CDOEditor.28"), nsURI));
                }
            }
        });
        return submenuManager;
    }

    private void populateSubMenu(EPackage ePackage, MenuManager submenuManager) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface()) continue;
            objects.add(EcoreUtil.create((EClass)eClass));
        }
        if (!objects.isEmpty()) {
            Collections.sort(objects, new Comparator<EObject>(){

                @Override
                public int compare(EObject o1, EObject o2) {
                    return o1.eClass().getName().compareTo(o2.eClass().getName());
                }
            });
            for (EObject object : objects) {
                CreateRootAction action = new CreateRootAction(object);
                submenuManager.add((IAction)action);
            }
        }
    }

    protected String getLabelText(Object object) {
        try {
            String text;
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
            if (labelProvider != null && (text = labelProvider.getText(object)) != null) {
                return text;
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        return "";
    }

    protected Object getLabelImage(Object object) {
        try {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
            if (labelProvider != null) {
                return labelProvider.getImage(object);
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        return null;
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.view.removeListener(this.viewTargetListener);
        if (!this.view.isClosed()) {
            try {
                if (this.eventHandler != null) {
                    this.eventHandler.dispose();
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            try {
                if (this.adapterFactory != null) {
                    this.adapterFactory.dispose();
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (((CDOEditorInput)this.getEditorInput()).isViewOwned()) {
            this.view.close();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    protected void fireDirtyPropertyChange() {
        try {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CDOEditor.this.firePropertyChange(257);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeEditor() {
        try {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CDOEditor.this.getSite().getPage().closeEditor((IEditorPart)CDOEditor.this, false);
                        CDOEditor.this.dispose();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void refreshViewer(final Object element) {
        try {
            this.selectionViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (element == null) {
                            CDOEditor.this.selectionViewer.refresh(true);
                        } else {
                            CDOEditor.this.selectionViewer.refresh(element, true);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private final class CreateRootAction
    extends LongRunningAction {
        private EObject object;

        private CreateRootAction(EObject object) {
            super(CDOEditor.this.getEditorSite().getPage(), object.eClass().getName(), ExtendedImageRegistry.getInstance().getImageDescriptor(CDOEditor.this.getLabelImage(object)));
            this.object = object;
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            Resource resource = null;
            IStructuredSelection ssel = (IStructuredSelection)CDOEditor.this.editorSelection;
            if (ssel.isEmpty()) {
                if (CDOEditor.this.viewerInput instanceof Resource) {
                    resource = (Resource)CDOEditor.this.viewerInput;
                }
            } else if (ssel.size() == 1) {
                Object element = ssel.getFirstElement();
                if (element instanceof Resource) {
                    resource = (Resource)element;
                } else if (element instanceof EObject) {
                    resource = ((EObject)element).eResource();
                }
            }
            if (resource != null) {
                if (this.object instanceof InternalCDOObject) {
                    this.object = ((InternalCDOObject)this.object).cdoInternalInstance();
                }
                resource.getContents().add((Object)this.object);
            }
        }
    }

    private class EditingDomainProviderAdapter
    implements Adapter,
    IEditingDomainProvider {
        private EditingDomainProviderAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == IEditingDomainProvider.class;
        }

        public EditingDomain getEditingDomain() {
            return CDOEditor.this.editingDomain;
        }

        public Notifier getTarget() {
            return null;
        }

        public void notifyChanged(Notification notification) {
        }

        public void setTarget(Notifier newTarget) {
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

