/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.ui.actions.CloseSessionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CloseViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.CommitTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CreateBranchAction;
import org.eclipse.emf.cdo.internal.ui.actions.CreateResourceNodeAction;
import org.eclipse.emf.cdo.internal.ui.actions.DisableViewDurabilityAction;
import org.eclipse.emf.cdo.internal.ui.actions.EnableViewDurabilityAction;
import org.eclipse.emf.cdo.internal.ui.actions.ExportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ImportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.LoadResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ManagePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenAuditAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenDurableViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenResourceEditorAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewEditorAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterFilesystemPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterSinglePackageAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterWorkspacePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReloadViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.RollbackTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.SwitchTargetAction;
import org.eclipse.emf.cdo.internal.ui.actions.ToggleLegacyModeDefaultAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    private IWorkbenchPage page;
    private Font bold;

    public CDOItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(rootElementFilter);
        this.page = page;
    }

    public CDOItemProvider(IWorkbenchPage page) {
        this(page, null);
    }

    protected void connectInput(IContainer<Object> input) {
        super.connectInput(input);
        this.bold = UIUtil.getBoldFont((Control)this.getViewer().getControl());
    }

    protected void disconnectInput(IContainer<Object> input) {
        this.bold.dispose();
        super.disconnectInput(input);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CDOBranchManager) {
            return new Object[]{((CDOBranchManager)element).getMainBranch()};
        }
        if (element instanceof CDOBranch) {
            return ((CDOBranch)element).getBranches();
        }
        if (element instanceof CDOView) {
            return ((CDOView)element).getRootResource().getContents().toArray();
        }
        if (element instanceof CDOResourceFolder) {
            return ((CDOResourceFolder)element).getNodes().toArray();
        }
        return super.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CDOBranchManager) {
            return true;
        }
        if (element instanceof CDOBranch) {
            return !((CDOBranch)element).isEmpty();
        }
        if (element instanceof CDOView) {
            return ((CDOView)element).getRootResource().getContents().size() > 0;
        }
        if (element instanceof CDOResourceFolder) {
            return ((CDOResourceFolder)element).getNodes().size() > 0;
        }
        return super.hasChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof CDOBranch) {
            CDOBranch branch = (CDOBranch)element;
            if (branch.isMainBranch()) {
                return branch.getBranchManager();
            }
            return branch.getBase().getBranch();
        }
        if (element instanceof CDOResourceNode) {
            CDOResourceNode node = (CDOResourceNode)element;
            CDOResourceNode parent = (CDOResourceNode)node.eContainer();
            if (parent == null || parent.isRoot()) {
                return node.cdoView();
            }
            return parent;
        }
        return super.getParent(element);
    }

    public String getText(Object obj) {
        if (obj instanceof CDOBranch) {
            return ((CDOBranch)obj).getName();
        }
        if (obj instanceof CDOResourceNode) {
            return ((CDOResourceNode)obj).getName();
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof CDOSession) {
            CDOSession session = (CDOSession)obj;
            CDOCommonRepository.State state = session.getRepositoryInfo().getState();
            switch (state) {
                case ONLINE: {
                    return SharedIcons.getImage((String)"obj16/cdo_session.gif");
                }
                case SYNCING: {
                    return SharedIcons.getImage((String)"obj16/cdo_session_syncing.gif");
                }
                case OFFLINE: {
                    return SharedIcons.getImage((String)"obj16/cdo_session_offline.gif");
                }
            }
        }
        if (obj instanceof CDOView) {
            CDOView view = (CDOView)obj;
            return CDOItemProvider.getViewImage(view);
        }
        if (obj instanceof CDOBranch) {
            return SharedIcons.getImage((String)"obj16/branch.png");
        }
        if (obj instanceof CDOResourceFolder) {
            return SharedIcons.getImage((String)"obj16/CDOResourceFolder.gif");
        }
        if (obj instanceof CDOResource) {
            return SharedIcons.getImage((String)"obj16/CDOResource.gif");
        }
        return super.getImage(obj);
    }

    public Font getFont(Object obj) {
        CDOTransaction transaction;
        if (obj instanceof CDOTransaction && (transaction = (CDOTransaction)obj).isDirty()) {
            return this.bold;
        }
        return super.getFont(obj);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            if (object instanceof CDOSession) {
                this.fillSession(manager, (CDOSession)object);
            } else if (object instanceof CDOView) {
                this.fillView(manager, (CDOView)object);
            } else if (object instanceof CDOResource) {
                this.fillResource(manager, (CDOResource)object);
            } else if (object instanceof CDOResourceFolder) {
                this.fillResourceFolder(manager, (CDOResourceFolder)object);
            }
        }
    }

    protected void fillResourceFolder(IMenuManager manager, CDOResourceFolder folder) {
    }

    protected void fillResource(IMenuManager manager, CDOResource resource) {
        manager.add((IAction)new OpenResourceEditorAction(this.page, (CDOResourceNode)resource));
    }

    protected void fillSession(IMenuManager manager, CDOSession session) {
        manager.add((IAction)new OpenTransactionAction(this.page, session));
        manager.add((IAction)new OpenViewAction(this.page, session));
        manager.add((IAction)new OpenAuditAction(this.page, session));
        manager.add((IAction)new OpenDurableViewAction(this.page, session));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ManagePackagesAction(this.page, session));
        MenuManager generatedManager = new MenuManager(Messages.getString("CDOItemProvider.8"));
        if (this.fillGenerated(generatedManager, session)) {
            manager.add((IContributionItem)generatedManager);
        }
        RegisterWorkspacePackagesAction a1 = new RegisterWorkspacePackagesAction(this.page, session);
        a1.setText(String.valueOf(a1.getText()) + SafeAction.INTERACTIVE);
        manager.add((IAction)a1);
        RegisterFilesystemPackagesAction a2 = new RegisterFilesystemPackagesAction(this.page, session);
        a2.setText(String.valueOf(a2.getText()) + SafeAction.INTERACTIVE);
        manager.add((IAction)a2);
        if (session.getRepositoryInfo().isSupportingBranches()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new CreateBranchAction(this.page, session));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleLegacyModeDefaultAction(session));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseSessionAction(this.page, session));
    }

    protected boolean fillGenerated(MenuManager manager, CDOSession session) {
        ArrayList registeredURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        Collections.sort(registeredURIs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        boolean added = false;
        CDOPackageRegistry packageRegistry = session.getPackageRegistry();
        for (String packageURI : registeredURIs) {
            CDOPackageUnit.Type type;
            if (packageRegistry.containsKey((Object)packageURI) || (type = CDOPackageTypeRegistry.INSTANCE.lookup(packageURI)) != CDOPackageUnit.Type.NATIVE) continue;
            EPackage ePackage = packageRegistry.getEPackage(packageURI);
            if (ePackage == null) {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
            }
            if (ePackage == null) continue;
            manager.add((IAction)new RegisterSinglePackageAction(this.page, session, packageURI));
            added = true;
        }
        return added;
    }

    protected void fillView(IMenuManager manager, CDOView view) {
        manager.add((IAction)new OpenViewEditorAction(this.page, view));
        manager.add((IAction)new LoadResourceAction(this.page, view));
        manager.add((IAction)new ExportResourceAction(this.page, view));
        manager.add((IContributionItem)new Separator());
        if (!view.isReadOnly()) {
            CDOResource rootResource = view.getRootResource();
            manager.add((IAction)new CreateResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, false));
            manager.add((IAction)new CreateResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, true));
            manager.add((IAction)new ImportResourceAction(this.page, view));
            manager.add((IAction)new CommitTransactionAction(this.page, view));
            manager.add((IAction)new RollbackTransactionAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        CDORepositoryInfo repositoryInfo = view.getSession().getRepositoryInfo();
        if (view.isReadOnly() && repositoryInfo.isSupportingAudits() || repositoryInfo.isSupportingBranches()) {
            manager.add((IAction)new SwitchTargetAction(this.page, view));
        }
        manager.add((IAction)new ReloadViewAction(this.page, view));
        if (view.getDurableLockingID() == null) {
            manager.add((IAction)new EnableViewDurabilityAction(this.page, view));
        } else {
            manager.add((IAction)new DisableViewDurabilityAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseViewAction(this.page, view));
    }

    protected void elementAdded(Object element, Object parent) {
        super.elementAdded(element, parent);
        if (element instanceof CDOSession) {
            ((CDOSession)element).addListener(new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOSessionInvalidationEvent) {
                        CDOItemProvider.this.refreshViewer(true);
                    }
                }
            });
        }
        if (element instanceof CDOView) {
            ((CDOView)element).addListener(new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOViewTargetChangedEvent) {
                        CDOItemProvider.this.refreshViewer(true);
                    }
                }
            });
        }
    }

    public static ImageDescriptor getViewImageDescriptor(CDOView view) {
        if (view.isReadOnly()) {
            if (view.getTimeStamp() != 0L) {
                return SharedIcons.getDescriptor((String)"obj16/cdo_editor_historical.gif");
            }
            return SharedIcons.getDescriptor((String)"obj16/cdo_editor_readonly.gif");
        }
        return SharedIcons.getDescriptor((String)"obj16/cdo_editor.gif");
    }

    public static Image getViewImage(CDOView view) {
        if (view.isReadOnly()) {
            if (view.getTimeStamp() != 0L) {
                return SharedIcons.getImage((String)"obj16/cdo_editor_historical.gif");
            }
            return SharedIcons.getImage((String)"obj16/cdo_editor_readonly.gif");
        }
        return SharedIcons.getImage((String)"obj16/cdo_editor.gif");
    }
}

