/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.widgets.SelectBranchComposite;
import org.eclipse.emf.cdo.ui.widgets.SelectTimeStampComposite;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ComposeBranchPointComposite
extends Composite {
    private CDOSession session;
    private CDOBranchPoint branchPoint;
    private SelectBranchComposite selectBranchComposite;
    private SelectTimeStampComposite selectTimeStampComposite;

    public ComposeBranchPointComposite(Composite parent, int style, CDOSession session, CDOBranchPoint branchPoint, boolean allowTimeStamp) {
        super(parent, style);
        CDOBranch branch;
        this.session = session;
        this.branchPoint = branchPoint;
        GridLayout gridLayout = UIUtil.createGridLayout((int)1);
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        CDOBranch cDOBranch = branch = branchPoint == null ? session.getBranchManager().getMainBranch() : branchPoint.getBranch();
        if (session.getRepositoryInfo().isSupportingBranches()) {
            this.selectBranchComposite = this.createSelectBranchComposite(session, branch);
            this.selectBranchComposite.setLayoutData(UIUtil.createGridData());
            this.selectBranchComposite.getBranchViewer().expandAll();
        }
        if (allowTimeStamp) {
            long timeStamp = branchPoint == null ? 0L : branchPoint.getTimeStamp();
            this.selectTimeStampComposite = this.createSelectTimeStampComposite(branch, timeStamp);
            this.selectTimeStampComposite.setLayoutData(UIUtil.createGridData((boolean)true, (boolean)false));
        }
    }

    public CDOSession getSession() {
        return this.session;
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    public SelectBranchComposite getSelectBranchComposite() {
        return this.selectBranchComposite;
    }

    public SelectTimeStampComposite getSelectTimeComposite() {
        return this.selectTimeStampComposite;
    }

    protected SelectTimeStampComposite createSelectTimeStampComposite(CDOBranch branch, long timeStamp) {
        return new SelectTimeStampComposite(this, 0, branch, timeStamp){

            protected void timeStampChanged(long timeStamp) {
                ComposeBranchPointComposite.this.composeBranchPoint();
            }
        };
    }

    protected SelectBranchComposite createSelectBranchComposite(CDOSession session, CDOBranch branch) {
        return new SelectBranchComposite(this, 0, session, branch){

            protected void branchChanged(CDOBranch newBranch) {
                if (ComposeBranchPointComposite.this.selectTimeStampComposite != null) {
                    ComposeBranchPointComposite.this.selectTimeStampComposite.setBranch(newBranch);
                }
                ComposeBranchPointComposite.this.composeBranchPoint();
            }
        };
    }

    protected void branchPointChanged(CDOBranchPoint newBranchPoint) {
    }

    private void composeBranchPoint() {
        CDOBranchPoint oldBranchPoint = this.branchPoint;
        CDOBranch branch = this.session.getBranchManager().getMainBranch();
        if (this.selectBranchComposite != null) {
            branch = this.selectBranchComposite.getBranch();
        }
        long timeStamp = 0L;
        if (this.selectTimeStampComposite != null) {
            timeStamp = this.selectTimeStampComposite.getTimeStamp();
        }
        CDOBranchPoint cDOBranchPoint = this.branchPoint = branch == null ? null : branch.getPoint(timeStamp);
        if (!ObjectUtil.equals((Object)this.branchPoint, (Object)oldBranchPoint)) {
            this.branchPointChanged(this.branchPoint);
        }
    }
}

