/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.efs;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.sql.DataSource;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.location.ICheckoutSource;
import org.eclipse.emf.cdo.location.IRepositoryLocation;
import org.eclipse.emf.cdo.location.IRepositoryLocationManager;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceUtil;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceFileSystem;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceStore;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.io.IOUtil;
import org.h2.jdbcx.JdbcDataSource;

public final class CDOFS {
    private CDOFS() {
    }

    public static CDOWorkspace open(String projectName, File projectFolder) throws Exception {
        IDBStore local = CDOFS.creatLocalStore(projectFolder);
        CDOWorkspaceBase base = CDOFS.createWorkspaceBase(new File(projectFolder, "base"));
        IRepositoryLocation remote = CDOFS.readRepositoryLocation(projectFolder);
        CDOWorkspace workspace = CDOWorkspaceUtil.open((IStore)local, (CDOWorkspaceBase)base, (CDOSessionConfigurationFactory)remote);
        return workspace;
    }

    public static void checkout(ICheckoutSource checkoutSource, String projectName, IProgressMonitor monitor) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            throw new IOException("Project " + projectName + " already exists");
        }
        File projectFolder = root.getLocation().append(projectName).toFile();
        URI uri = CDOFS.checkout(checkoutSource, projectName, projectFolder);
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocationURI(uri);
        project.create(description, (IProgressMonitor)new NullProgressMonitor());
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static URI checkout(ICheckoutSource checkoutSource, String projectName, File projectFolder) throws Exception {
        IDBStore local = CDOFS.creatLocalStore(projectFolder);
        CDOWorkspaceBase base = CDOFS.createWorkspaceBase(new File(projectFolder, "base"));
        IRepositoryLocation remote = checkoutSource.getRepositoryLocation();
        CDOFS.writeRepositoryLocation(projectFolder, remote);
        String branchPath = checkoutSource.getBranchPath();
        long timeStamp = checkoutSource.getTimeStamp();
        CDOWorkspace workspace = CDOWorkspaceUtil.checkout((IStore)local, (CDOWorkspaceBase)base, (CDOSessionConfigurationFactory)remote, (String)branchPath, (long)timeStamp);
        CDOWorkspaceStore store = CDOFS.getFileSystem().addWorkspaceStore(projectName, workspace);
        return store.toURI();
    }

    private static CDOWorkspaceFileSystem getFileSystem() throws CoreException {
        return (CDOWorkspaceFileSystem)EFS.getFileSystem((String)"cdo.workspace");
    }

    private static IDBStore creatLocalStore(File projectFolder) {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)false);
        IDBAdapter dbAdapter = CDOFS.createLocalAdapter();
        IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)CDOFS.createLocalDataSource(new File(projectFolder, "local")));
        IDBStore local = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
        return local;
    }

    private static IDBAdapter createLocalAdapter() {
        return new H2Adapter();
    }

    private static DataSource createLocalDataSource(File folder) {
        folder.mkdirs();
        String path = folder.getAbsolutePath().replace('\\', '/');
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + path + "/db");
        return dataSource;
    }

    private static CDOWorkspaceBase createWorkspaceBase(File folder) {
        folder.mkdirs();
        return CDOWorkspaceUtil.createFolderWorkspaceBase((File)folder);
    }

    private static File getRemotePropertiesFile(File projectFolder) {
        return new File(projectFolder, "remote.properties");
    }

    private static void writeRepositoryLocation(File projectFolder, IRepositoryLocation remote) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(CDOFS.getRemotePropertiesFile(projectFolder));
            remote.write((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Closeable)out);
    }

    private static IRepositoryLocation readRepositoryLocation(File projectFolder) throws IOException {
        IRepositoryLocation iRepositoryLocation;
        FileInputStream in = null;
        try {
            in = new FileInputStream(CDOFS.getRemotePropertiesFile(projectFolder));
            iRepositoryLocation = IRepositoryLocationManager.INSTANCE.addRepositoryLocation((InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
        return iRepositoryLocation;
    }
}

