/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.internal.efs.AbstractResourceNodeStore;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceStore;
import org.eclipse.emf.cdo.workspace.internal.efs.bundle.OM;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOResourceNodeStore
extends AbstractResourceNodeStore {
    private CDOWorkspaceStore workspaceStore;
    private AbstractResourceNodeStore parent;
    private String name;

    public CDOResourceNodeStore(CDOWorkspaceStore workspaceStore, AbstractResourceNodeStore parent, String name) {
        this.workspaceStore = workspaceStore;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public AbstractResourceNodeStore getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return String.valueOf(this.parent.getPath()) + "/" + this.name;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return (InputStream)new AbstractResourceNodeStore.ResourceNodeRunnable<InputStream>((AbstractResourceNodeStore)this){

            @Override
            protected InputStream run(CDOResourceNode node) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CDOResource resource = (CDOResource)node;
                try {
                    resource.save((OutputStream)baos, null);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    throw WrappedException.wrap((Exception)ex);
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }.run();
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                byte[] bytes = this.toByteArray();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                XMIResourceImpl xmiResource = new XMIResourceImpl();
                xmiResource.load((InputStream)in, null);
                String path = CDOResourceNodeStore.this.getPath();
                CDOResourceNodeStore.this.getWorkspaceStore().setLastModified(path, System.currentTimeMillis());
                CDOWorkspaceStore.SaveContext saveContext = CDOResourceNodeStore.this.getWorkspaceStore().getSaveContext();
                saveContext.save((XMIResource)xmiResource, path);
            }
        };
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        new AbstractResourceNodeStore.ResourceNodeRunnable<Boolean>((AbstractResourceNodeStore)this){

            @Override
            protected Boolean run(CDOResourceNode node) {
                try {
                    node.delete(null);
                    return true;
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }.run(true);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        new AbstractResourceNodeStore.ResourceNodeRunnable<CDOResourceFolder>((AbstractResourceNodeStore)this){

            @Override
            protected CDOResourceFolder run(CDOView view) {
                String path = CDOResourceNodeStore.this.getPath();
                return ((CDOTransaction)view).getOrCreateResourceFolder(path);
            }
        }.run(true);
        return this;
    }

    @Override
    public CDOWorkspaceStore getWorkspaceStore() {
        return this.workspaceStore;
    }

    @Override
    protected CDOResourceNode getResourceNode(CDOView view) {
        return view.getResourceNode(this.getPath());
    }

    @Override
    protected boolean isDirectory(CDOResourceNode node) {
        return node instanceof CDOResourceFolder;
    }

    @Override
    protected void collectChildNames(CDOResourceNode node, List<String> childNames) {
        if (node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)node;
            for (CDOResourceNode child : folder.getNodes()) {
                childNames.add(child.getName());
            }
        }
    }
}

